/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.json.jackson.converter;

import java.text.ParseException;
import java.time.OffsetDateTime;
import java.time.YearMonth;
import java.time.ZoneOffset;
import net.osdn.util.json.jackson.converter.AbstractConverter;

public class YearMonthConverter
extends AbstractConverter<YearMonth> {
    @Override
    public YearMonth fromString(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        int dayOfMonth = 1;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int nanoOfSecond = 0;
        ZoneOffset offset = DEFAULT_OFFSET;
        AbstractConverter.ParseResult result = AbstractConverter.DateTimeParser.parse(string);
        if (result.year == null) {
            throw new ParseException(string, 0);
        }
        int year = result.year;
        if (result.month == null) {
            throw new ParseException(string, 0);
        }
        int month = result.month;
        if (result.dayOfMonth != null) {
            dayOfMonth = result.dayOfMonth;
        }
        if (result.hour != null) {
            hour = result.hour;
            if (result.minute != null) {
                minute = result.minute;
            } else {
                throw new ParseException(string, 0);
            }
        }
        if (result.second != null) {
            second = result.second;
        }
        if (result.nanoOfSecond != null) {
            nanoOfSecond = result.nanoOfSecond;
        }
        if (result.offset != null) {
            offset = result.offset;
        }
        OffsetDateTime datetime = OffsetDateTime.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond, offset);
        return YearMonth.from(datetime);
    }

    @Override
    public String toString(YearMonth value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }
}

