/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.json.jackson.converter;

import java.sql.Date;
import java.text.ParseException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import net.osdn.util.json.jackson.converter.AbstractConverter;

public class SqlDateConverter
extends AbstractConverter<Date> {
    @Override
    public Date fromString(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        int hour = 0;
        int minute = 0;
        int second = 0;
        int nanoOfSecond = 0;
        ZoneOffset offset = DEFAULT_OFFSET;
        AbstractConverter.ParseResult result = AbstractConverter.DateTimeParser.parse(string);
        if (result.year == null) {
            throw new ParseException(string, 0);
        }
        int year = result.year;
        if (result.month == null) {
            throw new ParseException(string, 0);
        }
        int month = result.month;
        if (result.dayOfMonth == null) {
            throw new ParseException(string, 0);
        }
        int dayOfMonth = result.dayOfMonth;
        if (result.hour != null) {
            hour = result.hour;
            if (result.minute != null) {
                minute = result.minute;
            } else {
                throw new ParseException(string, 0);
            }
        }
        if (result.second != null) {
            second = result.second;
        }
        if (result.nanoOfSecond != null) {
            nanoOfSecond = result.nanoOfSecond;
        }
        if (result.offset != null) {
            offset = result.offset;
        }
        OffsetDateTime datetime = OffsetDateTime.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond, offset);
        return Date.valueOf(datetime.toLocalDate());
    }

    @Override
    public String toString(Date value) {
        if (value == null) {
            return null;
        }
        return DateTimeFormatter.ISO_LOCAL_DATE.format(value.toLocalDate());
    }
}

