/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.json.jackson.converter;

import java.text.ParseException;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import net.osdn.util.json.jackson.converter.AbstractConverter;

public class OffsetTimeConverter
extends AbstractConverter<OffsetTime> {
    @Override
    public OffsetTime fromString(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        int year = 1970;
        int month = 1;
        int dayOfMonth = 1;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int nanoOfSecond = 0;
        ZoneOffset offset = DEFAULT_OFFSET;
        AbstractConverter.ParseResult result = AbstractConverter.DateTimeParser.parse(string);
        if (result.year != null) {
            year = result.year;
        }
        if (result.month != null) {
            month = result.month;
        }
        if (result.dayOfMonth != null) {
            dayOfMonth = result.dayOfMonth;
        }
        if (result.hour != null) {
            hour = result.hour;
            if (result.minute == null) {
                throw new ParseException(string, 0);
            }
        } else {
            throw new ParseException(string, 0);
        }
        minute = result.minute;
        if (result.second != null) {
            second = result.second;
        }
        if (result.nanoOfSecond != null) {
            nanoOfSecond = result.nanoOfSecond;
        }
        if (result.offset != null) {
            offset = result.offset;
        }
        OffsetDateTime datetime = OffsetDateTime.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond, offset);
        return datetime.toOffsetTime();
    }

    @Override
    public String toString(OffsetTime value) {
        if (value == null) {
            return null;
        }
        return DateTimeFormatter.ISO_OFFSET_TIME.format(value);
    }
}

