/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.json.jackson.converter;

import java.text.ParseException;
import java.time.ZoneOffset;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractConverter<T> {
    protected static final ZoneOffset DEFAULT_OFFSET = ZoneOffset.ofTotalSeconds(TimeZone.getDefault().getRawOffset() / 1000);
    protected static final Pattern DATETIME = Pattern.compile("(?:|(\\d{1,4})[-/](\\d{1,2})(?:|[-/](\\d{1,2})))(?:|(?:(?:^|[ T])(\\d{1,2}):(\\d{1,2})(?:|(?::(\\d{1,2})))(?:|(?:\\.(\\d{1,3})))(?:|(?:([^:\\.].*)))))");

    public abstract T fromString(String var1) throws ParseException;

    public abstract String toString(T var1);

    protected static class DateTimeParser {
        protected DateTimeParser() {
        }

        public static ParseResult parse(String string) throws ParseException {
            ParseResult result = new ParseResult();
            Matcher m = DATETIME.matcher(string);
            if (m.matches()) {
                if (m.group(1) != null) {
                    result.year = Integer.parseInt(m.group(1));
                }
                if (m.group(2) != null) {
                    result.month = Integer.parseInt(m.group(2));
                }
                if (m.group(3) != null) {
                    result.dayOfMonth = Integer.parseInt(m.group(3));
                }
                if (m.group(4) != null) {
                    result.hour = Integer.parseInt(m.group(4));
                    result.minute = Integer.parseInt(m.group(5));
                }
                if (m.group(6) != null) {
                    result.second = Integer.parseInt(m.group(6));
                }
                if (m.group(7) != null) {
                    result.nanoOfSecond = Integer.parseInt((m.group(7) + "000000000").substring(0, 9));
                }
                if (m.group(8) != null) {
                    String tz = m.group(8);
                    if (tz.charAt(0) == ' ') {
                        tz = "+" + tz.substring(1);
                    }
                    result.offset = ZoneOffset.of(tz);
                }
                return result;
            }
            throw new ParseException(string, 0);
        }
    }

    protected static class ParseResult {
        public Integer year;
        public Integer month;
        public Integer dayOfMonth;
        public Integer hour;
        public Integer minute;
        public Integer second;
        public Integer nanoOfSecond;
        public ZoneOffset offset;

        protected ParseResult() {
        }
    }
}

