/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.ikonli;

import java.util.Arrays;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Logger;
import org.kordamp.ikonli.IkonHandler;

public class AbstractIkonResolver {
    private static final String ORG_KORDAMP_IKONLI_STRICT = "org.kordamp.ikonli.strict";
    private static final Logger LOGGER = Logger.getLogger(AbstractIkonResolver.class.getName());

    protected boolean registerHandler(IkonHandler handler, Set<IkonHandler> handlers, Set<IkonHandler> customHandlers) {
        if (this.isLoadedViaClasspath(handler, handlers)) {
            this.throwOrWarn(String.format("IkonHandler for %s is already loaded via classpath", handler.getFontFamily()));
            return false;
        }
        return customHandlers.add(handler);
    }

    protected boolean unregisterHandler(IkonHandler handler, Set<IkonHandler> handlers, Set<IkonHandler> customHandlers) {
        if (this.isLoadedViaClasspath(handler, handlers)) {
            this.throwOrWarn(String.format("IkonHandler for %s was loaded via classpath and can't be unregistered", handler.getFontFamily()));
            return false;
        }
        return customHandlers.remove(handler);
    }

    protected IkonHandler resolve(String value, Set<IkonHandler> handlers, Set<IkonHandler> customHandlers) {
        Objects.requireNonNull(value, "Ikon description must not be null");
        for (Set hs : Arrays.asList(handlers, customHandlers)) {
            for (IkonHandler handler : hs) {
                if (!handler.supports(value)) continue;
                return handler;
            }
        }
        throw new UnsupportedOperationException("Cannot resolve '" + value + "'");
    }

    private boolean isLoadedViaClasspath(IkonHandler handler, Set<IkonHandler> handlers) {
        String fontFamily = handler.getFontFamily();
        for (IkonHandler classpathHandler : handlers) {
            if (!classpathHandler.getFontFamily().equals(fontFamily)) continue;
            return true;
        }
        return false;
    }

    private void throwOrWarn(String message) {
        if (this.strictChecksEnabled()) {
            throw new IllegalArgumentException(message);
        }
        LOGGER.warning(message);
    }

    private boolean strictChecksEnabled() {
        return System.getProperty(ORG_KORDAMP_IKONLI_STRICT) == null || Boolean.getBoolean(ORG_KORDAMP_IKONLI_STRICT);
    }

    public static ServiceLoader<IkonHandler> resolveServiceLoader() {
        ServiceLoader<IkonHandler> handlers;
        if (null != IkonHandler.class.getModule().getLayer() && (handlers = ServiceLoader.load(IkonHandler.class.getModule().getLayer(), IkonHandler.class)).stream().count() > 0L) {
            return handlers;
        }
        handlers = ServiceLoader.load(IkonHandler.class, IkonHandler.class.getClassLoader());
        if (handlers.stream().count() > 0L) {
            return handlers;
        }
        return ServiceLoader.load(IkonHandler.class);
    }
}

