/*
 * Decompiled with CFR 0.152.
 */
package lu.luz.jzopfli;

import lu.luz.jzopfli.BlockSplitter;
import lu.luz.jzopfli.Cache;
import lu.luz.jzopfli.CacheH;
import lu.luz.jzopfli.DeflateH;
import lu.luz.jzopfli.Lz77;
import lu.luz.jzopfli.Lz77H;
import lu.luz.jzopfli.Squeeze;
import lu.luz.jzopfli.Tree;
import lu.luz.jzopfli.Util;
import lu.luz.jzopfli.ZopfliH;

public final class Deflate
extends DeflateH {
    private static final int[] order = new int[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};

    private static void AddBit(boolean bl, byte[] byArray, byte[][] byArray2, int[] nArray) {
        if (byArray[0] == 0) {
            Util.ZOPFLI_APPEND_DATA((byte)0, byArray2, nArray);
        }
        byte[] byArray3 = byArray2[0];
        int n = nArray[0] - 1;
        byArray3[n] = (byte)(byArray3[n] | (bl ? (byte)1 : 0) << byArray[0]);
        byArray[0] = (byte)(byArray[0] + 1 & 7);
    }

    private static void AddBits(int n, int n2, byte[] byArray, byte[][] byArray2, int[] nArray) {
        for (int i = 0; i < n2; ++i) {
            int n3 = n >> i & 1;
            if (byArray[0] == 0) {
                Util.ZOPFLI_APPEND_DATA((byte)0, byArray2, nArray);
            }
            byte[] byArray3 = byArray2[0];
            int n4 = nArray[0] - 1;
            byArray3[n4] = (byte)(byArray3[n4] | n3 << byArray[0]);
            byArray[0] = (byte)(byArray[0] + 1 & 7);
        }
    }

    private static void AddHuffmanBits(int n, int n2, byte[] byArray, byte[][] byArray2, int[] nArray) {
        for (int i = 0; i < n2; ++i) {
            int n3 = n >> n2 - i - 1 & 1;
            if (byArray[0] == 0) {
                Util.ZOPFLI_APPEND_DATA((byte)0, byArray2, nArray);
            }
            byte[] byArray3 = byArray2[0];
            int n4 = nArray[0] - 1;
            byArray3[n4] = (byte)(byArray3[n4] | n3 << byArray[0]);
            byArray[0] = (byte)(byArray[0] + 1 & 7);
        }
    }

    private static void PatchDistanceCodesForBuggyDecoders(int[] nArray) {
        int n = 0;
        for (int i = 0; i < 30; ++i) {
            if (nArray[i] != 0) {
                ++n;
            }
            if (n < 2) continue;
            return;
        }
        if (n == 0) {
            nArray[1] = 1;
            nArray[0] = 1;
        } else if (n == 1) {
            nArray[nArray[0] != 0 ? 1 : 0] = 1;
        }
    }

    private static int EncodeTree(int[] nArray, int[] nArray2, boolean bl, boolean bl2, boolean bl3, byte[] byArray, byte[][] byArray2, int[] nArray3) {
        int n;
        int n2;
        int n3;
        int n4;
        int[][] nArrayArray = new int[][]{{0}};
        int[][] nArrayArray2 = new int[][]{{0}};
        int[] nArray4 = new int[]{0};
        int[] nArray5 = new int[]{0};
        int n5 = 29;
        int[] nArray6 = new int[19];
        int[] nArray7 = new int[19];
        int[] nArray8 = new int[19];
        boolean bl4 = byArray2 == null;
        int n6 = 0;
        for (n4 = 29; n4 > 0 && nArray[257 + n4 - 1] == 0; --n4) {
        }
        while (n5 > 0 && nArray2[1 + n5 - 1] == 0) {
            --n5;
        }
        int n7 = n4 + 257;
        int n8 = n7 + n5 + 1;
        for (n3 = 0; n3 < n8; ++n3) {
            int n9;
            n2 = n3 < n7 ? nArray[n3] : nArray2[n3 - n7];
            int n10 = 1;
            if (bl || n2 == 0 && (bl2 || bl3)) {
                for (int i = n3 + 1; i < n8 && n2 == (i < n7 ? nArray[i] : nArray2[i - n7]); ++i) {
                    ++n10;
                }
            }
            n3 += n10 - 1;
            if (n2 == 0 && n10 >= 3) {
                if (bl3) {
                    while (n10 >= 11) {
                        int n11 = n9 = n10 > 138 ? 138 : n10;
                        if (!bl4) {
                            Util.ZOPFLI_APPEND_DATA(18, nArrayArray, nArray4);
                            Util.ZOPFLI_APPEND_DATA(n9 - 11, nArrayArray2, nArray5);
                        }
                        nArray6[18] = nArray6[18] + 1;
                        n10 -= n9;
                    }
                }
                if (bl2) {
                    while (n10 >= 3) {
                        int n12 = n9 = n10 > 10 ? 10 : n10;
                        if (!bl4) {
                            Util.ZOPFLI_APPEND_DATA(17, nArrayArray, nArray4);
                            Util.ZOPFLI_APPEND_DATA(n9 - 3, nArrayArray2, nArray5);
                        }
                        nArray6[17] = nArray6[17] + 1;
                        n10 -= n9;
                    }
                }
            }
            if (bl && n10 >= 4) {
                --n10;
                int n13 = n2;
                nArray6[n13] = nArray6[n13] + 1;
                if (!bl4) {
                    Util.ZOPFLI_APPEND_DATA(n2, nArrayArray, nArray4);
                    Util.ZOPFLI_APPEND_DATA(0, nArrayArray2, nArray5);
                }
                while (n10 >= 3) {
                    int n14 = n9 = n10 > 6 ? 6 : n10;
                    if (!bl4) {
                        Util.ZOPFLI_APPEND_DATA(16, nArrayArray, nArray4);
                        Util.ZOPFLI_APPEND_DATA(n9 - 3, nArrayArray2, nArray5);
                    }
                    nArray6[16] = nArray6[16] + 1;
                    n10 -= n9;
                }
            }
            int n15 = n2;
            nArray6[n15] = nArray6[n15] + n10;
            while (n10 > 0) {
                if (!bl4) {
                    Util.ZOPFLI_APPEND_DATA(n2, nArrayArray, nArray4);
                    Util.ZOPFLI_APPEND_DATA(0, nArrayArray2, nArray5);
                }
                --n10;
            }
        }
        Tree.ZopfliCalculateBitLengths(nArray6, 19, 7, nArray7);
        if (!bl4) {
            Tree.ZopfliLengthsToSymbols(nArray7, 19, 7, nArray8);
        }
        for (n = 15; n > 0 && nArray6[order[n + 4 - 1]] == 0; --n) {
        }
        if (!bl4) {
            Deflate.AddBits(n4, 5, byArray, byArray2, nArray3);
            Deflate.AddBits(n5, 5, byArray, byArray2, nArray3);
            Deflate.AddBits(n, 4, byArray, byArray2, nArray3);
            for (n3 = 0; n3 < n + 4; ++n3) {
                Deflate.AddBits(nArray7[order[n3]], 3, byArray, byArray2, nArray3);
            }
            for (n3 = 0; n3 < nArray4[0]; ++n3) {
                n2 = nArray8[nArrayArray[0][n3]];
                Deflate.AddHuffmanBits(n2, nArray7[nArrayArray[0][n3]], byArray, byArray2, nArray3);
                if (nArrayArray[0][n3] == 16) {
                    Deflate.AddBits(nArrayArray2[0][n3], 2, byArray, byArray2, nArray3);
                    continue;
                }
                if (nArrayArray[0][n3] == 17) {
                    Deflate.AddBits(nArrayArray2[0][n3], 3, byArray, byArray2, nArray3);
                    continue;
                }
                if (nArrayArray[0][n3] != 18) continue;
                Deflate.AddBits(nArrayArray2[0][n3], 7, byArray, byArray2, nArray3);
            }
        }
        n6 += 14;
        n6 += (n + 4) * 3;
        for (n3 = 0; n3 < 19; ++n3) {
            n6 += nArray7[n3] * nArray6[n3];
        }
        n6 += nArray6[16] * 2;
        n6 += nArray6[17] * 3;
        return n6 += nArray6[18] * 7;
    }

    private static void AddDynamicTree(int[] nArray, int[] nArray2, byte[] byArray, byte[][] byArray2, int[] nArray3) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 8; ++i) {
            int n3 = Deflate.EncodeTree(nArray, nArray2, (i & 1) != 0, (i & 2) != 0, (i & 4) != 0, null, null, null);
            if (n2 != 0 && n3 >= n2) continue;
            n2 = n3;
            n = i;
        }
        Deflate.EncodeTree(nArray, nArray2, n & true, (n & 2) != 0, (n & 4) != 0, byArray, byArray2, nArray3);
    }

    private static int CalculateTreeSize(int[] nArray, int[] nArray2) {
        int n = 0;
        for (int i = 0; i < 8; ++i) {
            int n2 = Deflate.EncodeTree(nArray, nArray2, (i & 1) != 0, (i & 2) != 0, (i & 4) != 0, null, null, null);
            if (n != 0 && n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    private static void AddLZ77Data(char[] cArray, char[] cArray2, int n, int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, byte[] byArray, byte[][] byArray2, int[] nArray5) {
        int n4 = 0;
        for (int i = n; i < n2; ++i) {
            char c = cArray2[i];
            char c2 = cArray[i];
            if (c == '\u0000') {
                assert (c2 < '\u0100');
                assert (nArray2[c2] > 0);
                Deflate.AddHuffmanBits(nArray[c2], nArray2[c2], byArray, byArray2, nArray5);
                ++n4;
                continue;
            }
            int n5 = Util.ZopfliGetLengthSymbol(c2);
            int n6 = Util.ZopfliGetDistSymbol(c);
            assert (c2 >= '\u0003' && c2 <= '\u0120');
            assert (nArray2[n5] > 0);
            assert (nArray4[n6] > 0);
            Deflate.AddHuffmanBits(nArray[n5], nArray2[n5], byArray, byArray2, nArray5);
            Deflate.AddBits(Util.ZopfliGetLengthExtraBitsValue(c2), Util.ZopfliGetLengthExtraBits(c2), byArray, byArray2, nArray5);
            Deflate.AddHuffmanBits(nArray3[n6], nArray4[n6], byArray, byArray2, nArray5);
            Deflate.AddBits(Util.ZopfliGetDistExtraBitsValue(c), Util.ZopfliGetDistExtraBits(c), byArray, byArray2, nArray5);
            n4 += c2;
        }
        assert (n3 == 0 || n4 == n3);
    }

    private static void GetFixedTree(int[] nArray, int[] nArray2) {
        int n;
        for (n = 0; n < 144; ++n) {
            nArray[n] = 8;
        }
        for (n = 144; n < 256; ++n) {
            nArray[n] = 9;
        }
        for (n = 256; n < 280; ++n) {
            nArray[n] = 7;
        }
        for (n = 280; n < 288; ++n) {
            nArray[n] = 8;
        }
        for (n = 0; n < 32; ++n) {
            nArray2[n] = 5;
        }
    }

    private static int CalculateBlockSymbolSize(int[] nArray, int[] nArray2, char[] cArray, char[] cArray2, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            if (cArray2[i] == '\u0000') {
                n3 += nArray[cArray[i]];
                continue;
            }
            n3 += nArray[Util.ZopfliGetLengthSymbol(cArray[i])];
            n3 += nArray2[Util.ZopfliGetDistSymbol(cArray2[i])];
            n3 += Util.ZopfliGetLengthExtraBits(cArray[i]);
            n3 += Util.ZopfliGetDistExtraBits(cArray2[i]);
        }
        return n3 += nArray[256];
    }

    private static int AbsDiff(int n, int n2) {
        if (n > n2) {
            return n - n2;
        }
        return n2 - n;
    }

    private static void OptimizeHuffmanForRle(int n, int[] nArray) {
        int n2;
        int n3;
        while (n >= 0) {
            if (n == 0) {
                return;
            }
            if (nArray[n - 1] != 0) break;
            --n;
        }
        boolean[] blArray = new boolean[n];
        int n4 = nArray[0];
        int n5 = 0;
        for (n3 = 0; n3 < n + 1; ++n3) {
            if (n3 == n || nArray[n3] != n4) {
                if (n4 == 0 && n5 >= 5 || n4 != 0 && n5 >= 7) {
                    for (n2 = 0; n2 < n5; ++n2) {
                        blArray[n3 - n2 - 1] = true;
                    }
                }
                n5 = 1;
                if (n3 == n) continue;
                n4 = nArray[n3];
                continue;
            }
            ++n5;
        }
        n5 = 0;
        int n6 = nArray[0];
        int n7 = 0;
        for (n3 = 0; n3 < n + 1; ++n3) {
            if (n3 == n || blArray[n3] || Deflate.AbsDiff(nArray[n3], n6) >= 4) {
                if (n5 >= 4 || n5 >= 3 && n7 == 0) {
                    int n8 = (n7 + n5 / 2) / n5;
                    if (n8 < 1) {
                        n8 = 1;
                    }
                    if (n7 == 0) {
                        n8 = 0;
                    }
                    for (n2 = 0; n2 < n5; ++n2) {
                        nArray[n3 - n2 - 1] = n8;
                    }
                }
                n5 = 0;
                n7 = 0;
                n6 = n3 < n - 3 ? (nArray[n3] + nArray[n3 + 1] + nArray[n3 + 2] + nArray[n3 + 3] + 2) / 4 : (n3 < n ? nArray[n3] : 0);
            }
            ++n5;
            if (n3 == n) continue;
            n7 += nArray[n3];
        }
    }

    static void GetDynamicLengths(char[] cArray, char[] cArray2, int n, int n2, int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[288];
        int[] nArray4 = new int[32];
        Lz77.ZopfliLZ77Counts(cArray, cArray2, n, n2, nArray3, nArray4);
        Deflate.OptimizeHuffmanForRle(288, nArray3);
        Deflate.OptimizeHuffmanForRle(32, nArray4);
        Tree.ZopfliCalculateBitLengths(nArray3, 288, 15, nArray);
        Tree.ZopfliCalculateBitLengths(nArray4, 32, 15, nArray2);
        Deflate.PatchDistanceCodesForBuggyDecoders(nArray2);
    }

    public static double ZopfliCalculateBlockSize(char[] cArray, char[] cArray2, int n, int n2, int n3) {
        int[] nArray = new int[288];
        int[] nArray2 = new int[32];
        double d = 3.0;
        assert (n3 == 1 || n3 == 2);
        if (n3 == 1) {
            Deflate.GetFixedTree(nArray, nArray2);
        } else {
            Deflate.GetDynamicLengths(cArray, cArray2, n, n2, nArray, nArray2);
            d += (double)Deflate.CalculateTreeSize(nArray, nArray2);
        }
        return d += (double)Deflate.CalculateBlockSymbolSize(nArray, nArray2, cArray, cArray2, n, n2);
    }

    private static void AddLZ77Block(ZopfliH.ZopfliOptions zopfliOptions, int n, boolean bl, char[] cArray, char[] cArray2, int n2, int n3, int n4, byte[] byArray, byte[][] byArray2, int[] nArray) {
        int[] nArray2 = new int[288];
        int[] nArray3 = new int[32];
        int[] nArray4 = new int[288];
        int[] nArray5 = new int[32];
        int n5 = nArray[0];
        int n6 = 0;
        Deflate.AddBit(bl, byArray, byArray2, nArray);
        Deflate.AddBit((n & 1) == 1, byArray, byArray2, nArray);
        Deflate.AddBit((n & 2) >> 1 == 1, byArray, byArray2, nArray);
        if (n == 1) {
            Deflate.GetFixedTree(nArray2, nArray3);
        } else {
            assert (n == 2);
            Deflate.GetDynamicLengths(cArray, cArray2, n2, n3, nArray2, nArray3);
            int n7 = nArray[0];
            Deflate.AddDynamicTree(nArray2, nArray3, byArray, byArray2, nArray);
            if (zopfliOptions.verbose) {
                System.err.printf("treesize: %d\n", nArray[0] - n7);
            }
        }
        Tree.ZopfliLengthsToSymbols(nArray2, 288, 15, nArray4);
        Tree.ZopfliLengthsToSymbols(nArray3, 32, 15, nArray5);
        n5 = nArray[0];
        Deflate.AddLZ77Data(cArray, cArray2, n2, n3, n4, nArray4, nArray2, nArray5, nArray3, byArray, byArray2, nArray);
        Deflate.AddHuffmanBits(nArray4[256], nArray2[256], byArray, byArray2, nArray);
        for (int i = n2; i < n3; ++i) {
            n6 += cArray2[i] == '\u0000' ? 1 : cArray[i];
        }
        int n8 = nArray[0] - n5;
        if (zopfliOptions.verbose) {
            System.err.printf("compressed block size: %d (%dk) (unc: %d)\n", n8, n8 / 1024, n6);
        }
    }

    private static void DeflateDynamicBlock(ZopfliH.ZopfliOptions zopfliOptions, boolean bl, byte[] byArray, int n, int n2, byte[] byArray2, byte[][] byArray3, int[] nArray) {
        Lz77H.ZopfliBlockState zopfliBlockState = new Lz77H.ZopfliBlockState();
        int n3 = n2 - n;
        Lz77H.ZopfliLZ77Store zopfliLZ77Store = new Lz77H.ZopfliLZ77Store();
        int n4 = 2;
        Lz77.ZopfliInitLZ77Store(zopfliLZ77Store);
        zopfliBlockState.options = zopfliOptions;
        zopfliBlockState.blockstart = n;
        zopfliBlockState.blockend = n2;
        zopfliBlockState.lmc = new CacheH.ZopfliLongestMatchCache();
        Cache.ZopfliInitCache(n3, zopfliBlockState.lmc);
        Squeeze.ZopfliLZ77Optimal(zopfliBlockState, byArray, n, n2, zopfliLZ77Store);
        if (zopfliLZ77Store.size[0] < 1000) {
            Lz77H.ZopfliLZ77Store zopfliLZ77Store2 = new Lz77H.ZopfliLZ77Store();
            Lz77.ZopfliInitLZ77Store(zopfliLZ77Store2);
            Squeeze.ZopfliLZ77OptimalFixed(zopfliBlockState, byArray, n, n2, zopfliLZ77Store2);
            double d = Deflate.ZopfliCalculateBlockSize(zopfliLZ77Store.litlens[0], zopfliLZ77Store.dists[0], 0, zopfliLZ77Store.size[0], 2);
            double d2 = Deflate.ZopfliCalculateBlockSize(zopfliLZ77Store2.litlens[0], zopfliLZ77Store2.dists[0], 0, zopfliLZ77Store2.size[0], 1);
            if (d2 < d) {
                n4 = 1;
                Lz77.ZopfliCleanLZ77Store(zopfliLZ77Store);
                zopfliLZ77Store = zopfliLZ77Store2;
            } else {
                Lz77.ZopfliCleanLZ77Store(zopfliLZ77Store2);
            }
        }
        Deflate.AddLZ77Block(zopfliBlockState.options, n4, bl, zopfliLZ77Store.litlens[0], zopfliLZ77Store.dists[0], 0, zopfliLZ77Store.size[0], n3, byArray2, byArray3, nArray);
        Cache.ZopfliCleanCache(zopfliBlockState.lmc);
        Lz77.ZopfliCleanLZ77Store(zopfliLZ77Store);
    }

    private static void DeflateFixedBlock(ZopfliH.ZopfliOptions zopfliOptions, boolean bl, byte[] byArray, int n, int n2, byte[] byArray2, byte[][] byArray3, int[] nArray) {
        Lz77H.ZopfliBlockState zopfliBlockState = new Lz77H.ZopfliBlockState();
        int n3 = n2 - n;
        Lz77H.ZopfliLZ77Store zopfliLZ77Store = new Lz77H.ZopfliLZ77Store();
        Lz77.ZopfliInitLZ77Store(zopfliLZ77Store);
        zopfliBlockState.options = zopfliOptions;
        zopfliBlockState.blockstart = n;
        zopfliBlockState.blockend = n2;
        zopfliBlockState.lmc = new CacheH.ZopfliLongestMatchCache();
        Cache.ZopfliInitCache(n3, zopfliBlockState.lmc);
        Squeeze.ZopfliLZ77OptimalFixed(zopfliBlockState, byArray, n, n2, zopfliLZ77Store);
        Deflate.AddLZ77Block(zopfliBlockState.options, 1, bl, zopfliLZ77Store.litlens[0], zopfliLZ77Store.dists[0], 0, zopfliLZ77Store.size[0], n3, byArray2, byArray3, nArray);
        Cache.ZopfliCleanCache(zopfliBlockState.lmc);
        Lz77.ZopfliCleanLZ77Store(zopfliLZ77Store);
    }

    private static void DeflateNonCompressedBlock(ZopfliH.ZopfliOptions zopfliOptions, boolean bl, byte[] byArray, int n, int n2, byte[] byArray2, byte[][] byArray3, int[] nArray) {
        int n3 = n2 - n;
        int n4 = ~n3;
        assert (n3 < 65536);
        Deflate.AddBit(bl, byArray2, byArray3, nArray);
        Deflate.AddBit(false, byArray2, byArray3, nArray);
        Deflate.AddBit(false, byArray2, byArray3, nArray);
        byArray2[0] = 0;
        Util.ZOPFLI_APPEND_DATA((byte)n3, byArray3, nArray);
        Util.ZOPFLI_APPEND_DATA((byte)(n3 / 256), byArray3, nArray);
        Util.ZOPFLI_APPEND_DATA((byte)n4, byArray3, nArray);
        Util.ZOPFLI_APPEND_DATA((byte)(n4 / 256), byArray3, nArray);
        for (int i = n; i < n2; ++i) {
            Util.ZOPFLI_APPEND_DATA(byArray[i], byArray3, nArray);
        }
    }

    private static void DeflateBlock(ZopfliH.ZopfliOptions zopfliOptions, int n, boolean bl, byte[] byArray, int n2, int n3, byte[] byArray2, byte[][] byArray3, int[] nArray) {
        if (n == 0) {
            Deflate.DeflateNonCompressedBlock(zopfliOptions, bl, byArray, n2, n3, byArray2, byArray3, nArray);
        } else if (n == 1) {
            Deflate.DeflateFixedBlock(zopfliOptions, bl, byArray, n2, n3, byArray2, byArray3, nArray);
        } else {
            assert (n == 2);
            Deflate.DeflateDynamicBlock(zopfliOptions, bl, byArray, n2, n3, byArray2, byArray3, nArray);
        }
    }

    private static void DeflateSplittingFirst(ZopfliH.ZopfliOptions zopfliOptions, int n, boolean bl, byte[] byArray, int n2, int n3, byte[] byArray2, byte[][] byArray3, int[] nArray) {
        int[][] nArrayArray = new int[][]{{0}};
        int[] nArray2 = new int[]{0};
        if (n == 0) {
            BlockSplitter.ZopfliBlockSplitSimple(byArray, n2, n3, 65535, nArrayArray, nArray2);
        } else if (n != 1) {
            BlockSplitter.ZopfliBlockSplit(zopfliOptions, byArray, n2, n3, zopfliOptions.blocksplittingmax, nArrayArray, nArray2);
        }
        for (int i = 0; i <= nArray2[0]; ++i) {
            int n4 = i == 0 ? n2 : nArrayArray[0][i - 1];
            int n5 = i == nArray2[0] ? n3 : nArrayArray[0][i];
            Deflate.DeflateBlock(zopfliOptions, n, i == nArray2[0] && bl, byArray, n4, n5, byArray2, byArray3, nArray);
        }
    }

    private static void DeflateSplittingLast(ZopfliH.ZopfliOptions zopfliOptions, int n, boolean bl, byte[] byArray, int n2, int n3, byte[] byArray2, byte[][] byArray3, int[] nArray) {
        Lz77H.ZopfliBlockState zopfliBlockState = new Lz77H.ZopfliBlockState();
        Lz77H.ZopfliLZ77Store zopfliLZ77Store = new Lz77H.ZopfliLZ77Store();
        int[][] nArrayArray = new int[][]{{0}};
        int[] nArray2 = new int[]{0};
        if (n == 0) {
            Deflate.DeflateSplittingFirst(zopfliOptions, n, bl, byArray, n2, n3, byArray2, byArray3, nArray);
        }
        assert (n == 1 || n == 2);
        Lz77.ZopfliInitLZ77Store(zopfliLZ77Store);
        zopfliBlockState.options = zopfliOptions;
        zopfliBlockState.blockstart = n2;
        zopfliBlockState.blockend = n3;
        zopfliBlockState.lmc = new CacheH.ZopfliLongestMatchCache();
        Cache.ZopfliInitCache(n3 - n2, zopfliBlockState.lmc);
        if (n == 2) {
            Squeeze.ZopfliLZ77Optimal(zopfliBlockState, byArray, n2, n3, zopfliLZ77Store);
        } else {
            assert (n == 1);
            Squeeze.ZopfliLZ77OptimalFixed(zopfliBlockState, byArray, n2, n3, zopfliLZ77Store);
        }
        if (n != 1) {
            BlockSplitter.ZopfliBlockSplitLZ77(zopfliOptions, zopfliLZ77Store.litlens[0], zopfliLZ77Store.dists[0], zopfliLZ77Store.size[0], zopfliOptions.blocksplittingmax, nArrayArray, nArray2);
        }
        for (int i = 0; i <= nArray2[0]; ++i) {
            int n4 = i == 0 ? 0 : nArrayArray[0][i - 1];
            int n5 = i == nArray2[0] ? zopfliLZ77Store.size[0] : nArrayArray[0][i];
            Deflate.AddLZ77Block(zopfliOptions, n, i == nArray2[0] && bl, zopfliLZ77Store.litlens[0], zopfliLZ77Store.dists[0], n4, n5, 0, byArray2, byArray3, nArray);
        }
        Cache.ZopfliCleanCache(zopfliBlockState.lmc);
        Lz77.ZopfliCleanLZ77Store(zopfliLZ77Store);
    }

    public static void ZopfliDeflatePart(ZopfliH.ZopfliOptions zopfliOptions, int n, boolean bl, byte[] byArray, int n2, int n3, byte[] byArray2, byte[][] byArray3, int[] nArray) {
        if (zopfliOptions.blocksplitting) {
            if (zopfliOptions.blocksplittinglast) {
                Deflate.DeflateSplittingLast(zopfliOptions, n, bl, byArray, n2, n3, byArray2, byArray3, nArray);
            } else {
                Deflate.DeflateSplittingFirst(zopfliOptions, n, bl, byArray, n2, n3, byArray2, byArray3, nArray);
            }
        } else {
            Deflate.DeflateBlock(zopfliOptions, n, bl, byArray, n2, n3, byArray2, byArray3, nArray);
        }
    }

    public static void ZopfliDeflate(ZopfliH.ZopfliOptions zopfliOptions, int n, boolean bl, byte[] byArray, int n2, byte[] byArray2, byte[][] byArray3, int[] nArray) {
        int n3;
        for (int i = 0; i < n2; i += n3) {
            boolean bl2 = i + 20000000 >= n2;
            boolean bl3 = bl && bl2;
            n3 = bl2 ? n2 - i : 20000000;
            Deflate.ZopfliDeflatePart(zopfliOptions, n, bl3, byArray, i, i + n3, byArray2, byArray3, nArray);
        }
        if (zopfliOptions.verbose) {
            System.err.printf("Original Size: %d, Deflate: %d, Compression: %f%% Removed\n", n2, nArray[0], 100.0 * (double)(n2 - nArray[0]) / (double)n2);
        }
    }
}

