/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.ikonli.javafx;

import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;

public class FontIconTableCell<S, T>
extends TableCell<S, T> {
    private static final String ERROR_CONVERTER_NULL = "Argument 'converter' must not be null";
    private Subscription subscription;
    private final FontIcon icon;
    private final ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty((Object)this, "converter");

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn() {
        return param -> new FontIconTableCell();
    }

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(StringConverter<T> converter) {
        return param -> new FontIconTableCell(converter);
    }

    public FontIconTableCell() {
        this(new StringConverter<T>(){

            public String toString(T object) {
                return object != null ? String.valueOf(object) : "";
            }

            public T fromString(String string) {
                return null;
            }
        });
    }

    public FontIconTableCell(StringConverter<T> converter) {
        this.getStyleClass().add((Object)"font-icon-table-cell");
        this.icon = new FontIcon();
        this.setConverter(Objects.requireNonNull(converter, ERROR_CONVERTER_NULL));
    }

    public final ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<T> converter) {
        this.converterProperty().set(Objects.requireNonNull(converter, ERROR_CONVERTER_NULL));
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setGraphic(null);
        } else {
            TableColumn column;
            ObservableValue observable;
            if (this.subscription != null) {
                this.subscription.unsubscribe();
                this.subscription = null;
            }
            ObservableValue observableValue = observable = (column = this.getTableColumn()) == null ? null : column.getCellObservableValue(this.getIndex());
            if (observable != null) {
                ChangeListener listener = (v, o, n) -> this.setIconCode(n);
                observable.addListener(listener);
                this.subscription = () -> observable.removeListener(listener);
                this.setIconCode(observable.getValue());
            } else if (item != null) {
                this.setIconCode(item);
            }
            this.setGraphic((Node)this.icon);
            this.setAlignment(Pos.CENTER);
        }
    }

    private void setIconCode(T value) {
        if (value instanceof Ikon) {
            this.icon.setIconCode((Ikon)value);
        } else {
            this.icon.setIconLiteral(this.getConverter().toString(value));
        }
    }

    private static interface Subscription {
        public void unsubscribe();
    }
}

