/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.compiler.expressions.Function;
import com.github.sommeri.less4j.core.compiler.expressions.FunctionsPackage;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.List;
import java.util.Map;

public abstract class BuiltInFunctionsPack
implements FunctionsPackage {
    private final ProblemsHandler problemsHandler;

    public BuiltInFunctionsPack(ProblemsHandler problemsHandler) {
        this.problemsHandler = problemsHandler;
    }

    @Override
    public final boolean canEvaluate(FunctionExpression input, List<Expression> parameters) {
        return this.getFunctions().containsKey(this.normalizeName(input));
    }

    @Override
    public final Expression evaluate(FunctionExpression input, List<Expression> parameters, Expression evaluatedParameter) {
        if (!this.canEvaluate(input, parameters)) {
            return input;
        }
        Function function = this.getFunctions().get(this.normalizeName(input));
        return function.evaluate(parameters, this.problemsHandler, input, evaluatedParameter);
    }

    protected abstract Map<String, Function> getFunctions();

    private String normalizeName(FunctionExpression input) {
        return input.getName().toLowerCase();
    }
}

