/*
 * Decompiled with CFR 0.152.
 */
package com.codewaves.codehighlight.core;

import com.codewaves.codehighlight.core.Keyword;
import com.codewaves.codehighlight.core.Mode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Pattern;

public class Language
extends Mode {
    private static final Pattern emptyLexemePattern = Pattern.compile("\\w+", 8);
    private static final Pattern emptyBeginEndPattern = Pattern.compile("\\B|\\b", 8);
    String[] aliases;
    boolean caseInsensitive;

    public Language aliases(String[] value) {
        this.aliases = value;
        return this;
    }

    public Mode caseInsensitive() {
        this.caseInsensitive = true;
        return this;
    }

    private static String strJoin(String[] arr, String sep) {
        StringBuilder str = new StringBuilder();
        int i = 0;
        int l = arr.length;
        while (i < l) {
            if (i > 0) {
                str.append(sep);
            }
            str.append(arr[i]);
            ++i;
        }
        return str.toString();
    }

    private String langRe(String re) {
        return "(?m" + (this.caseInsensitive ? "i" : "") + ")" + re;
    }

    private Mode[] expandMode(Mode mode) {
        ArrayList<Mode> variants = new ArrayList<Mode>();
        if (mode.variants != null) {
            Mode[] modeArray = mode.variants;
            int n = mode.variants.length;
            int n2 = 0;
            while (n2 < n) {
                Mode variant = modeArray[n2];
                variants.add(Mode.inherit(mode, variant));
                ++n2;
            }
            return variants.toArray(new Mode[variants.size()]);
        }
        if (mode.endsWithParent) {
            return new Mode[]{Language.inherit(mode, null)};
        }
        return new Mode[]{mode};
    }

    private void compileMode(Mode mode, Mode parent) {
        Object childMode;
        int n;
        int n2;
        Object[] objectArray;
        if (mode.compiled) {
            return;
        }
        mode.compiled = true;
        Keyword[] keywordArray = mode.keywords = mode.keywords == null ? mode.beginKeywords : mode.keywords;
        if (mode.keywords != null) {
            HashMap<String, Keyword> compiledKeywords = new HashMap<String, Keyword>();
            objectArray = mode.keywords;
            n2 = mode.keywords.length;
            n = 0;
            while (n < n2) {
                Keyword keywordGroup = objectArray[n];
                String keywords = this.caseInsensitive ? keywordGroup.value.toLowerCase() : keywordGroup.value;
                String[] stringArray = keywords.split(" ");
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String keyword = stringArray[n4];
                    String[] pair = keyword.split("\\|");
                    compiledKeywords.put(pair[0], new Keyword(pair[0], keywordGroup.className, pair.length > 1 ? Integer.valueOf(pair[1]) : 1));
                    ++n4;
                }
                ++n;
            }
            mode.compiledKeywords = compiledKeywords;
        }
        Pattern pattern = mode.lexemesRe = mode.lexemes == null ? emptyLexemePattern : Pattern.compile(this.langRe(mode.lexemes));
        if (parent != null) {
            if (mode.beginKeywords != null) {
                mode.begin = "\\b(" + Language.strJoin(mode.beginKeywords[0].value.split(" "), "|") + ")\\b";
            }
            if (mode.begin == null) {
                mode.begin = "\\B|\\b";
                mode.beginRe = emptyBeginEndPattern;
            } else {
                mode.beginRe = Pattern.compile(this.langRe(mode.begin));
            }
            if (mode.end == null && !mode.endsWithParent) {
                mode.end = "\\B|\\b";
                mode.endRe = emptyBeginEndPattern;
            } else if (mode.end != null && !mode.end.isEmpty()) {
                mode.endRe = Pattern.compile(this.langRe(mode.end));
            }
            String string = mode.terminatorEnd = mode.end == null ? "" : mode.end;
            if (mode.endsWithParent && parent.terminatorEnd != null) {
                mode.terminatorEnd = String.valueOf(mode.terminatorEnd) + (mode.end == null ? "" : "|") + parent.terminatorEnd;
            }
        }
        if (mode.relevance == -1) {
            mode.relevance = 1;
        }
        if (mode.illegal != null) {
            mode.illegalRe = Pattern.compile(this.langRe(mode.illegal));
        }
        if (mode.contains == null) {
            mode.contains = new Mode[0];
        }
        ArrayList<Mode> expandedContains = new ArrayList<Mode>();
        objectArray = mode.contains;
        n2 = mode.contains.length;
        n = 0;
        while (n < n2) {
            childMode = objectArray[n];
            Mode[] chunk = this.expandMode((Mode)(((Mode)childMode).self ? mode : childMode));
            expandedContains.addAll(Arrays.asList(chunk));
            ++n;
        }
        mode.contains = expandedContains.toArray(new Mode[expandedContains.size()]);
        objectArray = mode.contains;
        n2 = mode.contains.length;
        n = 0;
        while (n < n2) {
            childMode = objectArray[n];
            this.compileMode((Mode)childMode, mode);
            ++n;
        }
        if (mode.starts != null) {
            this.compileMode(mode.starts, parent);
        }
        ArrayList<String> terminators = new ArrayList<String>();
        Mode[] modeArray = mode.contains;
        int n5 = mode.contains.length;
        n2 = 0;
        while (n2 < n5) {
            String term;
            Mode childMode2 = modeArray[n2];
            String string = term = childMode2.beginKeywords != null ? "\\.?(" + childMode2.begin + ")\\.?" : childMode2.begin;
            if (term != null && term.length() > 0) {
                terminators.add(term);
            }
            ++n2;
        }
        if (mode.terminatorEnd != null && mode.terminatorEnd.length() > 0) {
            terminators.add(mode.terminatorEnd);
        }
        if (mode.illegal != null && mode.illegal.length() > 0) {
            terminators.add(mode.illegal);
        }
        mode.terminators = terminators.size() > 0 ? Pattern.compile(this.langRe(Language.strJoin(terminators.toArray(new String[terminators.size()]), "|"))) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compile() {
        Class<Language> clazz = Language.class;
        synchronized (Language.class) {
            this.compileMode(this, null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

