/*
 * Decompiled with CFR 0.152.
 */
package com.codewaves.codehighlight.core;

import com.codewaves.codehighlight.core.Highlighter;
import com.codewaves.codehighlight.core.Keyword;
import com.codewaves.codehighlight.core.Language;
import com.codewaves.codehighlight.core.Mode;
import com.codewaves.codehighlight.core.StyleRenderer;
import com.codewaves.codehighlight.core.StyleRendererFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class HighlightParser {
    private Language mLanguage;
    private StyleRendererFactory mRendererFactory;
    private StyleRenderer mBlockRenderer;
    private String mModeBuffer;
    private ParentWrapper mTop;
    private HashMap<String, ParentWrapper> mContinuations;
    private boolean mIgnoreIllegals;
    private int mRelevance;

    HighlightParser(Language language, StyleRendererFactory rendererFactory, StyleRenderer renderer) {
        this.mLanguage = language;
        this.mRendererFactory = rendererFactory;
        this.mBlockRenderer = renderer;
    }

    private boolean testRe(Pattern re, String lexeme) {
        if (re == null) {
            return false;
        }
        Matcher matcher = re.matcher(lexeme);
        return matcher.find() && matcher.start() == 0;
    }

    private Mode subMode(String lexeme, Mode mode) {
        int i = 0;
        int length = mode.contains.length;
        while (i < length) {
            if (this.testRe(mode.contains[i].beginRe, lexeme)) {
                return mode.contains[i];
            }
            ++i;
        }
        return null;
    }

    private void startNewMode(Mode mode) {
        if (mode.className != null) {
            this.mBlockRenderer.onPushStyle(mode.className);
        }
        this.mTop = new ParentWrapper(mode, this.mTop);
    }

    private ParentWrapper endOfMode(ParentWrapper mode, String lexeme) {
        if (this.testRe(((ParentWrapper)mode).mode.endRe, lexeme)) {
            while (((ParentWrapper)mode).mode.endsParent && mode.parent != null) {
                mode = mode.parent;
            }
            return mode;
        }
        if (((ParentWrapper)mode).mode.endsWithParent) {
            return this.endOfMode(mode.parent, lexeme);
        }
        return null;
    }

    private void processBuffer() {
        if (((ParentWrapper)this.mTop).mode.subLanguage != null || ((ParentWrapper)this.mTop).mode.subLanguages != null) {
            this.processSubLanguage();
        } else {
            this.processKeywords();
        }
        this.mModeBuffer = "";
    }

    private boolean isIllegal(String lexeme, Mode mode) {
        return !this.mIgnoreIllegals && this.testRe(mode.illegalRe, lexeme);
    }

    private Keyword keywordMatch(Mode mode, String match) {
        String matchStr;
        String string = matchStr = this.mLanguage.caseInsensitive ? match.toLowerCase() : match;
        if (mode.compiledKeywords != null) {
            return mode.compiledKeywords.get(matchStr);
        }
        return null;
    }

    private void processKeywords() {
        if (((ParentWrapper)this.mTop).mode.compiledKeywords == null) {
            this.mBlockRenderer.onPushCodeBlock(this.mModeBuffer);
            return;
        }
        int lastIndex = 0;
        Matcher matcher = ((ParentWrapper)this.mTop).mode.lexemesRe.matcher(this.mModeBuffer);
        while (matcher.find()) {
            this.mBlockRenderer.onPushCodeBlock(this.mModeBuffer.substring(lastIndex, matcher.start()));
            Keyword keyword = this.keywordMatch(this.mTop.mode, matcher.group());
            if (keyword != null) {
                this.mRelevance += keyword.relevance;
                this.mBlockRenderer.onPushStyle(keyword.className);
                this.mBlockRenderer.onPushCodeBlock(matcher.group());
                this.mBlockRenderer.onPopStyle();
            } else {
                this.mBlockRenderer.onPushCodeBlock(matcher.group());
            }
            lastIndex = matcher.end();
        }
        this.mBlockRenderer.onPushCodeBlock(this.mModeBuffer.substring(lastIndex));
    }

    private void processSubLanguage() {
        String resultLanguage;
        CharSequence resultCode;
        int relevance;
        boolean explicit;
        boolean bl = explicit = ((ParentWrapper)this.mTop).mode.subLanguage != null;
        if (explicit) {
            Language language = Highlighter.findLanguage(((ParentWrapper)this.mTop).mode.subLanguage);
            if (language == null) {
                this.mBlockRenderer.onPushSubLanguage(null, this.mModeBuffer);
                return;
            }
            StyleRenderer renderer = this.mRendererFactory.create(((ParentWrapper)this.mTop).mode.subLanguage);
            HighlightParser parser = new HighlightParser(language, this.mRendererFactory, renderer);
            relevance = parser.highlight(this.mModeBuffer, true, this.mContinuations.get(((ParentWrapper)this.mTop).mode.subLanguage));
            resultCode = renderer.getResult();
            resultLanguage = ((ParentWrapper)this.mTop).mode.subLanguage;
            this.mContinuations.put(((ParentWrapper)this.mTop).mode.subLanguage, parser.mTop);
        } else {
            Highlighter highlighter = new Highlighter(this.mRendererFactory);
            Highlighter.HighlightResult result = highlighter.highlightAuto(this.mModeBuffer, ((ParentWrapper)this.mTop).mode.subLanguages);
            relevance = result.getRelevance();
            resultCode = result.getResult();
            resultLanguage = result.getLanguage();
        }
        if (((ParentWrapper)this.mTop).mode.relevance > 0) {
            this.mRelevance += relevance;
        }
        this.mBlockRenderer.onPushSubLanguage(resultLanguage, resultCode);
    }

    private int processLexeme(String buffer, String lexeme) throws Exception {
        this.mModeBuffer = String.valueOf(this.mModeBuffer) + buffer;
        if (lexeme == null) {
            this.processBuffer();
            return 0;
        }
        Mode newMode = this.subMode(lexeme, this.mTop.mode);
        if (newMode != null) {
            if (newMode.skip) {
                this.mModeBuffer = String.valueOf(this.mModeBuffer) + lexeme;
            } else {
                if (newMode.excludeBegin) {
                    this.mModeBuffer = String.valueOf(this.mModeBuffer) + lexeme;
                }
                this.processBuffer();
                if (!newMode.returnBegin && !newMode.excludeBegin) {
                    this.mModeBuffer = lexeme;
                }
            }
            this.startNewMode(newMode);
            return newMode.returnBegin ? 0 : lexeme.length();
        }
        ParentWrapper endMode = this.endOfMode(this.mTop, lexeme);
        if (endMode != null) {
            Mode origin = this.mTop.mode;
            if (origin.skip) {
                this.mModeBuffer = String.valueOf(this.mModeBuffer) + lexeme;
            } else {
                if (!origin.returnEnd && !origin.excludeEnd) {
                    this.mModeBuffer = String.valueOf(this.mModeBuffer) + lexeme;
                }
                this.processBuffer();
                if (origin.excludeEnd) {
                    this.mModeBuffer = lexeme;
                }
            }
            do {
                if (((ParentWrapper)this.mTop).mode.className != null) {
                    this.mBlockRenderer.onPopStyle();
                }
                if (!((ParentWrapper)this.mTop).mode.skip && ((ParentWrapper)this.mTop).mode.subLanguage == null) {
                    this.mRelevance += ((ParentWrapper)this.mTop).mode.relevance;
                }
                this.mTop = this.mTop.parent;
            } while (this.mTop != endMode.parent);
            if (((ParentWrapper)endMode).mode.starts != null) {
                this.startNewMode(((ParentWrapper)endMode).mode.starts);
            }
            return origin.returnEnd ? 0 : lexeme.length();
        }
        if (this.isIllegal(lexeme, this.mTop.mode)) {
            throw new Exception("Illegal lexeme \"" + lexeme + "\" for mode \"" + ((ParentWrapper)this.mTop).mode.className + "\"");
        }
        this.mModeBuffer = String.valueOf(this.mModeBuffer) + lexeme;
        return lexeme.length() > 0 ? lexeme.length() : 1;
    }

    int highlight(String code, boolean ignoreIllegals, ParentWrapper continuation) {
        try {
            Matcher matcher;
            this.mBlockRenderer.onStart();
            this.mLanguage.compile();
            this.mModeBuffer = "";
            this.mIgnoreIllegals = ignoreIllegals;
            this.mRelevance = 0;
            this.mTop = continuation == null ? new ParentWrapper(this.mLanguage, null) : continuation;
            this.mContinuations = new HashMap();
            ArrayList<String> stack = new ArrayList<String>();
            ParentWrapper current = this.mTop;
            while (current != null && current.mode != this.mLanguage) {
                if (((ParentWrapper)current).mode.className != null) {
                    stack.add(0, ((ParentWrapper)current).mode.className);
                }
                current = current.parent;
            }
            for (String className : stack) {
                this.mBlockRenderer.onPushStyle(className);
            }
            int index = 0;
            while (((ParentWrapper)this.mTop).mode.terminators != null && (matcher = ((ParentWrapper)this.mTop).mode.terminators.matcher(code)).find(index)) {
                int count = this.processLexeme(code.substring(index, matcher.start()), matcher.group());
                index = matcher.start() + count;
            }
            this.processLexeme(code.substring(index), null);
            ParentWrapper current2 = this.mTop;
            while (current2.parent != null) {
                if (((ParentWrapper)current2).mode.className != null) {
                    this.mBlockRenderer.onPopStyle();
                }
                current2 = current2.parent;
            }
            this.mBlockRenderer.onFinish();
        }
        catch (Exception e) {
            this.mBlockRenderer.onAbort(code);
            this.mRelevance = 0;
        }
        return this.mRelevance;
    }

    private static class ParentWrapper {
        private Mode mode;
        private ParentWrapper parent;

        private ParentWrapper(Mode mode, ParentWrapper parent) {
            this.mode = mode;
            this.parent = parent;
        }
    }
}

