﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace c4ju
{
    #region フィルター
    class FilterAttribute
    {
        public string Name;
        public string Value;
        public CSharpEval Eval;
        public WorstInfo Worst = null;
    };
    class Filter
    {
        public string TestName;
        public string strXPath;
        public List<FilterAttribute> list;
    };
    class WorstInfo
    {
        public string Name;
        public string file;
        public int line;
        public float Value = 0;
    };
    #endregion

    class FilterBuilder
    {
        public static List<Filter> Build(string xmlpath)
        {
            XmlDocument doc_filter = new XmlDocument();

            try
            {
                doc_filter.Load(xmlpath);
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
                return null;
            }

            if (doc_filter.ChildNodes.Count == 0)
            {
                Console.WriteLine("not found filter.");
                return null;
            }
            XmlNode ccccNode = doc_filter.SelectSingleNode("//CCCC_Project");
            if (ccccNode == null)
            {
                Console.WriteLine("not found CCCC_Project node.");
                return null;
            }
            List<string> filter_xpaths = XmlToXPathList.Convert(ccccNode);
            if (filter_xpaths.Count == 0)
            {
                Console.WriteLine("not found test filter.");
                return null;
            }
            List<Filter> filter_list = new List<Filter>();
            foreach (string xpath in filter_xpaths)
            {
                Filter f = new Filter();
                XmlNode filter_node = doc_filter.SelectSingleNode(xpath);
                f.TestName = filter_node.ParentNode.Name + "/" + filter_node.Name + " : ";
                f.strXPath = xpath;
                f.list = new List<FilterAttribute>();
                foreach (XmlAttribute attr in filter_node.Attributes)
                {
                    FilterAttribute a = new FilterAttribute();
                    a.Name = attr.Name;
                    a.Value = attr.Value;
                    a.Eval = new CSharpEval();
                    if (!a.Eval.Init(attr.Value))
                    {
                        Console.WriteLine("Evaluation of the filter expression is invalid xml.");
                        return null;
                    }
                    f.list.Add(a);
                }
                filter_list.Add(f);
            }
            return filter_list;
        }
    }
}

#region XmlToXPathList
class XmlToXPathList
{
    public static List<string> Convert(XmlNode node)
    {
        List<string> list = new List<string>();
        if (node.ChildNodes.Count == 0)
        {
            if (node.NodeType == XmlNodeType.Element)
            {
                string path = node.Name;
                XmlNode p = node.ParentNode;
                while (p != null && p.ParentNode != null)
                {
                    path = p.Name + "/" + path;
                    p = p.ParentNode;
                }
                path = "//" + path;
                list.Add(path);
            }
        }
        foreach (XmlNode n in node.ChildNodes)
        {
            list.AddRange(Convert(n));
        }
        return list;
    }
    public static List<string> Convert(XmlDocument doc)
    {
        List<string> list = new List<string>();

        foreach (XmlNode n in doc.ChildNodes)
        {
            list.AddRange(Convert(n));
        }
        return list;
    }
}

#endregion
