/*
 * Copyright 2011 BitMeister Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.bitmeister.asn1.type.builtin;

import java.util.List;

import jp.bitmeister.asn1.annotation.ASN1BuiltIn;
import jp.bitmeister.asn1.annotation.ASN1Identifier;
import jp.bitmeister.asn1.annotation.ASN1Tag;
import jp.bitmeister.asn1.annotation.ASN1XmlTypeName;
import jp.bitmeister.asn1.processor.ASN1Visitor;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1TagMode;

/**
 * Represents ASN.1 'RELATIVE-OID' type.
 * 
 * <p>
 * An instance of this class represents an 'RELATIVE-OID' type data and
 * contains a {@code List} of {@code Integer}. Each element of the {@code List}
 * represents an object id component.
 * </p>
 * 
 * @author WATANABE, Jun. <jwat at bitmeister.jp>
 */
@ASN1BuiltIn
@ASN1Identifier("RELATIVE-OID")
@ASN1XmlTypeName("RELATIVE_OID")
@ASN1Tag(tagClass = ASN1TagClass.UNIVERSAL, value = 13, tagMode = ASN1TagMode.IMPLICIT)
public class RELATIVE_OID extends OBJECT_IDENTIFIER {
	
	/**
	 * Instantiates an empty {@code RELATIVE_OID}.
	 */
	public RELATIVE_OID() {
	}

	/**
	 * Instantiates an {@code RELATIVE_OID} and initialize it with the
	 * {@code List<Integer>} value.
	 * 
	 * @param value
	 *            the {@code List} of {@code Integer} represents an object
	 *            identifier.
	 */
	public RELATIVE_OID(List<Integer> value) {
		set(value);
	}

	/**
	 * Instantiates an {@code RELATIVE_OID} and initialize it with the
	 * array of {@code int} value.
	 * 
	 * @param value
	 *            the array of {@code int} represents an object identifier.
	 */
	public RELATIVE_OID(int... value) {
		set(value);
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * jp.bitmeister.asn1.type.ASN1Type#accept(jp.bitmeister.asn1.processor.
	 * ASN1Visitor)
	 */
	@Override
	public <R, E extends Throwable> R accept(ASN1Visitor<R, E> visitor) throws E {
		return visitor.visit(this);
	}

}
