/*
 * Copyright 2011 BitMeister Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.bitmeister.asn1.type;

import java.lang.reflect.Field;

import jp.bitmeister.asn1.annotation.ASN1Element;

/**
 * Specification of an element that contained in a {@code ConstructiveType}.
 * 
 * <p>
 * An instance of this class contains static information of an element contained
 * in a {@code ConstructiveType}.
 * </p>
 * 
 * @author WATANABE, Jun. <jwat at bitmeister.jp>
 * 
 * @see ConstructiveType
 */
public class ElementSpecification extends NamedTypeSpecification {

	private ASN1Element specification;

	/**
	 * Instantiates an {@code ElementSpecification}.
	 * 
	 * @param field
	 *            The ASN.1 element field.
	 */
	ElementSpecification(ASN1Element specification, Field field) {
		super(specification.value(), field);
		this.specification = specification;
	}

	/**
	 * Tests if this element is optional.
	 * 
	 * @return {@code true} when this element is optional.
	 */
	public boolean optional() {
		return specification.optional();
	}

	/**
	 * Tests if this element has default value.
	 * 
	 * @return {@code true} when this element has default value.
	 */
	public boolean hasDefault() {
		return specification.hasDefault();
	}

}
