/*
 * Copyright 2011 BitMeister Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.bitmeister.asn1.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Indicates xml type name for an ASN.1 type.
 * 
 * <p>
 * If an {@code @ASN1XmlTypeName} annotation is present on a type,
 * this value is used as xml tag name instead of their class name that taken
 * by calling {@code Class.getSimpleName()} when the XER encoding process.
 * If an ASN.1 identifier includes whitespace, this annotation shall be used.
 * </p>
 * 
 * @author WATANABE, Jun. <jwat at bitmeister.jp>
 */

@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface ASN1XmlTypeName {

	/**
	 * Indicates the xml tag name for this ASN.1 type.
	 * 
	 * @return The xml tag name.
	 */
	public String value();
	
}
