/*
 * Copyright 2011 BitMeister Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.bitmeister.asn1.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Indicates that a type is extendable SET, SEQUENCE or CHOICE.
 * 
 * <p>
 * If an {@code @ASN1Extendable} annotation is present on a SET, SEQUENCE or
 * CHOICE type class, the class can be base class for other SET, SEQUENCE or
 * CHOICE type class. This annotation will be used for defining common attribute
 * or method to some of SET, SEQUENCE or CHOICE classes by using class
 * inheritance. A type annotated as {@code @ASN1Extendable} can't define own
 * elements.
 * </p>
 * <p>
 * For example : <code><pre>
 * &#064;ASN1Extendable
 * public class IdentifiableSequence extends SEQUENCE {
 * 
 * 	private ID id;
 * 
 * 	public ID getID() {
 * 		return id;
 * 	}
 * 	
 * 	public void SetID(ID id) {
 * 		this.id = id;
 * 	}
 * 
 * }
 * 
 * public class User extends IdentifiableSequence {
 * 
 * 	&#064;ASN1ElementType(0)
 * 	public INTEGER userNo;
 * 
 * 	&#064;ASN1ElementType(value = 1, optional = true)
 * 	public PrintableString userName;
 * 
 * }
 * 
 * </pre></code>
 * 
 * </p>
 * 
 * @author WATANABE, Jun. <jwat at bitmeister.jp>
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface ASN1Extendable {
}
