/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.wizard.shareproject;

import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.utility.TableViewerSorter;
import org.polarion.team.svn.ui.wizard.AbstractVerifiedWizardPage;

public class SelectRepositoryLocationPage
extends AbstractVerifiedWizardPage {
    protected boolean useExistingLocation;
    protected IRepositoryLocation location;
    protected TableViewer repositoriesView;
    protected IRepositoryLocation[] repositories;
    protected boolean importProject;
    static /* synthetic */ Class class$0;

    public SelectRepositoryLocationPage(IRepositoryLocation[] repositories) {
        this(repositories, false);
    }

    public SelectRepositoryLocationPage(IRepositoryLocation[] repositories, boolean importProject) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.polarion.team.svn.ui.wizard.shareproject.SelectRepositoryLocationPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(clazz.getName(), SVNTeamUIPlugin.instance().getResource("SelectRepositoryLocationPage.Title" + SelectRepositoryLocationPage.getNationalizationSuffix(importProject)), SVNTeamUIPlugin.instance().getImageDescriptor("icons/wizards/newconnect.gif"));
        this.setDescription(SVNTeamUIPlugin.instance().getResource("SelectRepositoryLocationPage.Description"));
        this.repositories = repositories;
        this.useExistingLocation = true;
        this.location = this.repositories[0];
        this.importProject = importProject;
    }

    protected Composite createControlImpl(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Label description = new Label(composite, 64);
        data = new GridData(768);
        data.widthHint = 200;
        data.heightHint = this.convertHeightInCharsToPixels(2);
        description.setLayoutData((Object)data);
        description.setText(SVNTeamUIPlugin.instance().getResource("SelectRepositoryLocationPage.Hint" + SelectRepositoryLocationPage.getNationalizationSuffix(this.importProject)));
        Button addLocationButton = new Button(composite, 16);
        data = new GridData(768);
        addLocationButton.setText(SVNTeamUIPlugin.instance().getResource("SelectRepositoryLocationPage.AddLocation"));
        addLocationButton.setSelection(false);
        Button useExistingLocationButton = new Button(composite, 16);
        data = new GridData(768);
        useExistingLocationButton.setLayoutData((Object)data);
        useExistingLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                SelectRepositoryLocationPage.this.useExistingLocation = button.getSelection();
                SelectRepositoryLocationPage.this.repositoriesView.getTable().setEnabled(SelectRepositoryLocationPage.this.useExistingLocation);
                SelectRepositoryLocationPage.this.setPageComplete(true);
            }
        });
        useExistingLocationButton.setText(SVNTeamUIPlugin.instance().getResource("SelectRepositoryLocationPage.UseLocation"));
        useExistingLocationButton.setSelection(true);
        Table table = new Table(composite, 68356);
        data = new GridData(1808);
        data.heightHint = 200;
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tLayout = new TableLayout();
        tLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        tLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(70, true));
        table.setLayout((Layout)tLayout);
        this.repositoriesView = new TableViewer(table);
        TableViewerSorter sorter = new TableViewerSorter(this.repositoriesView, new TableViewerSorter.IColumnComparator(){

            public int compare(Object row1, Object row2, int column) {
                IRepositoryLocation location1 = (IRepositoryLocation)row1;
                IRepositoryLocation location2 = (IRepositoryLocation)row2;
                if (column == 0) {
                    return TableViewerSorter.compare(location1.getLabel(), location2.getLabel());
                }
                return TableViewerSorter.compare(location1.getUrl(), location2.getUrl());
            }
        });
        this.repositoriesView.setSorter((ViewerSorter)sorter);
        TableColumn col = new TableColumn(table, 16384);
        col.setResizable(true);
        col.setText("Label");
        col.addSelectionListener((SelectionListener)sorter);
        col = new TableColumn(table, 16384);
        col.setResizable(true);
        col.setText("URL");
        col.addSelectionListener((SelectionListener)sorter);
        sorter.setDefaultColumn(0);
        this.repositoriesView.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return SelectRepositoryLocationPage.this.repositories;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.repositoriesView.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                IRepositoryLocation location = (IRepositoryLocation)element;
                if (columnIndex == 0) {
                    return location.getLabel();
                }
                return location.getUrlAsIs();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.repositoriesView.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)SelectRepositoryLocationPage.this.repositoriesView.getSelection();
                SelectRepositoryLocationPage.this.location = (IRepositoryLocation)selection.getFirstElement();
                SelectRepositoryLocationPage.this.setPageComplete(true);
            }
        });
        this.repositoriesView.setInput((Object)this.repositories);
        this.repositoriesView.getTable().select(0);
        IStructuredSelection selection = (IStructuredSelection)this.repositoriesView.getSelection();
        this.location = (IRepositoryLocation)selection.getFirstElement();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.polarion.team.svn.help.reposLocationContext");
        return composite;
    }

    public boolean useExistingLocation() {
        return this.useExistingLocation;
    }

    public IRepositoryLocation getRepositoryLocation() {
        return this.useExistingLocation() ? this.location : null;
    }

    protected static String getNationalizationSuffix(boolean importProject) {
        return "." + (importProject ? "Import" : "Share");
    }
}

