/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.wizard;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;
import org.polarion.team.svn.ui.wizard.AbstractSVNWizard;
import org.polarion.team.svn.ui.wizard.shareproject.AddRepositoryLocationPage;

public class NewRepositoryLocationWizard
extends AbstractSVNWizard
implements INewWizard {
    protected AddRepositoryLocationPage locationPage;
    protected IRepositoryLocation editable;
    protected boolean performAction;
    protected IRepositoryLocation backup;

    public NewRepositoryLocationWizard() {
        this(null, true);
    }

    public NewRepositoryLocationWizard(IRepositoryLocation editable, boolean performAction) {
        this.performAction = performAction;
        this.editable = editable;
        if (this.editable != null) {
            this.setWindowTitle(SVNTeamUIPlugin.instance().getResource("NewRepositoryLocationWizard.Title.Edit"));
            this.backup = SVNRemoteStorage.instance().newRepositoryLocation();
            SVNRemoteStorage.instance().copyRepositoryLocation(this.backup, editable);
        } else {
            this.setWindowTitle(SVNTeamUIPlugin.instance().getResource("NewRepositoryLocationWizard.Title.New"));
        }
    }

    public void addPages() {
        this.locationPage = new AddRepositoryLocationPage(this.editable);
        this.addPage((IWizardPage)this.locationPage);
    }

    public IActionOperation getOperationToPerform() {
        return this.locationPage.getOperationToPeform();
    }

    public boolean performCancel() {
        if (this.editable != null) {
            SVNRemoteStorage.instance().copyRepositoryLocation(this.editable, this.backup);
        }
        return super.performCancel();
    }

    public boolean performFinish() {
        if (this.locationPage.performFinish()) {
            IActionOperation op;
            if (this.performAction && (op = this.locationPage.getOperationToPeform()) != null) {
                UIMonitorUtility.doTaskBusyDefault(op);
            }
            return true;
        }
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

