/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.wizard;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.wizard.AbstractSVNWizard;
import org.polarion.team.svn.ui.wizard.CheckoutAsWizard;
import org.polarion.team.svn.ui.wizard.checkoutas.SelectCheckoutResourcePage;
import org.polarion.team.svn.ui.wizard.shareproject.AddRepositoryLocationPage;
import org.polarion.team.svn.ui.wizard.shareproject.SelectRepositoryLocationPage;

public class ImportFromSVNWizard
extends AbstractSVNWizard
implements INewWizard {
    protected SelectRepositoryLocationPage selectLocation;
    protected AddRepositoryLocationPage addLocation;
    protected SelectCheckoutResourcePage selectResource;

    public ImportFromSVNWizard() {
        this.setWindowTitle(SVNTeamUIPlugin.instance().getResource("ImportFromSVNWizard.Title"));
    }

    public void addPages() {
        IRepositoryLocation[] locations = SVNRemoteStorage.instance().getRepositoryLocations();
        if (locations.length > 0) {
            this.selectLocation = new SelectRepositoryLocationPage(locations, true);
            this.addPage((IWizardPage)this.selectLocation);
        }
        this.addLocation = new AddRepositoryLocationPage();
        this.addPage((IWizardPage)this.addLocation);
        this.selectResource = new SelectCheckoutResourcePage();
        this.addPage((IWizardPage)this.selectResource);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage retVal = null;
        this.addLocation.setInitialUrl(null);
        retVal = page instanceof SelectRepositoryLocationPage && this.selectLocation.useExistingLocation() ? super.getNextPage(super.getNextPage(page)) : super.getNextPage(page);
        if (retVal instanceof SelectCheckoutResourcePage) {
            this.selectResource.setRepositoryLocation(this.selectLocation != null && this.selectLocation.useExistingLocation() ? this.selectLocation.getRepositoryLocation() : this.addLocation.getRepositoryLocation());
        }
        return retVal;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page instanceof SelectCheckoutResourcePage && this.selectLocation != null && this.selectLocation.useExistingLocation()) {
            return super.getPreviousPage(super.getPreviousPage(page));
        }
        return super.getPreviousPage(page);
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        return currentPage instanceof SelectCheckoutResourcePage && this.selectResource.isPageComplete();
    }

    public boolean performFinish() {
        IRepositoryResource[] resources = this.selectResource.getSelectedResources();
        CheckoutAsWizard checkoutWizard = new CheckoutAsWizard(resources, this.addLocation.getOperationToPeform());
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)checkoutWizard);
        dialog.create();
        dialog.getShell().setSize(Math.max(570, dialog.getShell().getSize().x), 500);
        return dialog.open() == 0;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

