/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.verifier;

import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Control;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.verifier.AbstractFormattedVerifier;

public class MultiLinePropertyVerifier
extends AbstractFormattedVerifier {
    protected static String ERROR_MESSAGE_INVALID_FORMAT = "Field '$FIELD_NAME$' contains malformed property in line ";

    public MultiLinePropertyVerifier(String fieldName) {
        super(fieldName);
        ERROR_MESSAGE_INVALID_FORMAT = SVNTeamUIPlugin.instance().getResource("Verifier.MultiLineProperty.Main");
    }

    protected String getErrorMessageImpl(Control input) {
        String[] properties = this.getText(input).split(System.getProperty("line.separator"));
        int i = 0;
        while (i < properties.length) {
            if (properties[i].length() != 0) {
                String[] nestedProperties = properties[i].split(";");
                int j = 0;
                while (j < nestedProperties.length) {
                    String retVal;
                    String property = nestedProperties[j].trim();
                    if (property.length() != 0 && (retVal = this.validateProperty(property, i)) != null) {
                        return retVal;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    protected String getWarningMessageImpl(Control input) {
        return null;
    }

    protected String validateProperty(String property, int line) {
        if (property.indexOf("=") != property.lastIndexOf("=")) {
            return String.valueOf(this.formatMainMessage(line)) + " " + SVNTeamUIPlugin.instance().getResource("Verifier.MultiLineProperty.ManyEquals");
        }
        String[] propNameValue = property.split("=");
        if (propNameValue.length == 0 || propNameValue[0].length() == 0) {
            return String.valueOf(this.formatMainMessage(line)) + " " + SVNTeamUIPlugin.instance().getResource("Verifier.MultiLineProperty.NameIsEmpty");
        }
        Pattern pattern = Pattern.compile("[a-zA-Z].*");
        if (!pattern.matcher(propNameValue[0]).matches()) {
            return String.valueOf(this.formatMainMessage(line)) + " " + SVNTeamUIPlugin.instance().getResource("Verifier.MultiLineProperty.NotALetter");
        }
        pattern = Pattern.compile("[a-zA-Z0-9:\\-_.]*");
        if (!pattern.matcher(propNameValue[0]).matches()) {
            return String.valueOf(this.formatMainMessage(line)) + " " + SVNTeamUIPlugin.instance().getResource("Verifier.MultiLineProperty.InvalidNameChar");
        }
        if (property.indexOf("=") != -1) {
            if (propNameValue.length == 1 || propNameValue[1].length() == 0) {
                return String.valueOf(this.formatMainMessage(line)) + " " + SVNTeamUIPlugin.instance().getResource("Verifier.MultiLineProperty.EmptyValue");
            }
            if (propNameValue[1].indexOf(";") != -1) {
                return String.valueOf(this.formatMainMessage(line)) + " " + SVNTeamUIPlugin.instance().getResource("Verifier.MultiLineProperty.InvalidValueChar");
            }
        }
        return null;
    }

    protected String formatMainMessage(int line) {
        return MessageFormat.format(ERROR_MESSAGE_INVALID_FORMAT, "$FIELD_NAME$", String.valueOf(line + 1));
    }
}

