/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.utility;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TableColumn;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;

public class TableViewerSorter
extends ViewerSorter
implements SelectionListener {
    public static final int INVALID_COLUMN = -1;
    public static final int ORDER_NONE = 0;
    public static final int ORDER_NORMAL = 1;
    public static final int ORDER_REVERSED = 2;
    public static boolean CASE_INSENSITIVE = true;
    protected List order;
    protected TableViewer basedOn;
    protected IColumnComparator comparator;
    protected IPropertyChangeListener configurationListener;
    protected long enabledColumns;

    public TableViewerSorter(TableViewer basedOn, IColumnComparator comparator) {
        this.basedOn = basedOn;
        this.comparator = comparator;
        this.order = new ArrayList();
        this.enabledColumns = -1L;
        final IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        CASE_INSENSITIVE = SVNTeamPreferences.getTableSortingBoolean(store, "case.insensitive");
        this.configurationListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals(SVNTeamPreferences.fullTableSortingName("case.insensitive"))) {
                    CASE_INSENSITIVE = SVNTeamPreferences.getTableSortingBoolean(store, "case.insensitive");
                    if (!TableViewerSorter.this.basedOn.getControl().isDisposed()) {
                        TableViewerSorter.this.basedOn.refresh();
                    } else {
                        store.removePropertyChangeListener((IPropertyChangeListener)this);
                    }
                }
            }
        };
        store.addPropertyChangeListener(this.configurationListener);
    }

    public long getEnabledColumns() {
        return this.enabledColumns;
    }

    public void setEnabledColumns(long enabledColumns) {
        this.enabledColumns = enabledColumns;
    }

    public static int compare(String first, String second) {
        return CASE_INSENSITIVE ? first.compareToIgnoreCase(second) : first.compareTo(second);
    }

    public void setDefaultColumn(int defaultColumn) {
        if (defaultColumn > -1) {
            if ((this.enabledColumns & (long)(1 << defaultColumn)) == 0L) {
                int i = 0;
                while (i < 64) {
                    if ((this.enabledColumns & (long)(1 << i)) != 0L) {
                        defaultColumn = i;
                        break;
                    }
                    ++i;
                }
            }
            this.showOrdering(this.basedOn.getTable().getColumn(defaultColumn), this.changeOrdering(defaultColumn, false));
        }
    }

    public TableViewer getBasedOn() {
        return this.basedOn;
    }

    public IColumnComparator getColumnComparator() {
        return this.comparator;
    }

    public void widgetSelected(SelectionEvent e) {
        TableColumn widget = (TableColumn)e.widget;
        int column = this.basedOn.getTable().indexOf(widget);
        if ((this.enabledColumns & (long)(1 << column)) != 0L) {
            this.showOrdering(widget, this.changeOrdering(column, false));
            this.basedOn.refresh();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        TableColumn widget = (TableColumn)e.widget;
        int column = this.basedOn.getTable().indexOf(widget);
        if ((this.enabledColumns & (long)(1 << column)) != 0L) {
            this.showOrdering(widget, this.changeOrdering(column, true));
            this.basedOn.refresh();
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        Iterator it = this.order.iterator();
        while (it.hasNext()) {
            OrderPair pair = (OrderPair)it.next();
            int cmpResult = this.comparator.compare(e1, e2, pair.column);
            if (cmpResult == 0) continue;
            return pair.order == 1 ? cmpResult : cmpResult * -1;
        }
        return 0;
    }

    public int getOrdering(int column) {
        OrderPair info = this.findOrderPair(column);
        return info == null ? 0 : info.order;
    }

    public void setOrdering(int column, int order) {
        OrderPair info = this.findOrderPair(column);
        if (info != null) {
            if (order == 0) {
                this.order.remove(info);
            } else {
                info.order = order;
            }
        } else if (order != 0) {
            this.order.add(new OrderPair(column, order));
        }
    }

    public OrderChangePair changeOrdering(int column, boolean drop) {
        int oldOrder;
        OrderPair info = this.findOrderPair(column);
        this.order.clear();
        int n = oldOrder = info == null ? 0 : info.order;
        if (info == null) {
            info = new OrderPair(column, 1);
        } else {
            if (drop) {
                return new OrderChangePair(oldOrder, 0);
            }
            if (info.order == 1) {
                info.order = 2;
            } else if (info.order == 2) {
                info.order = 1;
            }
        }
        this.order.add(info);
        return new OrderChangePair(oldOrder, info.order);
    }

    public void sort(final Viewer viewer, Object[] elements) {
        FileUtility.sort((Object[])elements, (Comparator)new Comparator(){

            public int compare(Object a, Object b) {
                return TableViewerSorter.this.compare(viewer, a, b);
            }
        });
    }

    protected void showOrdering(TableColumn column, OrderChangePair orderChange) {
        int direction = orderChange.newOrder == 0 ? 0 : (orderChange.newOrder == 1 ? 128 : 1024);
        this.basedOn.getTable().setSortColumn(column);
        this.basedOn.getTable().setSortDirection(direction);
    }

    protected OrderPair findOrderPair(int column) {
        Iterator it = this.order.iterator();
        while (it.hasNext()) {
            OrderPair pair = (OrderPair)it.next();
            if (pair.column != column) continue;
            return pair;
        }
        return null;
    }

    public static interface IColumnComparator {
        public int compare(Object var1, Object var2, int var3);
    }

    public class OrderChangePair {
        public final int oldOrder;
        public final int newOrder;

        public OrderChangePair(int oldOrder, int newOrder) {
            this.oldOrder = oldOrder;
            this.newOrder = newOrder;
        }
    }

    protected class OrderPair {
        public int column;
        public int order;

        public OrderPair(int column, int order) {
            this.column = column;
            this.order = order;
        }

        public String toString() {
            return String.valueOf(String.valueOf(this.column)) + "=" + this.order;
        }
    }
}

