/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.utility;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.IRevisionProvider;
import org.polarion.team.svn.core.operation.local.AddToSVNWithPropertiesOperation;
import org.polarion.team.svn.core.operation.local.ClearLocalStatusesOperation;
import org.polarion.team.svn.core.operation.local.CommitOperation;
import org.polarion.team.svn.core.operation.local.IUnresolvedConflictDetector;
import org.polarion.team.svn.core.operation.local.RefreshResourcesOperation;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.ui.action.IResourceSelector;
import org.polarion.team.svn.ui.extension.ExtensionsManager;
import org.polarion.team.svn.ui.operation.ClearUpdateStatusesOperation;
import org.polarion.team.svn.ui.operation.NotifyUnresolvedConflictOperation;

public class CommitActionUtility {
    protected IResourceSelector selector;
    protected HashSet newNonRecursive;
    protected HashSet newRecursive;
    protected HashSet parents;
    protected IResource[] allResources;
    protected HashSet allResourcesSet;

    public CommitActionUtility(IResourceSelector selector) {
        this.initialize(selector);
    }

    public void initialize(IResourceSelector selector) {
        this.selector = selector;
        this.newNonRecursive = new HashSet<IResource>(Arrays.asList(this.selector.getSelectedResources(IStateFilter.SF_IGNORED)));
        this.newRecursive = new HashSet<IResource>(Arrays.asList(this.selector.getSelectedResourcesRecursive(IStateFilter.SF_NEW)));
        HashSet fullSet = new HashSet(this.newNonRecursive);
        fullSet.addAll(this.newRecursive);
        this.parents = new HashSet<IResource>(Arrays.asList(FileUtility.getOperableParents((IResource[])fullSet.toArray(new IResource[fullSet.size()]), (IStateFilter)IStateFilter.SF_NONVERSIONED)));
        this.newNonRecursive.addAll(this.parents);
        fullSet.addAll(this.parents);
        this.allResourcesSet = new HashSet(fullSet);
        this.allResourcesSet.addAll(Arrays.asList(this.selector.getSelectedResourcesRecursive(IStateFilter.SF_COMMITABLE)));
        this.allResources = this.allResourcesSet.toArray(new IResource[this.allResourcesSet.size()]);
        this.allResourcesSet.addAll(Arrays.asList(FileUtility.addOperableParents((IResource[])this.allResources, (IStateFilter)IStateFilter.SF_ADDED, (boolean)true)));
        this.allResources = this.allResourcesSet.toArray(new IResource[this.allResourcesSet.size()]);
    }

    public HashSet getAllResourcesSet() {
        return this.allResourcesSet;
    }

    public IResource[] getAllResources() {
        return this.allResources;
    }

    public CompositeOperation getCompositeCommitOperation(IResource[] selectedResources, String message, boolean keepLocks, Shell shell, IWorkbenchPart part) {
        return this.getNonRecursiveImpl(selectedResources, message, keepLocks, shell, part);
    }

    public CompositeOperation getCompositeCommitOperation(IResource[] selectedResources, IResource[] notSelectedResources, String message, boolean keepLocks, Shell shell, IWorkbenchPart part, boolean tryRecursive) {
        return tryRecursive ? this.getRecursiveImpl(selectedResources, notSelectedResources, message, keepLocks, shell, part) : this.getNonRecursiveImpl(selectedResources, message, keepLocks, shell, part);
    }

    protected CompositeOperation getRecursiveImpl(IResource[] selectedResources, IResource[] notSelectedResources, String message, boolean keepLocks, Shell shell, IWorkbenchPart part) {
        IResource[] notSelectedNew = FileUtility.getResourcesRecursive((IResource[])notSelectedResources, (IStateFilter)IStateFilter.SF_NONVERSIONED, (int)0);
        boolean allowsRecursiveAdd = true;
        int i = 0;
        while (i < notSelectedNew.length) {
            if (this.newRecursive.remove(notSelectedNew[i])) {
                allowsRecursiveAdd = false;
            } else if (!this.parents.contains(notSelectedNew[i])) {
                this.newNonRecursive.remove(notSelectedNew[i]);
            }
            ++i;
        }
        CommitOperation mainOp = new CommitOperation(selectedResources, message, allowsRecursiveAdd && notSelectedNew.length == notSelectedResources.length, keepLocks);
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        if (allowsRecursiveAdd) {
            if (this.newNonRecursive.size() > 0) {
                IResource[] newNonRecursive = this.newNonRecursive.toArray(new IResource[this.newNonRecursive.size()]);
                op.add((IActionOperation)new AddToSVNWithPropertiesOperation(newNonRecursive, false));
                op.add((IActionOperation)new ClearLocalStatusesOperation(newNonRecursive));
            }
            if (this.newRecursive.size() > 0) {
                IResource[] newRecursive = this.newRecursive.toArray(new IResource[this.newRecursive.size()]);
                op.add((IActionOperation)new AddToSVNWithPropertiesOperation(newRecursive, true));
                op.add((IActionOperation)new ClearLocalStatusesOperation(newRecursive));
            }
        } else {
            this.newNonRecursive.addAll(this.newRecursive);
            this.newRecursive.clear();
            IResource[] newNonRecursive = this.newNonRecursive.toArray(new IResource[this.newNonRecursive.size()]);
            op.add((IActionOperation)new AddToSVNWithPropertiesOperation(newNonRecursive, false));
            op.add((IActionOperation)new ClearLocalStatusesOperation(newNonRecursive));
        }
        this.addCommonPart(selectedResources, op, mainOp, shell, part);
        return op;
    }

    protected CompositeOperation getNonRecursiveImpl(IResource[] selectedResources, String message, boolean keepLocks, Shell shell, IWorkbenchPart part) {
        CommitOperation mainOp = new CommitOperation(selectedResources, message, false, keepLocks);
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        IResource[] newResources = FileUtility.getResourcesRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_NONVERSIONED, (int)0);
        if (newResources.length > 0) {
            op.add((IActionOperation)new AddToSVNWithPropertiesOperation(newResources, false));
            op.add((IActionOperation)new ClearLocalStatusesOperation(newResources));
        }
        this.addCommonPart(selectedResources, op, mainOp, shell, part);
        return op;
    }

    protected void addCommonPart(IResource[] selectedResources, CompositeOperation op, CommitOperation mainOp, Shell shell, IWorkbenchPart part) {
        op.add((IActionOperation)mainOp);
        op.add((IActionOperation)new ClearUpdateStatusesOperation(selectedResources));
        op.add((IActionOperation)new RefreshResourcesOperation(selectedResources));
        op.add((IActionOperation)new NotifyUnresolvedConflictOperation((IUnresolvedConflictDetector)mainOp));
        ExtensionsManager.getInstance().getCurrentCommitFactory().performAfterCommitTasks(op, (IRevisionProvider)mainOp, null, part);
    }
}

