/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.synchronize.variant;

import java.text.MessageFormat;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.ui.synchronize.variant.ResourceVariant;

public abstract class RemoteResourceVariant
extends ResourceVariant {
    protected static String svnAuthor;
    protected static String svnNoAuthor;

    public RemoteResourceVariant(ILocalResource local) {
        super(local);
        svnAuthor = SVNTeamPlugin.instance().getResource("SVNInfo.Author");
        svnNoAuthor = SVNTeamPlugin.instance().getResource("SVNInfo.NoAuthor");
    }

    protected String getCacheId() {
        return "Remote: " + super.getCacheId();
    }

    public String getContentIdentifier() {
        if (IStateFilter.SF_PREREPLACED.accept(this.local.getResource(), this.local.getStatus(), this.local.getChangeMask())) {
            return "";
        }
        String retVal = super.getContentIdentifier();
        if (!this.isNotOnRepository() || this.local.isCopied()) {
            retVal = String.valueOf(retVal) + " " + (this.local.getAuthor() == null ? svnNoAuthor : MessageFormat.format(svnAuthor, this.local.getAuthor()));
        }
        return retVal;
    }
}

