/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.synchronize.variant;

import java.io.ByteArrayInputStream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.client.Status;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.remote.GetFileContentOperation;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IResourceChange;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.synchronize.variant.RemoteResourceVariant;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class RemoteFileVariant
extends RemoteResourceVariant {
    public RemoteFileVariant(ILocalResource local) {
        super(local);
    }

    protected void fetchContents(IProgressMonitor monitor) throws TeamException {
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        if (!this.local.isCopied() && this.local.getRevision() == -1L || IStateFilter.SF_DELETED.accept(this.local.getResource(), this.local.getStatus(), this.local.getChangeMask()) && !IStateFilter.SF_REPLACED.accept(this.local.getResource(), this.local.getStatus(), this.local.getChangeMask())) {
            this.setContents(new ByteArrayInputStream(new byte[0]), monitor);
            return;
        }
        IRepositoryResource remote = null;
        if (this.local.isCopied()) {
            IRepositoryLocation location = storage.getRepositoryLocation(this.local.getResource());
            Status st = SVNUtility.getSVNInfoForNotConnected((IResource)this.local.getResource());
            remote = location.asRepositoryFile(st.urlCopiedFrom, false);
            remote.setSelectedRevision(Revision.getInstance((long)st.revisionCopiedFrom));
            remote.setPegRevision(Revision.getInstance((long)st.revisionCopiedFrom));
        } else {
            IRepositoryResource originator;
            remote = SVNRemoteStorage.instance().asRepositoryResource(this.local.getResource());
            if (this.local instanceof IResourceChange && (originator = ((IResourceChange)this.local).getOriginator()) != null) {
                remote = originator;
            }
            remote.setSelectedRevision(Revision.getInstance((long)this.local.getRevision()));
            remote.setPegRevision(((IResourceChange)this.local).getPegRevision());
        }
        GetFileContentOperation op = new GetFileContentOperation(remote);
        UIMonitorUtility.doTaskExternalDefault((IActionOperation)op, monitor);
        if (op.getExecutionState() == 0) {
            this.setContents(op.getContent(), monitor);
        }
    }

    public boolean isContainer() {
        return false;
    }
}

