/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.synchronize.update.action;

import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.polarion.team.svn.ui.synchronize.action.ISyncStateFilter;
import org.polarion.team.svn.ui.synchronize.update.UpdateSyncInfo;
import org.polarion.team.svn.ui.utility.UnacceptableOperationNotificator;

public class UpdateAction
extends AbstractSynchronizeModelAction {
    protected boolean advancedMode;

    public UpdateAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
        this.advancedMode = false;
    }

    public UpdateAction(String text, ISynchronizePageConfiguration configuration, ISelectionProvider selectionProvider) {
        super(text, configuration, selectionProvider);
        this.advancedMode = true;
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{8, 12}){

            public boolean select(SyncInfo info) {
                if (super.select(info)) {
                    UpdateSyncInfo sync = (UpdateSyncInfo)info;
                    return !IStateFilter.SF_OBSTRUCTED.accept(sync.getLocal(), sync.getLocalResource().getStatus(), sync.getLocalResource().getChangeMask());
                }
                return false;
            }
        };
    }

    protected IActionOperation execute(final AbstractSynchronizeModelAction.FilteredSynchronizeModelOperation operation) {
        IResource[] resources = UnacceptableOperationNotificator.shrinkResourcesWithNotOnRespositoryParents(operation.getShell(), operation.getSelectedResourcesRecursive(ISyncStateFilter.SF_ONREPOSITORY));
        if (resources == null || resources.length == 0) {
            return null;
        }
        final IResource[] missing = FileUtility.getResourcesRecursive((IResource[])(resources = FileUtility.addOperableParents((IResource[])resources, (IStateFilter)IStateFilter.SF_NONVERSIONED)), (IStateFilter)IStateFilter.SF_MISSING);
        if (missing.length > 0) {
            final boolean[] retVal = new boolean[1];
            operation.getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    retVal[0] = org.polarion.team.svn.ui.action.local.UpdateAction.updateMissing(operation.getShell(), missing);
                }
            });
            if (!retVal[0]) {
                return null;
            }
        }
        if (this.advancedMode) {
            String message;
            if (resources.length == 1) {
                message = SVNTeamUIPlugin.instance().getResource("UpdateAll.Message.Single");
            } else {
                message = SVNTeamUIPlugin.instance().getResource("UpdateAll.Message.Multi");
                message = MessageFormat.format(message, String.valueOf(resources.length));
            }
            final MessageDialog dlg = new MessageDialog(operation.getShell(), SVNTeamUIPlugin.instance().getResource("UpdateAll.Title"), null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            operation.getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    dlg.open();
                }
            });
            if (dlg.getReturnCode() != 0) {
                return null;
            }
        }
        return org.polarion.team.svn.ui.action.local.UpdateAction.getUpdateOperation(operation.getShell(), resources);
    }
}

