/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.synchronize.update.action;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.resource.ILocalFile;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IResourceChange;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.ui.operation.LocalShowAnnotationOperation;
import org.polarion.team.svn.ui.operation.RemoteShowAnnotationOperation;
import org.polarion.team.svn.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.polarion.team.svn.ui.synchronize.action.ISyncStateFilter;
import org.polarion.team.svn.ui.synchronize.update.UpdateSyncInfo;
import org.polarion.team.svn.ui.synchronize.variant.ResourceVariant;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class ShowAnnotationAction
extends AbstractSynchronizeModelAction {
    public ShowAnnotationAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        super.updateSelection(selection);
        if (selection.size() != 1 || !(selection.getFirstElement() instanceof SyncInfoModelElement)) {
            return false;
        }
        SyncInfoModelElement element = (SyncInfoModelElement)selection.getFirstElement();
        UpdateSyncInfo sync = (UpdateSyncInfo)element.getSyncInfo();
        ILocalResource outgoing = sync.getLocalResource();
        ResourceVariant incoming = (ResourceVariant)sync.getRemote();
        return outgoing instanceof ILocalFile && (ISyncStateFilter.SF_ONREPOSITORY.accept(outgoing.getResource(), outgoing.getStatus(), outgoing.getChangeMask()) || !IStateFilter.SF_NOTEXISTS.accept(incoming.getResource().getResource(), incoming.getStatus(), incoming.getResource().getChangeMask()));
    }

    protected IActionOperation execute(final AbstractSynchronizeModelAction.FilteredSynchronizeModelOperation operation) {
        return new AbstractNonLockingOperation("Operation.UShowAnnotation"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                operation.getShell().getDisplay().syncExec(new Runnable(this, operation){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ AbstractSynchronizeModelAction.FilteredSynchronizeModelOperation val$operation;
                    {
                        this.this$1 = var1_1;
                        this.val$operation = filteredSynchronizeModelOperation;
                    }

                    public void run() {
                        IResource resource = this.val$operation.getSelectedResource();
                        ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
                        if (local != null && IStateFilter.SF_ONREPOSITORY.accept(resource, local.getStatus(), local.getChangeMask())) {
                            UIMonitorUtility.doTaskBusyDefault((IActionOperation)new LocalShowAnnotationOperation(resource, this.val$operation.getPart().getSite().getPage()));
                        }
                        IResourceChange change = (IResourceChange)((ResourceVariant)this.val$operation.getSVNSyncInfo().getRemote()).getResource();
                        IRepositoryResource remote = SVNRemoteStorage.instance().asRepositoryResource(resource);
                        remote.setPegRevision(change.getPegRevision());
                        remote.setSelectedRevision(Revision.getInstance((long)change.getRevision()));
                        UIMonitorUtility.doTaskBusyDefault((IActionOperation)new RemoteShowAnnotationOperation(remote, this.val$operation.getPart().getSite().getPage()));
                    }
                });
            }
        };
    }
}

