/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.synchronize.update.action;

import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.local.RefreshResourcesOperation;
import org.polarion.team.svn.core.operation.local.RevertOperation;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.panel.local.RevertPanel;
import org.polarion.team.svn.ui.synchronize.AbstractSVNSyncInfo;
import org.polarion.team.svn.ui.synchronize.action.AbstractSynchronizeModelAction;

public class RevertAction
extends AbstractSynchronizeModelAction {
    public RevertAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter(){

            public boolean select(SyncInfo info) {
                AbstractSVNSyncInfo sync = (AbstractSVNSyncInfo)info;
                return IStateFilter.SF_REVERTABLE.accept(sync.getLocal(), sync.getLocalResource().getStatus(), sync.getLocalResource().getChangeMask());
            }
        };
    }

    protected IActionOperation execute(final AbstractSynchronizeModelAction.FilteredSynchronizeModelOperation operation) {
        final IResource[][] resources = new IResource[1][];
        operation.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                IResource[] changedResources = operation.getSelectedResourcesRecursive(IStateFilter.SF_REVERTABLE);
                IResource[] userSelectedResources = operation.getSelectedResources();
                RevertPanel panel = new RevertPanel(changedResources, userSelectedResources);
                DefaultDialog rDlg = new DefaultDialog(operation.getShell(), panel);
                if (rDlg.open() == 0) {
                    resources[0] = panel.getSelectedResources();
                }
            }
        });
        if (resources[0] == null) {
            return null;
        }
        RevertOperation mainOp = new RevertOperation(resources[0], false);
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        op.add((IActionOperation)mainOp);
        op.add((IActionOperation)new RefreshResourcesOperation(resources[0]));
        return op;
    }
}

