/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.synchronize.update.action;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.local.ClearLocalStatusesOperation;
import org.polarion.team.svn.core.operation.local.DetectDeletedProjectsOperation;
import org.polarion.team.svn.core.operation.local.RefreshResourcesOperation;
import org.polarion.team.svn.core.operation.local.RemoveNonVersionedResourcesOperation;
import org.polarion.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.polarion.team.svn.core.operation.local.RevertOperation;
import org.polarion.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.polarion.team.svn.core.operation.local.UpdateOperation;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.operation.ClearUpdateStatusesOperation;
import org.polarion.team.svn.ui.operation.ProcessDeletedProjectsOperation;
import org.polarion.team.svn.ui.panel.local.OverrideResourcesPanel;
import org.polarion.team.svn.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.polarion.team.svn.ui.synchronize.action.ISyncStateFilter;
import org.polarion.team.svn.ui.utility.UnacceptableOperationNotificator;

public class OverrideAndUpdateAction
extends AbstractSynchronizeModelAction {
    public OverrideAndUpdateAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{4, 12});
    }

    protected IActionOperation execute(final AbstractSynchronizeModelAction.FilteredSynchronizeModelOperation operation) {
        final IResource[][] resources = new IResource[1][];
        operation.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                IResource[] obstructedResources = operation.getSelectedResources(IStateFilter.SF_OBSTRUCTED);
                obstructedResources = FileUtility.addOperableParents((IResource[])obstructedResources, (IStateFilter)IStateFilter.SF_OBSTRUCTED);
                HashSet<IResource> allResources = new HashSet<IResource>(Arrays.asList(obstructedResources));
                IResource[] changedResources = operation.getSelectedResources(ISyncStateFilter.SF_OVERRIDE);
                changedResources = UnacceptableOperationNotificator.shrinkResourcesWithNotOnRespositoryParents(operation.getShell(), changedResources);
                if (changedResources != null) {
                    changedResources = FileUtility.addOperableParents((IResource[])changedResources, (IStateFilter)IStateFilter.SF_NOTONREPOSITORY);
                    allResources.addAll(Arrays.asList(changedResources));
                }
                if (allResources.size() > 0) {
                    IResource[] fullSet = allResources.toArray(new IResource[allResources.size()]);
                    OverrideResourcesPanel panel = new OverrideResourcesPanel(fullSet, fullSet, 1);
                    DefaultDialog dialog = new DefaultDialog(operation.getShell(), panel);
                    if (dialog.open() == 0) {
                        resources[0] = panel.getSelectedResources();
                    }
                }
            }
        });
        if (resources[0] == null) {
            return null;
        }
        CompositeOperation op = new CompositeOperation("Operation.UOverrideAndUpdate");
        final DetectDeletedProjectsOperation detectOp = new DetectDeletedProjectsOperation(resources[0]);
        op.add((IActionOperation)detectOp);
        SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation((IResourceProvider)detectOp);
        op.add((IActionOperation)saveOp);
        RevertOperation revertOp = new RevertOperation(new IResourceProvider(){

            public IResource[] getResources() {
                return FileUtility.getResourcesRecursive((IResource[])detectOp.getResources(), (IStateFilter)IStateFilter.SF_REVERTABLE, (int)0);
            }
        }, true);
        RemoveNonVersionedResourcesOperation removeNonVersionedResourcesOp = new RemoveNonVersionedResourcesOperation((IResourceProvider)detectOp, true);
        op.add((IActionOperation)revertOp);
        op.add((IActionOperation)new ClearLocalStatusesOperation(resources[0]));
        op.add((IActionOperation)removeNonVersionedResourcesOp);
        RevertOperation revertOp1 = new RevertOperation(FileUtility.getResourcesRecursive((IResource[])resources[0], (IStateFilter)IStateFilter.SF_OBSTRUCTED, (int)0), true);
        op.add((IActionOperation)revertOp1);
        op.add((IActionOperation)new ClearLocalStatusesOperation(resources[0]));
        op.add((IActionOperation)new UpdateOperation(new IResourceProvider(){

            public IResource[] getResources() {
                return FileUtility.getResourcesRecursive((IResource[])detectOp.getResources(), (IStateFilter)new IStateFilter(this){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public boolean accept(IResource resource, String state, int mask) {
                        return IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask) || IStateFilter.SF_NOTEXISTS.accept(resource, state, mask);
                    }

                    public boolean allowsRecursion(IResource resource, String state, int mask) {
                        return true;
                    }
                }, (int)0);
            }
        }, true), new IActionOperation[]{revertOp, revertOp1, removeNonVersionedResourcesOp});
        op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
        op.add((IActionOperation)new ProcessDeletedProjectsOperation(detectOp));
        op.add((IActionOperation)new ClearUpdateStatusesOperation(resources[0]));
        op.add((IActionOperation)new RefreshResourcesOperation(resources[0]));
        return op;
    }
}

