/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.synchronize.update.action;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.local.MarkAsMergedOperation;
import org.polarion.team.svn.core.operation.local.RefreshResourcesOperation;
import org.polarion.team.svn.core.resource.ILocalFile;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.ui.operation.ClearUpdateStatusesOperation;
import org.polarion.team.svn.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.polarion.team.svn.ui.synchronize.update.UpdateSyncInfo;
import org.polarion.team.svn.ui.synchronize.variant.ResourceVariant;
import org.polarion.team.svn.ui.utility.UnacceptableOperationNotificator;

public class MarkAsMergedAction
extends AbstractSynchronizeModelAction {
    public MarkAsMergedAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{12}){

            public boolean select(SyncInfo info) {
                if (super.select(info)) {
                    UpdateSyncInfo sync = (UpdateSyncInfo)info;
                    boolean localIsFile = sync.getLocalResource().getResource() instanceof IFile;
                    boolean remoteIsFile = ((ResourceVariant)sync.getRemote()).getResource() instanceof ILocalFile;
                    return !IStateFilter.SF_OBSTRUCTED.accept(sync.getLocal(), sync.getLocalResource().getStatus(), sync.getLocalResource().getChangeMask()) && localIsFile == remoteIsFile;
                }
                return false;
            }
        };
    }

    protected IActionOperation execute(AbstractSynchronizeModelAction.FilteredSynchronizeModelOperation operation) {
        IResource[] resources = UnacceptableOperationNotificator.shrinkResourcesWithNotOnRespositoryParents(operation.getShell(), operation.getSelectedResources());
        if (resources == null || resources.length == 0) {
            return null;
        }
        MarkAsMergedOperation mainOp = new MarkAsMergedOperation(resources, false, null);
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        op.add((IActionOperation)mainOp);
        op.add((IActionOperation)new ClearUpdateStatusesOperation(resources));
        op.add((IActionOperation)new RefreshResourcesOperation(FileUtility.getParents((IResource[])resources, (boolean)false)));
        return op;
    }
}

