/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.synchronize.update.action;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.local.AddToSVNIgnoreOperation;
import org.polarion.team.svn.core.operation.local.AddToSVNOperation;
import org.polarion.team.svn.core.operation.local.ClearLocalStatusesOperation;
import org.polarion.team.svn.core.operation.local.RefreshResourcesOperation;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.panel.AbstractDialogPanel;
import org.polarion.team.svn.ui.panel.local.AddToSVNPanel;
import org.polarion.team.svn.ui.panel.local.IgnoreMethodPanel;
import org.polarion.team.svn.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.polarion.team.svn.ui.synchronize.update.UpdateSyncInfo;

public class AddToSVNIgnoreAction
extends AbstractSynchronizeModelAction {
    protected static IStateFilter SF_NEW_AND_PARENT_VERSIONED = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            if (state == "New") {
                SVNRemoteStorage storage;
                ILocalResource localParent;
                IContainer parent = resource.getParent();
                if (resource != null && parent != null && (localParent = (storage = SVNRemoteStorage.instance()).asLocalResource((IResource)parent)) != null) {
                    return IStateFilter.SF_VERSIONED.accept((IResource)parent, localParent.getStatus(), localParent.getChangeMask());
                }
            }
            return false;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return true;
        }
    };

    public AddToSVNIgnoreAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter(){

            public boolean select(SyncInfo info) {
                UpdateSyncInfo sync = (UpdateSyncInfo)info;
                return SF_NEW_AND_PARENT_VERSIONED.accept(sync.getLocal(), sync.getLocalResource().getStatus(), sync.getLocalResource().getChangeMask());
            }
        };
    }

    protected IActionOperation execute(AbstractSynchronizeModelAction.FilteredSynchronizeModelOperation operation) {
        AbstractDialogPanel panel;
        final IResource[][] resources = new IResource[][]{FileUtility.shrinkChildNodes((IResource[])operation.getSelectedResources(SF_NEW_AND_PARENT_VERSIONED))};
        final IResource[][] operableParents = new IResource[][]{FileUtility.getOperableParents((IResource[])resources[0], (IStateFilter)IStateFilter.SF_NONVERSIONED)};
        if (operableParents[0].length > 0) {
            panel = new AddToSVNPanel(operableParents[0]);
            final DefaultDialog dialog1 = new DefaultDialog(operation.getShell(), panel);
            operation.getShell().getDisplay().syncExec(new Runnable((AddToSVNPanel)panel){
                private final /* synthetic */ AddToSVNPanel val$panel;
                {
                    this.val$panel = addToSVNPanel;
                }

                public void run() {
                    operableParents[0] = dialog1.open() != 0 ? null : this.val$panel.getSelectedResources();
                }
            });
            if (operableParents[0] == null) {
                return null;
            }
        }
        panel = new IgnoreMethodPanel(resources[0]);
        final DefaultDialog dialog = new DefaultDialog(operation.getShell(), panel);
        operation.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                if (dialog.open() != 0) {
                    resources[0] = null;
                }
            }
        });
        if (resources[0] == null) {
            return null;
        }
        AddToSVNIgnoreOperation mainOp = new AddToSVNIgnoreOperation(resources[0], ((IgnoreMethodPanel)panel).getIgnoreType(), ((IgnoreMethodPanel)panel).getIgnorePattern());
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        if (operableParents[0].length > 0) {
            op.add((IActionOperation)new AddToSVNOperation(operableParents[0]));
            op.add((IActionOperation)new ClearLocalStatusesOperation(operableParents[0]));
        }
        op.add((IActionOperation)mainOp);
        HashSet<IResource> tmp = new HashSet<IResource>(Arrays.asList(resources[0]));
        int i = 0;
        while (i < resources[0].length) {
            tmp.add((IResource)resources[0][i].getParent());
            ++i;
        }
        IResource[] resourcesAndParents = tmp.toArray(new IResource[tmp.size()]);
        op.add((IActionOperation)new RefreshResourcesOperation(resourcesAndParents));
        return op;
    }
}

