/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.synchronize.update;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.client.Status;
import org.polarion.team.svn.core.operation.local.IRemoteStatusOperation;
import org.polarion.team.svn.core.operation.local.RemoteStatusOperation;
import org.polarion.team.svn.core.resource.IChangeStateProvider;
import org.polarion.team.svn.core.resource.ICommentProvider;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRemoteStorage;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IResourceChange;
import org.polarion.team.svn.core.svnstorage.CommentProvider;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.synchronize.AbstractSVNSubscriber;
import org.polarion.team.svn.ui.synchronize.update.UpdateSyncInfo;
import org.polarion.team.svn.ui.utility.IOperationWrapperFactory;

public class UpdateSubscriber
extends AbstractSVNSubscriber {
    private static UpdateSubscriber instance = null;
    protected Map comments = new HashMap();

    public static synchronized UpdateSubscriber instance() {
        if (instance == null) {
            instance = new UpdateSubscriber();
        }
        return instance;
    }

    protected IRemoteStatusOperation getStatusOperation(IResource[] resources, int depth) {
        return new RemoteStatusOperation(resources);
    }

    protected SyncInfo getSVNSyncInfo(IRemoteStorage storage, ILocalResource localStatus, IResourceChange remoteStatus) {
        return new UpdateSyncInfo(localStatus, (ILocalResource)remoteStatus, this.getResourceComparator());
    }

    protected IResourceChange handleResourceChange(IRemoteStorage storage, IRemoteStatusOperation rStatusOp, final Status current) {
        if (current.textStatus == 13) {
            return null;
        }
        final IResource[] scope = rStatusOp.getScope();
        IChangeStateProvider provider = new IChangeStateProvider(){

            public long getChangeDate() {
                return current.reposLastCmtRevision == -1L ? current.lastChangedDate : current.reposLastCmtDate;
            }

            public String getChangeAuthor() {
                return current.reposLastCmtRevision == -1L ? current.lastCommitAuthor : current.reposLastCmtAuthor;
            }

            public Revision.Number getChangeRevision() {
                long changeRev = current.reposLastCmtRevision == -1L ? current.lastChangedRevision : current.reposLastCmtRevision;
                return changeRev == -1L ? null : (Revision.Number)Revision.getInstance((long)changeRev);
            }

            public int getTextChangeType() {
                return current.repositoryTextStatus;
            }

            public int getPropertiesChangeType() {
                return current.repositoryPropStatus;
            }

            public int getNodeKind() {
                int kind = SVNUtility.getNodeKind((String)current.path, (int)current.nodeKind, (boolean)true);
                return kind == 0 ? SVNUtility.getNodeKind((String)current.path, (int)current.reposKind, (boolean)true) : kind;
            }

            public String getLocalPath() {
                return current.path;
            }

            public String getComment() {
                return null;
            }

            public boolean isCopied() {
                return current.isCopied;
            }

            public boolean isSwitched() {
                return current.isSwitched;
            }

            public IResource getExact(IResource[] set) {
                return FileUtility.selectOneOf((IResource[])scope, (IResource[])set);
            }
        };
        if (provider.getNodeKind() == 0) {
            return null;
        }
        IResourceChange resourceChange = storage.asResourceChange(provider);
        if (resourceChange == null || resourceChange.getRevision() == -1L) {
            return null;
        }
        rStatusOp.setPegRevision(resourceChange);
        IRepositoryResource originator = storage.asRepositoryResource(resourceChange.getResource());
        if (originator != null) {
            originator.setSelectedRevision(Revision.getInstance((long)resourceChange.getRevision()));
            originator.setPegRevision(resourceChange.getPegRevision());
            resourceChange.setOriginator(originator);
        }
        resourceChange.setCommentProvider((ICommentProvider)new CommentProvider(){

            public String getComment(IResource resource, Revision rev, Revision peg) {
                String comment = (String)UpdateSubscriber.this.comments.get(rev);
                if (comment == null) {
                    comment = super.getComment(resource, rev, peg);
                    UpdateSubscriber.this.comments.put(rev, comment);
                }
                return comment;
            }
        });
        return resourceChange;
    }

    protected IResource[] findChanges(IResource[] resources, int depth, IProgressMonitor monitor, IOperationWrapperFactory operationWrapperFactory) {
        this.comments.clear();
        return super.findChanges(resources, depth, monitor, operationWrapperFactory);
    }

    private UpdateSubscriber() {
    }
}

