/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.synchronize.merge.action;

import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.local.IUnresolvedConflictDetector;
import org.polarion.team.svn.core.operation.local.MergeOperation;
import org.polarion.team.svn.core.operation.local.RefreshResourcesOperation;
import org.polarion.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.polarion.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.operation.ClearMergeStatusesOperation;
import org.polarion.team.svn.ui.operation.NotifyUnresolvedConflictOperation;
import org.polarion.team.svn.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.polarion.team.svn.ui.synchronize.action.ISyncStateFilter;
import org.polarion.team.svn.ui.synchronize.merge.MergeSubscriber;
import org.polarion.team.svn.ui.synchronize.merge.MergeSyncInfo;

public class UpdateAction
extends AbstractSynchronizeModelAction {
    protected boolean advancedMode;

    public UpdateAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
        this.advancedMode = false;
    }

    public UpdateAction(String text, ISynchronizePageConfiguration configuration, ISelectionProvider selectionProvider) {
        super(text, configuration, selectionProvider);
        this.advancedMode = true;
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{8, 12}){

            public boolean select(SyncInfo info) {
                if (super.select(info)) {
                    MergeSyncInfo sync = (MergeSyncInfo)info;
                    return !IStateFilter.SF_OBSTRUCTED.accept(sync.getLocal(), sync.getLocalResource().getStatus(), sync.getLocalResource().getChangeMask());
                }
                return false;
            }
        };
    }

    protected IActionOperation execute(AbstractSynchronizeModelAction.FilteredSynchronizeModelOperation operation) {
        IResource[] resources = operation.getSelectedResourcesRecursive(ISyncStateFilter.SF_ONREPOSITORY);
        resources = FileUtility.addOperableParents((IResource[])resources, (IStateFilter)IStateFilter.SF_NONVERSIONED);
        if (this.advancedMode) {
            String message;
            if (resources.length == 1) {
                message = SVNTeamUIPlugin.instance().getResource("UpdateAll.Message.Single");
            } else {
                message = SVNTeamUIPlugin.instance().getResource("UpdateAll.Message.Multi");
                message = MessageFormat.format(message, String.valueOf(resources.length));
            }
            final MessageDialog dlg = new MessageDialog(operation.getShell(), SVNTeamUIPlugin.instance().getResource("UpdateAll.Title"), null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            operation.getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    dlg.open();
                }
            });
            if (dlg.getReturnCode() != 0) {
                return null;
            }
        }
        MergeOperation mainOp = new MergeOperation(resources, MergeSubscriber.instance().getMergeScope().getMergeSet(), false);
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources);
        op.add((IActionOperation)saveOp);
        op.add((IActionOperation)mainOp);
        op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
        op.add((IActionOperation)new ClearMergeStatusesOperation((IResourceProvider)mainOp));
        op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)mainOp));
        op.add((IActionOperation)new NotifyUnresolvedConflictOperation((IUnresolvedConflictDetector)mainOp));
        return op;
    }
}

