/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.synchronize.merge;

import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.ui.synchronize.AbstractSynchronizeScope;
import org.eclipse.ui.IMemento;
import org.polarion.team.svn.core.operation.local.MergeSet;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;

public class MergeScope
extends AbstractSynchronizeScope {
    protected MergeSet info;

    public MergeScope(MergeSet info) {
        this.info = info;
    }

    public MergeScope(IMemento memento) {
        super(memento);
    }

    public String getName() {
        if (this.info.to == null || this.info.from == null) {
            return "";
        }
        String url = (this.info.from.length > 1 ? this.info.from[0].getRoot() : this.info.from[0]).getUrl();
        String names = null;
        int i = 0;
        while (i < this.info.to.length) {
            String path = this.info.to[i].getFullPath().toString();
            names = names == null ? path : String.valueOf(names) + ", " + path;
            ++i;
        }
        String message = SVNTeamUIPlugin.instance().getResource("MergeScope.Name");
        return MessageFormat.format(message, url, names);
    }

    public IResource[] getRoots() {
        return this.info.to;
    }

    public void setMergeSet(MergeSet info) {
        this.info = info;
        this.fireRootsChanges();
    }

    public MergeSet getMergeSet() {
        return this.info;
    }
}

