/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.synchronize;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.CheckedInChangeSet;
import org.eclipse.team.internal.ui.synchronize.SyncInfoSetChangeSetCollector;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IResourceChange;
import org.polarion.team.svn.ui.synchronize.SVNChangeSetCapability;
import org.polarion.team.svn.ui.synchronize.variant.ResourceVariant;

public class SVNChangeSetCollector
extends SyncInfoSetChangeSetCollector {
    public SVNChangeSetCollector(ISynchronizePageConfiguration configuration) {
        super(configuration);
    }

    public void dispose() {
        SVNChangeSetCapability.isEnabled = false;
        super.dispose();
    }

    protected void add(SyncInfo[] infos) {
        if (infos == null || infos.length == 0) {
            return;
        }
        final HashMap<String, SVNCheckedInChangeSet> sets = new HashMap<String, SVNCheckedInChangeSet>();
        DateFormat dateTimeFormat = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
        String svnAuthor = SVNTeamPlugin.instance().getResource("SVNInfo.Author");
        String svnDate = SVNTeamPlugin.instance().getResource("SVNInfo.Date");
        String svnNoAuthor = SVNTeamPlugin.instance().getResource("SVNInfo.NoAuthor");
        String svnNoDate = SVNTeamPlugin.instance().getResource("SVNInfo.NoDate");
        int i = 0;
        while (i < infos.length) {
            if ((infos[i].getKind() & 4) == 0) {
                ResourceVariant remote = (ResourceVariant)infos[i].getRemote();
                String id = remote.getContentIdentifier();
                SVNCheckedInChangeSet set = (SVNCheckedInChangeSet)((Object)sets.get(id));
                if (set == null) {
                    ILocalResource resource = remote.getResource();
                    set = new SVNCheckedInChangeSet();
                    set.author = resource.getAuthor();
                    set.date = resource.getLastCommitDate() == 0L ? null : new Date(resource.getLastCommitDate());
                    if (resource instanceof IResourceChange) {
                        set.comment = ((IResourceChange)resource).getComment();
                    }
                    String name = String.valueOf(String.valueOf(resource.getRevision())) + " " + (set.date == null ? svnNoDate : MessageFormat.format(svnDate, dateTimeFormat.format(set.date))) + " " + (resource.getAuthor() == null ? svnNoAuthor : MessageFormat.format(svnAuthor, resource.getAuthor()));
                    if (set.comment != null) {
                        name = String.valueOf(name) + " " + set.comment;
                    }
                    set.setName(name);
                    sets.put(id, set);
                }
                set.add(infos[i]);
            }
            ++i;
        }
        this.performUpdate(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                Iterator it = sets.values().iterator();
                while (it.hasNext()) {
                    SVNCheckedInChangeSet set = (SVNCheckedInChangeSet)((Object)it.next());
                    SVNChangeSetCollector.this.add((ChangeSet)set);
                }
            }
        }, true, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void initializeSets() {
    }

    public static class SVNCheckedInChangeSet
    extends CheckedInChangeSet {
        private String author;
        private String comment;
        private Date date;

        public String getAuthor() {
            return this.author;
        }

        public Date getDate() {
            return this.date;
        }

        public String getComment() {
            return this.comment;
        }

        public void setName(String name) {
            super.setName(name);
        }
    }
}

