/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.synchronize;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.compare.CompareUI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.internal.ui.synchronize.IChangeSetProvider;
import org.eclipse.team.internal.ui.synchronize.ScopableSubscriberParticipant;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizePage;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantDescriptor;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.synchronize.AbstractSVNSubscriber;
import org.polarion.team.svn.ui.synchronize.AbstractSVNSyncInfo;
import org.polarion.team.svn.ui.synchronize.AbstractSynchronizeActionGroup;
import org.polarion.team.svn.ui.synchronize.SVNChangeSetCapability;
import org.polarion.team.svn.ui.synchronize.variant.ResourceVariant;
import org.polarion.team.svn.ui.utility.OverlayedImageDescriptor;

public abstract class AbstractSVNParticipant
extends ScopableSubscriberParticipant
implements IChangeSetProvider {
    protected static ImageDescriptor OVR_OBSTRUCTED;
    protected static ImageDescriptor OVR_REPLACED_OUT;
    protected static ImageDescriptor OVR_REPLACED_IN;
    protected static ImageDescriptor OVR_REPLACED_CONF;
    protected ISynchronizePageConfiguration configuration;
    private ChangeSetCapability capability;

    public AbstractSVNParticipant() {
        this.setDefaults();
    }

    public AbstractSVNParticipant(ISynchronizeScope scope) {
        super(scope);
        this.setSubscriber(this.getMatchingSubscriber());
        this.setDefaults();
    }

    public void init(String secondaryId, IMemento memento) throws PartInitException {
        super.init(secondaryId, memento);
        this.setSubscriber(this.getMatchingSubscriber());
    }

    public ISynchronizePageConfiguration getConfiguration() {
        return this.configuration;
    }

    public synchronized ChangeSetCapability getChangeSetCapability() {
        if (this.capability == null) {
            this.capability = new SVNChangeSetCapability();
        }
        return this.capability;
    }

    protected ISynchronizeParticipantDescriptor getDescriptor() {
        return TeamUI.getSynchronizeManager().getParticipantDescriptor(this.getParticipantId());
    }

    protected boolean isViewerContributionsSupported() {
        return true;
    }

    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        AbstractSynchronizeActionGroup actionGroup;
        super.initializeConfiguration(configuration);
        this.configuration = configuration;
        Collection actionGroups = this.getActionGroups();
        Iterator it = actionGroups.iterator();
        while (it.hasNext()) {
            actionGroup = (AbstractSynchronizeActionGroup)((Object)it.next());
            actionGroup.configureMenuGroups(configuration);
        }
        it = actionGroups.iterator();
        while (it.hasNext()) {
            actionGroup = (AbstractSynchronizeActionGroup)((Object)it.next());
            configuration.addActionContribution((SynchronizePageActionGroup)actionGroup);
        }
        configuration.addLabelDecorator(this.createLabelDecorator());
        configuration.setSupportedModes(this.getSupportedModes());
        configuration.setMode(this.getDefaultMode());
    }

    protected ILabelDecorator createLabelDecorator() {
        return new LabelDecorator();
    }

    protected void refresh() {
        Control control;
        ISynchronizePage page = this.configuration.getPage();
        Viewer viewer = null;
        if (page != null && (viewer = page.getViewer()) != null && viewer.getControl() != null && !(control = viewer.getControl()).isDisposed()) {
            control.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (control.isVisible() && AbstractSVNParticipant.this.configuration.getSite() != null) {
                        int oldMode = AbstractSVNParticipant.this.configuration.getMode();
                        AbstractSVNParticipant.this.configuration.setMode(oldMode != 1 ? 1 : 2);
                        AbstractSVNParticipant.this.configuration.setMode(oldMode);
                    }
                }
            });
        }
    }

    private void setDefaults() {
        if (OVR_REPLACED_OUT == null) {
            SVNTeamUIPlugin instance = SVNTeamUIPlugin.instance();
            OVR_OBSTRUCTED = instance.getImageDescriptor("icons/overlays/obstructed.gif");
            OVR_REPLACED_OUT = instance.getImageDescriptor("icons/overlays/replaced_out.gif");
            OVR_REPLACED_IN = instance.getImageDescriptor("icons/overlays/replaced_in.gif");
            OVR_REPLACED_CONF = instance.getImageDescriptor("icons/overlays/replaced_conf.gif");
        }
    }

    public abstract AbstractSVNSubscriber getMatchingSubscriber();

    protected abstract String getParticipantId();

    protected abstract Collection getActionGroups();

    protected abstract int getSupportedModes();

    protected abstract int getDefaultMode();

    protected class LabelDecorator
    extends LabelProvider
    implements ILabelDecorator {
        public static final int CONFLICTING_REPLACEMENT_MASK = 15;
        public static final int REPLACEMENT_MASK = 3;
        protected Map images = new HashMap();

        public Image decorateImage(Image image, Object element) {
            AbstractSVNSyncInfo info = this.getSyncInfo(element);
            if (info != null) {
                ILocalResource left = info.getLocalResource();
                ILocalResource right = ((ResourceVariant)info.getRemote()).getResource();
                OverlayedImageDescriptor imgDescr = null;
                if (IStateFilter.SF_OBSTRUCTED.accept(left.getResource(), left.getStatus(), left.getChangeMask())) {
                    imgDescr = new OverlayedImageDescriptor(image, OVR_OBSTRUCTED, new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V);
                } else if ((info.getKind() & 0xF) == 15) {
                    if (IStateFilter.SF_PREREPLACEDREPLACED.accept(left.getResource(), left.getStatus(), left.getChangeMask()) || IStateFilter.SF_PREREPLACEDREPLACED.accept(right.getResource(), right.getStatus(), right.getChangeMask())) {
                        imgDescr = new OverlayedImageDescriptor(image, OVR_REPLACED_CONF, new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V);
                    }
                } else if ((info.getKind() & 3) == 3) {
                    if (IStateFilter.SF_PREREPLACEDREPLACED.accept(left.getResource(), left.getStatus(), left.getChangeMask())) {
                        imgDescr = new OverlayedImageDescriptor(image, OVR_REPLACED_OUT, new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V);
                    } else if (IStateFilter.SF_PREREPLACEDREPLACED.accept(right.getResource(), right.getStatus(), right.getChangeMask())) {
                        imgDescr = new OverlayedImageDescriptor(image, OVR_REPLACED_IN, new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V);
                    }
                }
                return this.registerImageDescriptor(imgDescr);
            }
            return null;
        }

        public String decorateText(String text, Object element) {
            ILocalResource remote;
            ResourceVariant variant;
            AbstractSVNSyncInfo info = this.getSyncInfo(element);
            if (info != null && (variant = (ResourceVariant)info.getRemote()) != null && (remote = variant.getResource()).getRevision() != -1L) {
                return String.valueOf(text) + " " + variant.getContentIdentifier();
            }
            return null;
        }

        protected Image registerImageDescriptor(OverlayedImageDescriptor imgDescr) {
            if (imgDescr != null) {
                Image img = (Image)this.images.get((Object)imgDescr);
                if (img == null) {
                    img = imgDescr.createImage();
                    this.images.put(imgDescr, img);
                    CompareUI.disposeOnShutdown((Image)img);
                }
                return img;
            }
            return null;
        }

        protected AbstractSVNSyncInfo getSyncInfo(Object element) {
            if (element instanceof SyncInfoModelElement) {
                return (AbstractSVNSyncInfo)((SyncInfoModelElement)element).getSyncInfo();
            }
            return null;
        }
    }
}

