/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.repository.browser;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.client.Lock;
import org.polarion.team.svn.core.resource.IRepositoryContainer;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.repository.model.IToolTipProvider;
import org.polarion.team.svn.ui.repository.model.RepositoryFictiveWorkingDirectory;
import org.polarion.team.svn.ui.repository.model.RepositoryResource;
import org.polarion.team.svn.ui.utility.TableViewerSorter;

public class RepositoryBrowserTableViewer
extends TableViewer {
    public static final String FMT_REPOSITORY_RESOURCE = "";
    public static final String FMT_REPOSITORY_FILE = "{lock_owner}{lock_creation_date}{lock_expiration_date}{lock_comment}";
    public static final String FMT_REPOSITORY_FOLDER = "";
    public static final String FMT_REPOSITORY_BRANCHES = "";
    public static final String FMT_REPOSITORY_ROOT = "";
    public static final String FMT_REPOSITORY_TAGS = "";
    public static final String FMT_REPOSITORY_TRUNK = "";
    private static final Map class2Format = new HashMap();
    protected static String hasProps;
    protected static String noProps;
    protected static String noAuthor;
    protected int nameColumnIdx;
    protected int revisionColumnIdx;
    protected int dateColumnIdx;
    protected int authorColumnIdx;
    protected int lockOwnerColumnIdx;
    protected int propertiesColumnIdx;
    protected int sizeColumnIdx;
    protected int columnIndexCounter;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.polarion.team.svn.ui.repository.model.RepositoryResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        class2Format.put(clazz, "");
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.polarion.team.svn.ui.repository.model.RepositoryFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        class2Format.put(clazz2, FMT_REPOSITORY_FILE);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.polarion.team.svn.ui.repository.model.RepositoryFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        class2Format.put(clazz3, "");
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.polarion.team.svn.ui.repository.model.RepositoryBranches");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        class2Format.put(clazz4, "");
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.polarion.team.svn.ui.repository.model.RepositoryRoot");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        class2Format.put(clazz5, "");
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("org.polarion.team.svn.ui.repository.model.RepositoryTags");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        class2Format.put(clazz6, "");
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("org.polarion.team.svn.ui.repository.model.RepositoryTrunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        class2Format.put(clazz7, "");
    }

    public RepositoryBrowserTableViewer(Table contentsTable) {
        super(contentsTable);
    }

    public RepositoryBrowserTableViewer(Composite parent, int style) {
        super(new Table(parent, style));
        this.columnIndexCounter = 0;
    }

    public void initialize() {
        noAuthor = SVNTeamPlugin.instance().getResource("SVNInfo.NoAuthor");
        hasProps = SVNTeamUIPlugin.instance().getResource("RepositoriesView.Browser.HasProps");
        noProps = SVNTeamUIPlugin.instance().getResource("RepositoriesView.Browser.NoProps");
        this.getTable().setHeaderVisible(true);
        this.getTable().setLinesVisible(true);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        this.getTable().setLayoutData((Object)data);
        this.getTable().setLayout((Layout)new TableLayout());
        this.getTable().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                Object data;
                String tooltipText = "";
                TableItem item = RepositoryBrowserTableViewer.this.getTable().getItem(new Point(e.x, e.y));
                if (item != null && (data = item.getData()) != null && data instanceof IToolTipProvider) {
                    tooltipText = ((IToolTipProvider)data).getToolTipMessage((String)class2Format.get(data.getClass()));
                }
                RepositoryBrowserTableViewer.this.getTable().setToolTipText(tooltipText);
            }

            public void mouseExit(MouseEvent e) {
                RepositoryBrowserTableViewer.this.getTable().setToolTipText("");
            }
        });
        TableViewerSorter sorter = new TableViewerSorter(this, new TableViewerSorter.IColumnComparator(){

            public int compare(Object row1, Object row2, int column) {
                int ordering = ((TableViewerSorter)RepositoryBrowserTableViewer.this.getSorter()).getOrdering(column);
                if (row1 instanceof RepositoryFictiveWorkingDirectory) {
                    return ordering != 2 ? -1 : 1;
                }
                if (row2 instanceof RepositoryFictiveWorkingDirectory) {
                    return ordering != 2 ? 1 : -1;
                }
                IRepositoryResource rowData1 = ((RepositoryResource)row1).getRepositoryResource();
                IRepositoryResource rowData2 = ((RepositoryResource)row2).getRepositoryResource();
                IRepositoryResource.Info info1 = rowData1.getInfo();
                IRepositoryResource.Info info2 = rowData2.getInfo();
                if (column == RepositoryBrowserTableViewer.this.getNameColumnIndex()) {
                    boolean cnd1 = rowData1 instanceof IRepositoryContainer;
                    boolean cnd2 = rowData2 instanceof IRepositoryContainer;
                    if (cnd1 && !cnd2) {
                        return -1;
                    }
                    if (cnd2 && !cnd1) {
                        return 1;
                    }
                    String name1 = rowData1.getName();
                    String name2 = rowData2.getName();
                    return TableViewerSorter.compare(name1, name2);
                }
                if (column == RepositoryBrowserTableViewer.this.getRevisionColumnIndex()) {
                    try {
                        Long c1 = new Long(rowData1.getRevision());
                        Long c2 = new Long(rowData2.getRevision());
                        return c1.compareTo(c2);
                    }
                    catch (Exception exception) {}
                } else if (info1 != null && info2 != null) {
                    if (column == RepositoryBrowserTableViewer.this.getDateColumnIndex()) {
                        Long c1 = new Long(info1.lastChangedDate != null ? info1.lastChangedDate.getTime() : 0L);
                        Long c2 = new Long(info2.lastChangedDate != null ? info2.lastChangedDate.getTime() : 0L);
                        return c1.compareTo(c2);
                    }
                    if (column == RepositoryBrowserTableViewer.this.getAuthorColumnIndex()) {
                        String author1 = info1.lastAuthor;
                        String author2 = info2.lastAuthor;
                        author1 = author1 != null ? author1 : noAuthor;
                        author2 = author2 != null ? author2 : noAuthor;
                        return TableViewerSorter.compare(author1, author2);
                    }
                    if (column == RepositoryBrowserTableViewer.this.getLockOwnerColumnIndex()) {
                        Lock lock1 = info1.lock;
                        Lock lock2 = info2.lock;
                        String lockOwner1 = lock1 == null ? "" : lock1.owner;
                        String lockOwner2 = lock2 == null ? "" : lock2.owner;
                        return TableViewerSorter.compare(lockOwner1, lockOwner2);
                    }
                    if (column == RepositoryBrowserTableViewer.this.getPropertiesColumnIndex()) {
                        boolean hasProps1 = info1.hasProperties;
                        boolean hasProps2 = info2.hasProperties;
                        String c1 = hasProps1 ? hasProps : noProps;
                        String c2 = hasProps2 ? hasProps : noProps;
                        return TableViewerSorter.compare(c1, c2);
                    }
                    if (column == RepositoryBrowserTableViewer.this.getSizeColumnIndex()) {
                        Long c1 = new Long(info1.fileSize);
                        Long c2 = new Long(info2.fileSize);
                        return c1.compareTo(c2);
                    }
                }
                return 0;
            }
        });
        this.setSorter(sorter);
        this.nameColumnIdx = this.createColumn(sorter, SVNTeamUIPlugin.instance().getResource("RepositoriesView.Browser.Name"), 0, 16384, true, new ColumnWeightData(18, true), this.columnIndexCounter++);
        this.revisionColumnIdx = this.createColumn(sorter, SVNTeamUIPlugin.instance().getResource("RepositoriesView.Browser.Revision"), 0, 131072, true, new ColumnWeightData(9, true), this.columnIndexCounter++);
        this.dateColumnIdx = this.createColumn(sorter, SVNTeamUIPlugin.instance().getResource("RepositoriesView.Browser.LastChangedAt"), 0, 16384, true, new ColumnWeightData(17, true), this.columnIndexCounter++);
        this.authorColumnIdx = this.createColumn(sorter, SVNTeamUIPlugin.instance().getResource("RepositoriesView.Browser.LastChangedBy"), 0, 16384, true, new ColumnWeightData(14, true), this.columnIndexCounter++);
        this.sizeColumnIdx = this.createColumn(sorter, SVNTeamUIPlugin.instance().getResource("RepositoriesView.Browser.Size"), 0, 131072, true, new ColumnWeightData(10, true), this.columnIndexCounter++);
        this.propertiesColumnIdx = this.createColumn(sorter, SVNTeamUIPlugin.instance().getResource("RepositoriesView.Browser.HasProperties"), 0, 16384, true, new ColumnWeightData(12, true), this.columnIndexCounter++);
        this.lockOwnerColumnIdx = this.createColumn(sorter, SVNTeamUIPlugin.instance().getResource("RepositoriesView.Browser.LockOwner"), 0, 16384, true, new ColumnWeightData(13, true), this.columnIndexCounter++);
    }

    protected int createColumn(TableViewerSorter sorter, String name, int style, int alignment, boolean resizable, ColumnWeightData data, int index) {
        TableColumn column = new TableColumn(this.getTable(), style);
        column.setText(name);
        column.setResizable(resizable);
        column.setAlignment(alignment);
        ((TableLayout)this.getTable().getLayout()).addColumnData((ColumnLayoutData)data);
        if (sorter != null) {
            column.addSelectionListener((SelectionListener)sorter);
        }
        return index++;
    }

    public int getAuthorColumnIndex() {
        return this.authorColumnIdx;
    }

    public int getColumnIndexCounter() {
        return this.columnIndexCounter;
    }

    public int getLockOwnerColumnIndex() {
        return this.lockOwnerColumnIdx;
    }

    public int getNameColumnIndex() {
        return this.nameColumnIdx;
    }

    public int getRevisionColumnIndex() {
        return this.revisionColumnIdx;
    }

    public int getPropertiesColumnIndex() {
        return this.propertiesColumnIdx;
    }

    public int getSizeColumnIndex() {
        return this.sizeColumnIdx;
    }

    public int getDateColumnIndex() {
        return this.dateColumnIdx;
    }
}

