/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.preferences;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.compare.internal.TabFolderLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.polarion.team.svn.core.extension.CoreExtensionsManager;
import org.polarion.team.svn.core.extension.factory.ISVNClientWrapperFactory;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.preferences.AbstractSVNTeamPreferencesPage;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;
import org.polarion.team.svn.ui.verifier.CompositeVerifier;
import org.polarion.team.svn.ui.verifier.IntegerFieldVerifier;
import org.polarion.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.polarion.team.svn.ui.verifier.ResourceNameVerifier;

public class SVNTeamPreferencesPage
extends AbstractSVNTeamPreferencesPage {
    protected String head;
    protected String branches;
    protected String tags;
    protected boolean showExternals;
    protected boolean reportRevisionChange;
    protected boolean fastReport;
    protected boolean showMultilineComment;
    protected boolean showAffectedPaths;
    protected boolean pagingEnable;
    protected int pageSize;
    protected boolean usePropertiesView;
    protected boolean mailReporterEnabled;
    protected boolean mailReporterErrorsEnabled;
    protected boolean commitSelectNewResources;
    protected boolean detectDeletedProjects;
    protected boolean useSubversionExternalsBehaviour;
    protected String svnClient;
    protected ISVNClientWrapperFactory[] factories;
    protected boolean useJavaHLMerge;
    protected boolean checkoutUsingDotProjectName;
    protected boolean branchTagConsiderStructure;
    protected boolean forceExternalsFreeze;
    protected boolean computeKeywordsValues;
    protected boolean enableAutoShare;
    protected boolean caseInsensitiveSorting;
    protected Text headField;
    protected Text branchesField;
    protected Text tagsField;
    protected Button showExternalsButton;
    protected Combo svnClientField;
    protected Button useInteractiveMergeButton;
    protected Button reportRevisionChangeButton;
    protected Button fastReportButton;
    protected Button showMultilineCommentButton;
    protected Button showAffectedPathsButton;
    protected Button enablePagingButton;
    protected Text pageSizeField;
    protected Button usePropertiesViewButton;
    protected Button usePropertiesEditorButton;
    protected Button mailReporterEnabledButton;
    protected Button mailReporterErrorsEnabledButton;
    protected Button btnResourceSelectionNew;
    protected Button btnDetectDeletedProjects;
    protected Button btnResourceSelectionExternal;
    protected Button checkoutUsingDotProjectNameButton;
    protected Button branchTagConsiderStructureButton;
    protected Button branchTagManualUrlEditButton;
    protected Button computeKeywordsValuesButton;
    protected Button enableAutoShareButton;
    protected Button caseInsensitiveSortingButton;
    protected Button forceExternalsFreezeButton;

    public String getTitle() {
        return String.valueOf(super.getTitle()) + "  (Subversive " + SVNTeamUIPlugin.instance().getVersionString() + ")";
    }

    protected void saveValues(IPreferenceStore store) {
        SVNTeamPreferences.setRepositoryString(store, "head", this.head);
        SVNTeamPreferences.setRepositoryString(store, "branches", this.branches);
        SVNTeamPreferences.setRepositoryString(store, "tags", this.tags);
        SVNTeamPreferences.setRepositoryBoolean(store, "tagConsideringProjectStructure", this.branchTagConsiderStructure);
        SVNTeamPreferences.setRepositoryBoolean(store, "forceExternalsFreeze", this.forceExternalsFreeze);
        SVNTeamPreferences.setRepositoryBoolean(store, "showExternals", this.showExternals);
        SVNTeamPreferences.setSynchronizeBoolean(store, "reportRevisionChange", this.reportRevisionChange);
        SVNTeamPreferences.setSynchronizeBoolean(store, "fastReport", this.fastReport);
        SVNTeamPreferences.setHistoryBoolean(store, "multilineComment", this.showMultilineComment);
        SVNTeamPreferences.setHistoryBoolean(store, "affectedPaths", this.showAffectedPaths);
        SVNTeamPreferences.setHistoryInt(store, "pageSize", this.pageSize);
        SVNTeamPreferences.setHistoryBoolean(store, "pagingEnable", this.pagingEnable);
        SVNTeamPreferences.setMailReporterBoolean(store, "enabled", this.mailReporterEnabled);
        SVNTeamPreferences.setMailReporterBoolean(store, "errorsEnabled", this.mailReporterErrorsEnabled);
        SVNTeamPreferences.setResourceSelectionBoolean(store, "detectDeleted", this.detectDeletedProjects);
        SVNTeamPreferences.setResourceSelectionBoolean(store, "selectNew", this.commitSelectNewResources);
        SVNTeamPreferences.setResourceSelectionBoolean(store, "treatExternalAsLocal", this.useSubversionExternalsBehaviour);
        String oldId = CoreExtensionsManager.instance().getSVNClientWrapperFactory().getId();
        if (!oldId.equals(this.svnClient)) {
            SVNTeamPreferences.setCoreString(store, "svnclient", this.svnClient);
            SVNRemoteStorage.instance().dispose();
        }
        if (CoreExtensionsManager.instance().getSVNClientWrapperFactory().isInteractiveMergeAllowed()) {
            SVNTeamPreferences.setMergeBoolean(store, "useJavaHL", this.useJavaHLMerge);
        }
        SVNTeamPreferences.setCheckoutBoolean(store, "useDotProject", this.checkoutUsingDotProjectName);
        SVNTeamPreferences.setKeywordsBoolean(store, "computeValues", this.computeKeywordsValues);
        SVNTeamPreferences.setShareBoolean(store, "enableAuto", this.enableAutoShare);
        SVNTeamPreferences.setPropertiesBoolean(store, "useView", this.usePropertiesView);
        SVNTeamPreferences.setTableSortingBoolean(store, "case.insensitive", this.caseInsensitiveSorting);
    }

    protected void loadDefaultValues(IPreferenceStore store) {
        this.head = "trunk";
        this.branches = "branches";
        this.tags = "tags";
        this.showExternals = true;
        this.reportRevisionChange = false;
        this.fastReport = true;
        this.showMultilineComment = true;
        this.showAffectedPaths = true;
        this.pagingEnable = true;
        this.pageSize = 25;
        this.usePropertiesView = true;
        this.mailReporterEnabled = true;
        this.mailReporterErrorsEnabled = true;
        this.commitSelectNewResources = true;
        this.detectDeletedProjects = true;
        this.useSubversionExternalsBehaviour = true;
        this.useJavaHLMerge = true;
        this.checkoutUsingDotProjectName = true;
        this.branchTagConsiderStructure = true;
        this.forceExternalsFreeze = true;
        this.computeKeywordsValues = true;
        this.enableAutoShare = true;
        this.caseInsensitiveSorting = true;
        this.svnClient = "org.polarion.team.svn.client.javahl";
    }

    protected void loadValues(IPreferenceStore store) {
        this.head = SVNTeamPreferences.getRepositoryString(store, "head");
        this.branches = SVNTeamPreferences.getRepositoryString(store, "branches");
        this.tags = SVNTeamPreferences.getRepositoryString(store, "tags");
        this.showExternals = SVNTeamPreferences.getRepositoryBoolean(store, "showExternals");
        this.reportRevisionChange = SVNTeamPreferences.getSynchronizeBoolean(store, "reportRevisionChange");
        this.fastReport = SVNTeamPreferences.getSynchronizeBoolean(store, "fastReport");
        this.showMultilineComment = SVNTeamPreferences.getHistoryBoolean(store, "multilineComment");
        this.showAffectedPaths = SVNTeamPreferences.getHistoryBoolean(store, "affectedPaths");
        this.pagingEnable = SVNTeamPreferences.getHistoryBoolean(store, "pagingEnable");
        this.pageSize = SVNTeamPreferences.getHistoryInt(store, "pageSize");
        this.usePropertiesView = SVNTeamPreferences.getPropertiesBoolean(store, "useView");
        this.mailReporterEnabled = SVNTeamPreferences.getMailReporterBoolean(store, "enabled");
        this.mailReporterErrorsEnabled = SVNTeamPreferences.getMailReporterBoolean(store, "errorsEnabled");
        this.detectDeletedProjects = SVNTeamPreferences.getResourceSelectionBoolean(store, "detectDeleted");
        this.commitSelectNewResources = SVNTeamPreferences.getResourceSelectionBoolean(store, "selectNew");
        this.useSubversionExternalsBehaviour = SVNTeamPreferences.getResourceSelectionBoolean(store, "treatExternalAsLocal");
        this.useJavaHLMerge = SVNTeamPreferences.getMergeBoolean(store, "useJavaHL");
        this.checkoutUsingDotProjectName = SVNTeamPreferences.getCheckoutBoolean(store, "useDotProject");
        this.branchTagConsiderStructure = SVNTeamPreferences.getRepositoryBoolean(store, "tagConsideringProjectStructure");
        this.forceExternalsFreeze = SVNTeamPreferences.getRepositoryBoolean(store, "forceExternalsFreeze");
        this.computeKeywordsValues = SVNTeamPreferences.getKeywordsBoolean(store, "computeValues");
        this.enableAutoShare = SVNTeamPreferences.getShareBoolean(store, "enableAuto");
        this.caseInsensitiveSorting = SVNTeamPreferences.getTableSortingBoolean(store, "case.insensitive");
        this.svnClient = CoreExtensionsManager.instance().getSVNClientWrapperFactory().getId();
    }

    protected void initializeControls() {
        this.headField.setText(this.head);
        this.branchesField.setText(this.branches);
        this.tagsField.setText(this.tags);
        this.showExternalsButton.setSelection(this.showExternals);
        this.reportRevisionChangeButton.setEnabled(CoreExtensionsManager.instance().getSVNClientWrapperFactory(this.svnClient).isReportRevisionChangeAllowed());
        this.reportRevisionChangeButton.setSelection(this.reportRevisionChange);
        this.fastReportButton.setSelection(this.fastReport);
        this.showMultilineCommentButton.setSelection(this.showMultilineComment);
        this.showAffectedPathsButton.setSelection(this.showAffectedPaths);
        this.pageSizeField.setText(String.valueOf(this.pageSize));
        this.enablePagingButton.setSelection(this.pagingEnable);
        this.pageSizeField.setEnabled(this.pagingEnable);
        this.usePropertiesViewButton.setSelection(this.usePropertiesView);
        this.usePropertiesEditorButton.setSelection(!this.usePropertiesViewButton.getSelection());
        this.mailReporterEnabledButton.setSelection(this.mailReporterEnabled);
        this.mailReporterErrorsEnabledButton.setSelection(this.mailReporterErrorsEnabled);
        this.btnDetectDeletedProjects.setSelection(this.detectDeletedProjects);
        this.btnResourceSelectionNew.setSelection(this.commitSelectNewResources);
        this.btnResourceSelectionExternal.setSelection(this.useSubversionExternalsBehaviour);
        List<ISVNClientWrapperFactory> factoriesList = Arrays.asList(this.factories);
        this.svnClientField.select(factoriesList.indexOf(CoreExtensionsManager.instance().getSVNClientWrapperFactory(this.svnClient)));
        this.initializeClientSettings();
        this.checkoutUsingDotProjectNameButton.setSelection(this.checkoutUsingDotProjectName);
        this.branchTagConsiderStructureButton.setSelection(this.branchTagConsiderStructure);
        this.forceExternalsFreezeButton.setSelection(this.forceExternalsFreeze);
        this.branchTagManualUrlEditButton.setSelection(!this.branchTagConsiderStructure);
        this.computeKeywordsValuesButton.setSelection(this.computeKeywordsValues);
        this.enableAutoShareButton.setSelection(this.enableAutoShare);
        this.caseInsensitiveSortingButton.setSelection(this.caseInsensitiveSorting);
    }

    protected void initializeClientSettings() {
        this.useInteractiveMergeButton.setSelection(!this.useJavaHLMerge);
        this.useInteractiveMergeButton.setEnabled(CoreExtensionsManager.instance().getSVNClientWrapperFactory(this.svnClient).isInteractiveMergeAllowed());
    }

    protected Control createContentsImpl(Composite parent) {
        TabFolder tabFolder = new TabFolder(parent, 0);
        tabFolder.setLayout((Layout)new TabFolderLayout());
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.generalTabName"));
        tabItem.setControl(this.createGeneralPage((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.svnClientTabName"));
        tabItem.setControl(this.createSVNClientPage((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.repositoryTabName"));
        tabItem.setControl(this.createRepositorySettingsPage((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.viewSettingsTabName"));
        tabItem.setControl(this.createViewSettingsPage((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.mailReporterGroupName"));
        tabItem.setControl(this.createErrorReportingSettingsPage((Composite)tabFolder));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.polarion.team.svn.help.SVNPreferencesContext");
        return tabFolder;
    }

    protected Control createSVNClientPage(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 64);
        data = new GridData(768);
        data.widthHint = 450;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.svnClientPrompt"));
        label = new Label(composite, 0);
        data = new GridData();
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.svnClient"));
        this.svnClientField = new Combo(composite, 8);
        data = new GridData(768);
        this.svnClientField.setLayoutData((Object)data);
        Collection fullSet = CoreExtensionsManager.instance().getAccessibleClients();
        this.factories = fullSet.toArray(new ISVNClientWrapperFactory[fullSet.size()]);
        FileUtility.sort((Object[])this.factories, (Comparator)new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((ISVNClientWrapperFactory)o1).getName().compareTo(((ISVNClientWrapperFactory)o2).getName());
            }
        });
        String[] items = new String[fullSet.size()];
        int i = 0;
        while (i < items.length) {
            items[i] = String.valueOf(this.factories[i].getName()) + " (" + this.factories[i].getClientVersion().replace('\n', ' ') + ")";
            ++i;
        }
        this.svnClientField.setItems(items);
        this.svnClientField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.svnClient = SVNTeamPreferencesPage.this.factories[SVNTeamPreferencesPage.this.svnClientField.getSelectionIndex()].getId();
                SVNTeamPreferencesPage.this.initializeClientSettings();
                SVNTeamPreferencesPage.this.reportRevisionChangeButton.setEnabled(CoreExtensionsManager.instance().getSVNClientWrapperFactory(SVNTeamPreferencesPage.this.svnClient).isReportRevisionChangeAllowed());
            }
        });
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        data = new GridData(768);
        data.horizontalSpan = 2;
        group.setLayoutData((Object)data);
        group.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.mergeGroupName"));
        label = new Label((Composite)group, 64);
        data = new GridData(768);
        data.widthHint = 450;
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.mergePrompt"));
        this.useInteractiveMergeButton = new Button((Composite)group, 32);
        data = new GridData();
        this.useInteractiveMergeButton.setLayoutData((Object)data);
        this.useInteractiveMergeButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.mergeUseInteractiveMerge"));
        this.useInteractiveMergeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.useJavaHLMerge = !SVNTeamPreferencesPage.this.useInteractiveMergeButton.getSelection();
            }
        });
        return composite;
    }

    protected Control createGeneralPage(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.resourceSelectionGroupName"));
        Label label = new Label((Composite)group, 64);
        data = new GridData(768);
        data.widthHint = 450;
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.resourceSelectionPrompt"));
        this.btnDetectDeletedProjects = new Button((Composite)group, 32);
        data = new GridData();
        this.btnDetectDeletedProjects.setLayoutData((Object)data);
        this.btnDetectDeletedProjects.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.detectDeletedProjects"));
        this.btnDetectDeletedProjects.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.detectDeletedProjects = SVNTeamPreferencesPage.this.btnDetectDeletedProjects.getSelection();
            }
        });
        this.btnResourceSelectionNew = new Button((Composite)group, 32);
        data = new GridData();
        this.btnResourceSelectionNew.setLayoutData((Object)data);
        this.btnResourceSelectionNew.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.resourceSelectionNew"));
        this.btnResourceSelectionNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.commitSelectNewResources = SVNTeamPreferencesPage.this.btnResourceSelectionNew.getSelection();
            }
        });
        this.btnResourceSelectionExternal = new Button((Composite)group, 32);
        data = new GridData();
        this.btnResourceSelectionExternal.setLayoutData((Object)data);
        this.btnResourceSelectionExternal.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.resourceSelectionExternal"));
        this.btnResourceSelectionExternal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.useSubversionExternalsBehaviour = SVNTeamPreferencesPage.this.btnResourceSelectionExternal.getSelection();
            }
        });
        group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.shareGroupName"));
        label = new Label((Composite)group, 64);
        data = new GridData(768);
        data.widthHint = 450;
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.sharePrompt"));
        this.enableAutoShareButton = new Button((Composite)group, 32);
        data = new GridData();
        this.enableAutoShareButton.setLayoutData((Object)data);
        this.enableAutoShareButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.shareEnableAuto"));
        this.enableAutoShareButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.enableAutoShare = SVNTeamPreferencesPage.this.enableAutoShareButton.getSelection();
            }
        });
        group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.keywordsGroupName"));
        label = new Label((Composite)group, 64);
        data = new GridData(768);
        data.widthHint = 450;
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.keywordsPrompt"));
        this.computeKeywordsValuesButton = new Button((Composite)group, 32);
        data = new GridData();
        this.computeKeywordsValuesButton.setLayoutData((Object)data);
        this.computeKeywordsValuesButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.keywordsComputeRecursively"));
        this.computeKeywordsValuesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.computeKeywordsValues = SVNTeamPreferencesPage.this.computeKeywordsValuesButton.getSelection();
            }
        });
        group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.tableSortingGroupName"));
        label = new Label((Composite)group, 64);
        data = new GridData(768);
        data.widthHint = 450;
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.tableSortingPrompt"));
        this.caseInsensitiveSortingButton = new Button((Composite)group, 32);
        data = new GridData();
        this.caseInsensitiveSortingButton.setLayoutData((Object)data);
        this.caseInsensitiveSortingButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.tableSortingCaseInsensitive"));
        this.caseInsensitiveSortingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.caseInsensitiveSorting = SVNTeamPreferencesPage.this.caseInsensitiveSortingButton.getSelection();
            }
        });
        return composite;
    }

    protected Control createViewSettingsPage(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Group synchViewGroup = new Group(composite, 0);
        layout = new GridLayout();
        synchViewGroup.setLayout((Layout)layout);
        data = new GridData(768);
        synchViewGroup.setLayoutData((Object)data);
        Group historyViewGroup = new Group(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        historyViewGroup.setLayout((Layout)layout);
        data = new GridData(768);
        historyViewGroup.setLayoutData((Object)data);
        Group propertiesViewGroup = new Group(composite, 0);
        layout = new GridLayout();
        propertiesViewGroup.setLayout((Layout)layout);
        data = new GridData(768);
        propertiesViewGroup.setLayoutData((Object)data);
        synchViewGroup.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.synchronizeGroupName"));
        Label label = new Label((Composite)synchViewGroup, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.synchronizePrompt"));
        this.reportRevisionChangeButton = new Button((Composite)synchViewGroup, 32);
        data = new GridData();
        this.reportRevisionChangeButton.setLayoutData((Object)data);
        this.reportRevisionChangeButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.synchronizeReportRevisionChangeName"));
        this.reportRevisionChangeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.reportRevisionChange = SVNTeamPreferencesPage.this.reportRevisionChangeButton.getSelection();
            }
        });
        this.reportRevisionChangeButton.setEnabled(CoreExtensionsManager.instance().getSVNClientWrapperFactory().isReportRevisionChangeAllowed());
        this.fastReportButton = new Button((Composite)synchViewGroup, 32);
        data = new GridData();
        this.fastReportButton.setLayoutData((Object)data);
        this.fastReportButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.synchronizeFastReportName"));
        this.fastReportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.fastReport = SVNTeamPreferencesPage.this.fastReportButton.getSelection();
            }
        });
        historyViewGroup.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.historyGroupName"));
        label = new Label((Composite)historyViewGroup, 64);
        data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.historyPrompt"));
        this.showMultilineCommentButton = new Button((Composite)historyViewGroup, 32);
        data = new GridData();
        data.horizontalSpan = 2;
        this.showMultilineCommentButton.setLayoutData((Object)data);
        this.showMultilineCommentButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.historyShowMultilineComment"));
        this.showMultilineCommentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.showMultilineComment = SVNTeamPreferencesPage.this.showMultilineCommentButton.getSelection();
            }
        });
        this.showAffectedPathsButton = new Button((Composite)historyViewGroup, 32);
        data = new GridData();
        data.horizontalSpan = 2;
        this.showAffectedPathsButton.setLayoutData((Object)data);
        this.showAffectedPathsButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.historyShowAffectedPaths"));
        this.showAffectedPathsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.showAffectedPaths = SVNTeamPreferencesPage.this.showAffectedPathsButton.getSelection();
            }
        });
        this.enablePagingButton = new Button((Composite)historyViewGroup, 32);
        data = new GridData();
        this.enablePagingButton.setLayoutData((Object)data);
        String labelText = SVNTeamUIPlugin.instance().getResource("MainPreferencePage.historyEnablePaging");
        this.enablePagingButton.setText(labelText);
        this.enablePagingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SVNTeamPreferencesPage.this.enablePagingButton.getSelection()) {
                    SVNTeamPreferencesPage.this.pageSizeField.setEnabled(true);
                    int tmpPageSize = Integer.parseInt(SVNTeamPreferencesPage.this.pageSizeField.getText());
                    SVNTeamPreferencesPage.this.pageSize = tmpPageSize == 0 ? 25 : tmpPageSize;
                    SVNTeamPreferencesPage.this.pageSizeField.setText(String.valueOf(SVNTeamPreferencesPage.this.pageSize));
                    SVNTeamPreferencesPage.this.pagingEnable = true;
                } else {
                    SVNTeamPreferencesPage.this.pagingEnable = false;
                    SVNTeamPreferencesPage.this.pageSizeField.setEnabled(false);
                }
            }
        });
        this.enablePagingButton.setSelection(this.pagingEnable);
        this.pageSizeField = new Text((Composite)historyViewGroup, 2052);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.pageSizeField.setLayoutData((Object)data);
        CompositeVerifier verifier = new CompositeVerifier();
        verifier.add(new NonEmptyFieldVerifier(labelText));
        verifier.add(new IntegerFieldVerifier(labelText, true));
        this.attachTo((Control)this.pageSizeField, verifier);
        this.pageSizeField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    SVNTeamPreferencesPage.this.pageSize = Integer.parseInt(SVNTeamPreferencesPage.this.pageSizeField.getText());
                }
                catch (Exception exception) {}
            }
        });
        propertiesViewGroup.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.propertiesGroupName"));
        label = new Label((Composite)propertiesViewGroup, 64);
        data = new GridData(768);
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.propertiesPrompt"));
        this.usePropertiesViewButton = new Button((Composite)propertiesViewGroup, 16);
        this.usePropertiesViewButton.setLayoutData((Object)new GridData(768));
        this.usePropertiesViewButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.propertiesUseView"));
        this.usePropertiesViewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.usePropertiesView = SVNTeamPreferencesPage.this.usePropertiesViewButton.getSelection();
            }
        });
        this.usePropertiesEditorButton = new Button((Composite)propertiesViewGroup, 16);
        this.usePropertiesEditorButton.setLayoutData((Object)new GridData(768));
        this.usePropertiesEditorButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.propertiesUseEditor"));
        this.usePropertiesEditorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.usePropertiesView = SVNTeamPreferencesPage.this.usePropertiesViewButton.getSelection();
            }
        });
        return composite;
    }

    protected Control createRepositorySettingsPage(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Group group = new Group(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        group.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.structureGroupName"));
        Label label = new Label((Composite)group, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.repositoryPrompt"));
        label = new Label((Composite)group, 0);
        data = new GridData();
        label.setLayoutData((Object)data);
        String labelText = SVNTeamUIPlugin.instance().getResource("MainPreferencePage.repositoryHeadName");
        label.setText(labelText);
        this.headField = new Text((Composite)group, 2052);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.headField.setLayoutData((Object)data);
        CompositeVerifier verifier = new CompositeVerifier();
        verifier.add(new NonEmptyFieldVerifier(labelText));
        verifier.add(new ResourceNameVerifier(labelText, false));
        this.attachTo((Control)this.headField, verifier);
        this.headField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SVNTeamPreferencesPage.this.head = SVNTeamPreferencesPage.this.headField.getText();
            }
        });
        label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData());
        labelText = SVNTeamUIPlugin.instance().getResource("MainPreferencePage.repositoryBranchesName");
        label.setText(labelText);
        this.branchesField = new Text((Composite)group, 2052);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.branchesField.setLayoutData((Object)data);
        verifier = new CompositeVerifier();
        verifier.add(new NonEmptyFieldVerifier(labelText));
        verifier.add(new ResourceNameVerifier(labelText, false));
        this.attachTo((Control)this.branchesField, verifier);
        this.branchesField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SVNTeamPreferencesPage.this.branches = SVNTeamPreferencesPage.this.branchesField.getText();
            }
        });
        label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData());
        labelText = SVNTeamUIPlugin.instance().getResource("MainPreferencePage.repositoryTagsName");
        label.setText(labelText);
        this.tagsField = new Text((Composite)group, 2052);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.tagsField.setLayoutData((Object)data);
        verifier = new CompositeVerifier();
        verifier.add(new NonEmptyFieldVerifier(labelText));
        verifier.add(new ResourceNameVerifier(labelText, false));
        this.attachTo((Control)this.tagsField, verifier);
        this.tagsField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SVNTeamPreferencesPage.this.tags = SVNTeamPreferencesPage.this.tagsField.getText();
            }
        });
        this.showExternalsButton = new Button((Composite)group, 32);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.showExternalsButton.setLayoutData((Object)data);
        this.showExternalsButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.showExternals"));
        this.showExternalsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.showExternals = ((Button)e.widget).getSelection();
            }
        });
        group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.checkoutGroupName"));
        label = new Label((Composite)group, 64);
        data = new GridData(768);
        data.widthHint = 450;
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.checkoutPrompt"));
        this.checkoutUsingDotProjectNameButton = new Button((Composite)group, 32);
        data = new GridData();
        this.checkoutUsingDotProjectNameButton.setLayoutData((Object)data);
        this.checkoutUsingDotProjectNameButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.checkoutUsingDotProjectName"));
        this.checkoutUsingDotProjectNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.checkoutUsingDotProjectName = SVNTeamPreferencesPage.this.checkoutUsingDotProjectNameButton.getSelection();
            }
        });
        group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.branchTagGroupName"));
        label = new Label((Composite)group, 64);
        data = new GridData(768);
        data.widthHint = 450;
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.branchTagPrompt"));
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.branchTagConsiderStructure = SVNTeamPreferencesPage.this.branchTagConsiderStructureButton.getSelection();
            }
        };
        this.branchTagConsiderStructureButton = new Button((Composite)group, 16);
        this.branchTagConsiderStructureButton.setLayoutData((Object)new GridData());
        this.branchTagConsiderStructureButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.branchTagConsiderStructureLabel"));
        this.branchTagConsiderStructureButton.addSelectionListener((SelectionListener)listener);
        this.branchTagManualUrlEditButton = new Button((Composite)group, 16);
        this.branchTagManualUrlEditButton.setLayoutData((Object)new GridData());
        this.branchTagManualUrlEditButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.branchTagManualLabel"));
        this.branchTagManualUrlEditButton.addSelectionListener((SelectionListener)listener);
        label = new Label((Composite)group, 258);
        data = new GridData(768);
        label.setLayoutData((Object)data);
        this.forceExternalsFreezeButton = new Button((Composite)group, 32);
        data = new GridData(768);
        this.forceExternalsFreezeButton.setLayoutData((Object)data);
        this.forceExternalsFreezeButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.forceFreezeExternals"));
        this.forceExternalsFreezeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.forceExternalsFreeze = ((Button)e.widget).getSelection();
            }
        });
        return composite;
    }

    protected Control createErrorReportingSettingsPage(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 64);
        data = new GridData(768);
        data.widthHint = 450;
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.mailReporterPrompt"));
        this.mailReporterEnabledButton = new Button(composite, 32);
        data = new GridData();
        this.mailReporterEnabledButton.setLayoutData((Object)data);
        this.mailReporterEnabledButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.mailReporterEnabledName"));
        this.mailReporterEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.mailReporterEnabled = SVNTeamPreferencesPage.this.mailReporterEnabledButton.getSelection();
            }
        });
        this.mailReporterErrorsEnabledButton = new Button(composite, 32);
        data = new GridData();
        this.mailReporterErrorsEnabledButton.setLayoutData((Object)data);
        this.mailReporterErrorsEnabledButton.setText(SVNTeamUIPlugin.instance().getResource("MainPreferencePage.mailReporterErrorsEnabledName"));
        this.mailReporterErrorsEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPreferencesPage.this.mailReporterErrorsEnabled = SVNTeamPreferencesPage.this.mailReporterErrorsEnabledButton.getSelection();
            }
        });
        return composite;
    }
}

