/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.preferences;

import java.util.Comparator;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.PlatformUI;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.preferences.AbstractSVNTeamPreferencesPage;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;

public class SVNTeamAnnotatePreferencesPage
extends AbstractSVNTeamPreferencesPage {
    protected ColorFieldEditor rgbEditor;
    protected Composite rgbParent;
    protected int viewType;
    protected String perspective;
    protected IPerspectiveDescriptor[] perspectives;
    protected int perspectiveType;
    protected boolean useOneRGB;
    protected Button useOneRGBButton;
    protected Button defaultViewButton;
    protected Button quickDiffViewButton;
    protected Button promptViewButton;
    protected Button defaultPerspectiveButton;
    protected Button currentPerspectiveButton;
    protected Button promptPerspectiveButton;
    protected Combo perspectiveField;

    public SVNTeamAnnotatePreferencesPage() {
        this.setDescription(SVNTeamUIPlugin.instance().getResource("AnnotatePreferencePage.desc"));
    }

    protected void saveValues(IPreferenceStore store) {
        this.rgbEditor.store();
        SVNTeamPreferences.setAnnotateBoolean(store, "useOneRGB", this.useOneRGB);
        SVNTeamPreferences.setAnnotateInt(store, "useQuickDiff", this.viewType);
        SVNTeamPreferences.setAnnotateInt(store, "changePerspective", this.perspectiveType);
        SVNTeamPreferences.setAnnotateString(store, "perspective", this.perspective);
    }

    protected void loadDefaultValues(IPreferenceStore store) {
        this.rgbEditor.loadDefault();
        this.viewType = 2;
        this.useOneRGB = true;
        this.perspectiveType = 2;
        this.perspective = SVNTeamPreferences.ANNOTATE_PERSPECTIVE_DEFAULT;
    }

    protected void loadValues(IPreferenceStore store) {
        this.rgbEditor.load();
        this.viewType = SVNTeamPreferences.getAnnotateInt(store, "useQuickDiff");
        this.useOneRGB = SVNTeamPreferences.getAnnotateBoolean(store, "useOneRGB");
        this.perspectiveType = SVNTeamPreferences.getAnnotateInt(store, "changePerspective");
        this.perspective = SVNTeamPreferences.getAnnotateString(store, "perspective");
    }

    protected void initializeControls() {
        this.defaultViewButton.setSelection(false);
        this.quickDiffViewButton.setSelection(false);
        this.promptViewButton.setSelection(false);
        if (this.viewType == 0) {
            this.defaultViewButton.setSelection(true);
        } else if (this.viewType == 1) {
            this.quickDiffViewButton.setSelection(true);
        } else {
            this.promptViewButton.setSelection(true);
        }
        this.useOneRGBButton.setSelection(this.useOneRGB);
        this.rgbEditor.setEnabled(this.useOneRGB, this.rgbParent);
        this.defaultPerspectiveButton.setSelection(false);
        this.currentPerspectiveButton.setSelection(false);
        this.promptPerspectiveButton.setSelection(false);
        if (this.perspectiveType == 0) {
            this.defaultPerspectiveButton.setSelection(true);
        } else if (this.perspectiveType == 1) {
            this.currentPerspectiveButton.setSelection(true);
        } else {
            this.promptPerspectiveButton.setSelection(true);
        }
        int idx = -1;
        int i = 0;
        while (i < this.perspectives.length) {
            if (this.perspectives[i].getId().equals(this.perspective)) {
                idx = i;
                break;
            }
            ++i;
        }
        this.perspectiveField.select(idx);
    }

    protected Control createContentsImpl(Composite parent) {
        Composite composite = new Composite(parent, 4);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = false;
        composite.setLayoutData((Object)data);
        Group perspectiveType = new Group(composite, 0);
        perspectiveType.setText(SVNTeamUIPlugin.instance().getResource("AnnotatePreferencePage.textPerspectiveGroup"));
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 10;
        perspectiveType.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.grabExcessVerticalSpace = false;
        perspectiveType.setLayoutData((Object)data);
        this.defaultPerspectiveButton = new Button((Composite)perspectiveType, 16);
        data = new GridData();
        this.defaultPerspectiveButton.setLayoutData((Object)data);
        this.defaultPerspectiveButton.setText(SVNTeamUIPlugin.instance().getResource("AnnotatePreferencePage.textDefaultPerspective"));
        this.defaultPerspectiveButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (SVNTeamAnnotatePreferencesPage.this.defaultPerspectiveButton.getSelection()) {
                    SVNTeamAnnotatePreferencesPage.this.perspectiveType = 0;
                }
            }
        });
        this.currentPerspectiveButton = new Button((Composite)perspectiveType, 16);
        data = new GridData();
        this.currentPerspectiveButton.setLayoutData((Object)data);
        this.currentPerspectiveButton.setText(SVNTeamUIPlugin.instance().getResource("AnnotatePreferencePage.textCurrentPerspective"));
        this.currentPerspectiveButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (SVNTeamAnnotatePreferencesPage.this.currentPerspectiveButton.getSelection()) {
                    SVNTeamAnnotatePreferencesPage.this.perspectiveType = 1;
                }
            }
        });
        this.promptPerspectiveButton = new Button((Composite)perspectiveType, 16);
        data = new GridData();
        this.promptPerspectiveButton.setLayoutData((Object)data);
        this.promptPerspectiveButton.setText(SVNTeamUIPlugin.instance().getResource("AnnotatePreferencePage.textPromptPerspective"));
        this.promptPerspectiveButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (SVNTeamAnnotatePreferencesPage.this.promptPerspectiveButton.getSelection()) {
                    SVNTeamAnnotatePreferencesPage.this.perspectiveType = 2;
                }
            }
        });
        Label separator = new Label(composite, 258);
        data = new GridData(768);
        data.horizontalSpan = 2;
        separator.setLayoutData((Object)data);
        separator.setVisible(false);
        Label label = new Label(composite, 0);
        data = new GridData();
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("AnnotatePreferencePage.textSelectPerspective"));
        this.perspectiveField = new Combo(composite, 8);
        data = new GridData(768);
        this.perspectiveField.setLayoutData((Object)data);
        this.perspectiveField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = SVNTeamAnnotatePreferencesPage.this.perspectiveField.getSelectionIndex();
                SVNTeamAnnotatePreferencesPage.this.perspective = SVNTeamAnnotatePreferencesPage.this.perspectives[idx].getId();
            }
        });
        this.perspectives = PlatformUI.getWorkbench().getPerspectiveRegistry().getPerspectives();
        FileUtility.sort((Object[])this.perspectives, (Comparator)new Comparator(){

            public int compare(Object o1, Object o2) {
                IPerspectiveDescriptor first = (IPerspectiveDescriptor)o1;
                IPerspectiveDescriptor second = (IPerspectiveDescriptor)o2;
                return first.getLabel().compareTo(second.getLabel());
            }
        });
        String[] labels = new String[this.perspectives.length];
        int i = 0;
        while (i < labels.length) {
            labels[i] = this.perspectives[i].getLabel();
            ++i;
        }
        this.perspectiveField.setItems(labels);
        Group showType = new Group(composite, 0);
        showType.setText(SVNTeamUIPlugin.instance().getResource("AnnotatePreferencePage.textViewTypeGroup"));
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 10;
        showType.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.grabExcessVerticalSpace = false;
        showType.setLayoutData((Object)data);
        this.quickDiffViewButton = new Button((Composite)showType, 16);
        data = new GridData();
        this.quickDiffViewButton.setLayoutData((Object)data);
        this.quickDiffViewButton.setText(SVNTeamUIPlugin.instance().getResource("AnnotatePreferencePage.textQuickDiffView"));
        this.quickDiffViewButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (SVNTeamAnnotatePreferencesPage.this.quickDiffViewButton.getSelection()) {
                    SVNTeamAnnotatePreferencesPage.this.viewType = 1;
                }
            }
        });
        this.defaultViewButton = new Button((Composite)showType, 16);
        data = new GridData();
        this.defaultViewButton.setLayoutData((Object)data);
        this.defaultViewButton.setText(SVNTeamUIPlugin.instance().getResource("AnnotatePreferencePage.textDefaultView"));
        this.defaultViewButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (SVNTeamAnnotatePreferencesPage.this.defaultViewButton.getSelection()) {
                    SVNTeamAnnotatePreferencesPage.this.viewType = 0;
                }
            }
        });
        this.promptViewButton = new Button((Composite)showType, 16);
        data = new GridData();
        this.promptViewButton.setLayoutData((Object)data);
        this.promptViewButton.setText(SVNTeamUIPlugin.instance().getResource("AnnotatePreferencePage.textPromptView"));
        this.promptViewButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (SVNTeamAnnotatePreferencesPage.this.promptViewButton.getSelection()) {
                    SVNTeamAnnotatePreferencesPage.this.viewType = 2;
                }
            }
        });
        separator = new Label(composite, 258);
        data = new GridData(768);
        data.horizontalSpan = 2;
        separator.setLayoutData((Object)data);
        separator.setVisible(false);
        this.useOneRGBButton = new Button(composite, 32);
        data = new GridData();
        data.horizontalSpan = 2;
        this.useOneRGBButton.setLayoutData((Object)data);
        this.useOneRGBButton.setText(SVNTeamUIPlugin.instance().getResource("AnnotatePreferencePage.textUseOneRGB"));
        this.useOneRGBButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SVNTeamAnnotatePreferencesPage.this.useOneRGB = SVNTeamAnnotatePreferencesPage.this.useOneRGBButton.getSelection();
                SVNTeamAnnotatePreferencesPage.this.rgbEditor.setEnabled(SVNTeamAnnotatePreferencesPage.this.useOneRGB, SVNTeamAnnotatePreferencesPage.this.rgbParent);
            }
        });
        this.rgbParent = composite;
        this.rgbEditor = new ColorFieldEditor(SVNTeamPreferences.fullAnnotateName("rgbBase"), SVNTeamUIPlugin.instance().getResource("AnnotatePreferencePage.textRGB"), this.rgbParent);
        this.rgbEditor.setPage((DialogPage)this);
        this.rgbEditor.setPreferenceStore(this.getPreferenceStore());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.polarion.team.svn.help.annotatePreferencesContext");
        return composite;
    }
}

