/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.verifier.AbstractVerificationKeyListener;
import org.polarion.team.svn.ui.verifier.AbstractVerifier;
import org.polarion.team.svn.ui.verifier.IValidationManager;

public abstract class AbstractSVNTeamPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage,
IValidationManager {
    private VerificationKeyListener changeListener = new VerificationKeyListener();

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.saveValues(this.getPreferenceStore());
        SVNTeamUIPlugin.instance().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.loadDefaultValues(this.getPreferenceStore());
        this.initializeControls();
        this.validateContent();
    }

    protected Control createContents(Composite parent) {
        Control retVal = this.createContentsImpl(parent);
        this.loadValues(this.getPreferenceStore());
        this.initializeControls();
        this.addListeners();
        return retVal;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return SVNTeamUIPlugin.instance().getPreferenceStore();
    }

    protected abstract void loadDefaultValues(IPreferenceStore var1);

    protected abstract void loadValues(IPreferenceStore var1);

    protected abstract void saveValues(IPreferenceStore var1);

    protected abstract void initializeControls();

    protected abstract Control createContentsImpl(Composite var1);

    public boolean isFilledRight() {
        return this.changeListener.isFilledRight();
    }

    public void attachTo(Control cmp, AbstractVerifier verifier) {
        this.changeListener.attachTo(cmp, verifier);
    }

    public void addListeners() {
        this.changeListener.addListeners();
        this.validateContent();
        this.setMessage(this.getDescription(), 0);
    }

    public void detachFrom(Control cmp) {
        this.changeListener.detachFrom(cmp);
    }

    public void detachAll() {
        this.changeListener.detachAll();
    }

    public void validateContent() {
        this.changeListener.validateContent();
    }

    protected class VerificationKeyListener
    extends AbstractVerificationKeyListener {
        public void hasError(String errorReason) {
            AbstractSVNTeamPreferencesPage.this.setMessage(errorReason, 3);
            this.handleButtons();
        }

        public void hasWarning(String warningReason) {
            AbstractSVNTeamPreferencesPage.this.setMessage(warningReason, 2);
            this.handleButtons();
        }

        public void hasNoError() {
            AbstractSVNTeamPreferencesPage.this.setMessage(AbstractSVNTeamPreferencesPage.this.getDescription(), 0);
            this.handleButtons();
        }

        protected void handleButtons() {
            AbstractSVNTeamPreferencesPage.this.setValid(this.isFilledRight());
        }
    }
}

