/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.panel.view.property;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.client.PropertyData;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.local.RefreshResourcesOperation;
import org.polarion.team.svn.core.operation.local.property.IPropertyProvider;
import org.polarion.team.svn.core.operation.local.property.SetMultiPropertiesOperation;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.StringMatcher;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.panel.AbstractDialogPanel;
import org.polarion.team.svn.ui.panel.view.property.KeywordTableElement;
import org.polarion.team.svn.ui.panel.view.property.SVNKeywordProperty;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;
import org.polarion.team.svn.ui.utility.UserInputHistory;
import org.polarion.team.svn.ui.verifier.AbstractVerifierProxy;
import org.polarion.team.svn.ui.verifier.NonEmptyFieldVerifier;

public class PropertyKeywordEditPanel
extends AbstractDialogPanel {
    protected CheckboxTableViewer checkboxViewer;
    protected Button setRecursivelyCheckbox;
    protected Button useMaskCheckbox;
    protected Combo maskText;
    protected IResource[] selectedResources;
    protected IResource[] alreadyWithProperties;
    protected IPropertyProvider properties;
    protected boolean recursionEnabled;
    protected boolean setRecursively;
    protected String mask;
    protected boolean useMask;
    protected boolean computeStates;
    protected KeywordTableElement dateElement;
    protected KeywordTableElement revisionElement;
    protected KeywordTableElement lastChangedByElement;
    protected KeywordTableElement headUrlElement;
    protected KeywordTableElement idElement;
    protected UserInputHistory maskHistory;

    public PropertyKeywordEditPanel(IResource[] selection, IResourceProvider alreadyWithProperties, IPropertyProvider properties) {
        this.selectedResources = selection;
        this.properties = properties;
        this.alreadyWithProperties = alreadyWithProperties == null ? new IResource[]{} : alreadyWithProperties.getResources();
        this.recursionEnabled = FileUtility.checkForResourcesPresence((IResource[])selection, (IStateFilter)new IStateFilter(){

            public boolean allowsRecursion(IResource resource, String state, int mask) {
                return false;
            }

            public boolean accept(IResource resource, String state, int mask) {
                return resource instanceof IContainer;
            }
        }, (int)0);
        this.dialogTitle = SVNTeamUIPlugin.instance().getResource("PropertyKeywordEditPanel.Title");
        this.dialogDescription = SVNTeamUIPlugin.instance().getResource("PropertyKeywordEditPanel.Description");
        this.defaultMessage = SVNTeamUIPlugin.instance().getResource(this.alreadyWithProperties.length > 1 ? "PropertyKeywordEditPanel.Message.Single" : "PropertyKeywordEditPanel.Message.Multi");
        this.initializeKeywordElements();
    }

    public void createControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.checkboxViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)67584);
        GridData data = new GridData(1808);
        this.checkboxViewer.getTable().setLayoutData((Object)data);
        TableLayout tlayout = new TableLayout();
        this.checkboxViewer.getTable().setLayout((Layout)tlayout);
        TableColumn column = new TableColumn(this.checkboxViewer.getTable(), 16384);
        column.setText(SVNTeamUIPlugin.instance().getResource("PropertyKeywordEditPanel.Keyword"));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        column = new TableColumn(this.checkboxViewer.getTable(), 16384);
        column.setText(SVNTeamUIPlugin.instance().getResource("PropertyKeywordEditPanel.Description1"));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        column = new TableColumn(this.checkboxViewer.getTable(), 16384);
        column.setText(SVNTeamUIPlugin.instance().getResource("PropertyKeywordEditPanel.Sample"));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        final KeywordTableElement[] elements = new KeywordTableElement[]{this.dateElement, this.revisionElement, this.lastChangedByElement, this.headUrlElement, this.idElement};
        this.checkboxViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return elements;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.checkboxViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                KeywordTableElement element = (KeywordTableElement)event.getElement();
                if (element.getCurrentState() == 1) {
                    element.setCurrentState(0);
                } else if (element.getCurrentState() == 0 && element.getInitialState() == 2) {
                    element.setCurrentState(2);
                } else {
                    element.setCurrentState(1);
                }
                PropertyKeywordEditPanel.this.refreshCheckboxState(element);
            }
        });
        this.checkboxViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                KeywordTableElement keyElement = (KeywordTableElement)element;
                switch (columnIndex) {
                    case 0: {
                        return keyElement.getName();
                    }
                    case 1: {
                        return keyElement.getDescription();
                    }
                    case 2: {
                        return keyElement.getSample();
                    }
                }
                return "";
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.checkboxViewer.setInput((Object)elements);
        this.checkboxViewer.getTable().setHeaderVisible(true);
        this.addSelectionButtons(composite);
        if (this.recursionEnabled || this.selectedResources.length > 1) {
            Label separator = new Label(composite, 258);
            separator.setLayoutData((Object)new GridData(768));
            separator = new Label(composite, 258);
            separator.setLayoutData((Object)new GridData(768));
            separator.setVisible(false);
            Composite subComposite = new Composite(composite, 0);
            layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.numColumns = 2;
            subComposite.setLayoutData((Object)new GridData(768));
            subComposite.setLayout((Layout)layout);
            Composite maskComposite = new Composite(subComposite, 0);
            layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.numColumns = 2;
            maskComposite.setLayout((Layout)layout);
            maskComposite.setLayoutData((Object)new GridData(768));
            this.useMaskCheckbox = new Button(maskComposite, 32);
            this.useMaskCheckbox.setText(SVNTeamUIPlugin.instance().getResource("PropertyKeywordEditPanel.UseMask"));
            this.maskHistory = new UserInputHistory("keywordsEditPanel");
            this.maskText = new Combo(maskComposite, 2048);
            this.maskText.setItems(this.maskHistory.getHistory());
            if (this.maskText.getItemCount() == 0) {
                this.maskText.setText("*");
            } else {
                this.maskText.select(0);
            }
            this.maskText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PropertyKeywordEditPanel.this.checkboxViewer.setAllGrayed(false);
                    PropertyKeywordEditPanel.this.changeMixedElementsToChecked();
                }
            });
            this.attachTo((Control)this.maskText, new AbstractVerifierProxy(new NonEmptyFieldVerifier(SVNTeamUIPlugin.instance().getResource("PropertyKeywordEditPanel.Mask.Verifier"))){

                protected boolean isVerificationEnabled(Control input) {
                    return PropertyKeywordEditPanel.this.useMaskCheckbox.getSelection();
                }
            });
            data = new GridData();
            data.widthHint = 170;
            this.maskText.setLayoutData((Object)data);
            this.maskText.setEnabled(false);
            this.useMaskCheckbox.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    PropertyKeywordEditPanel.this.maskText.setEnabled(PropertyKeywordEditPanel.this.useMaskCheckbox.getSelection());
                    PropertyKeywordEditPanel.this.checkboxViewer.setAllGrayed(false);
                    PropertyKeywordEditPanel.this.changeMixedElementsToChecked();
                    PropertyKeywordEditPanel.this.validateContent();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            if (this.recursionEnabled) {
                this.setRecursivelyCheckbox = new Button(subComposite, 32);
                this.setRecursivelyCheckbox.setText(SVNTeamUIPlugin.instance().getResource("PropertyKeywordEditPanel.Recursively"));
                this.setRecursivelyCheckbox.setLayoutData((Object)new GridData(896));
                this.setRecursivelyCheckbox.setSelection(true);
                this.setRecursivelyCheckbox.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        PropertyKeywordEditPanel.this.checkboxViewer.setAllGrayed(false);
                        PropertyKeywordEditPanel.this.changeMixedElementsToChecked();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
        }
        int i = 0;
        while (i < elements.length) {
            this.refreshCheckboxState(elements[i]);
            ++i;
        }
    }

    public String getHelpId() {
        return "org.polarion.team.svn.help.setKeysDialogContext";
    }

    public void performKeywordChanges() {
        IStateFilter filter = IStateFilter.SF_EXCLUDE_PREREPLACED_AND_DELETED_FILES;
        if (this.useMask) {
            filter = new IStateFilter(){
                private StringMatcher fileNameMatcher;
                {
                    this.fileNameMatcher = new StringMatcher(PropertyKeywordEditPanel.this.mask);
                }

                public boolean allowsRecursion(IResource resource, String state, int mask) {
                    return IStateFilter.SF_EXCLUDE_PREREPLACED_AND_DELETED.allowsRecursion(resource, state, mask);
                }

                public boolean accept(IResource resource, String state, int mask) {
                    if (!IStateFilter.SF_EXCLUDE_PREREPLACED_AND_DELETED_FILES.accept(resource, state, mask)) {
                        return false;
                    }
                    return this.fileNameMatcher.match(resource.getName());
                }
            };
        }
        IResourceProvider resourceProvider = new IResourceProvider(){

            public IResource[] getResources() {
                return PropertyKeywordEditPanel.this.selectedResources;
            }
        };
        IPropertyProvider propertyProvider = new IPropertyProvider(){

            public PropertyData[] getProperties(IResource resource) {
                PropertyData[] retVal;
                PropertyData[] propertyDataArray = retVal = PropertyKeywordEditPanel.this.properties == null ? null : PropertyKeywordEditPanel.this.properties.getProperties(resource);
                if (retVal == null) {
                    retVal = new PropertyData[1];
                }
                SVNKeywordProperty keyProperty = new SVNKeywordProperty(retVal[0] == null ? null : retVal[0].value);
                PropertyKeywordEditPanel.this.configureProperty(keyProperty);
                retVal[0] = new PropertyData("svn:keywords", keyProperty.toString(), null);
                return retVal;
            }
        };
        CompositeOperation composite = new CompositeOperation("Operation.SetKeywords");
        composite.add((IActionOperation)new SetMultiPropertiesOperation(resourceProvider, propertyProvider, filter, this.recursionEnabled && this.setRecursively ? 2 : 1));
        composite.add((IActionOperation)new RefreshResourcesOperation(resourceProvider));
        UIMonitorUtility.doTaskScheduledActive((IActionOperation)composite);
    }

    protected void configureProperty(SVNKeywordProperty keyProperty) {
        keyProperty.setDateEnabled(this.dateElement.getCurrentState() == 0 ? true : (this.dateElement.getCurrentState() == 1 ? false : keyProperty.isDateEnabled()));
        keyProperty.setRevisionEnabled(this.revisionElement.getCurrentState() == 0 ? true : (this.revisionElement.getCurrentState() == 1 ? false : keyProperty.isLastChangedByEnabled()));
        keyProperty.setLastChangedByEnabled(this.lastChangedByElement.getCurrentState() == 0 ? true : (this.lastChangedByElement.getCurrentState() == 1 ? false : keyProperty.isLastChangedByEnabled()));
        keyProperty.setHeadUrlEnabled(this.headUrlElement.getCurrentState() == 0 ? true : (this.headUrlElement.getCurrentState() == 1 ? false : keyProperty.isHeadUrlEnabled()));
        keyProperty.setIdEnabled(this.idElement.getCurrentState() == 0 ? true : (this.idElement.getCurrentState() == 1 ? false : keyProperty.isIdEnabled()));
    }

    protected void applyCurrentKeywordValuesOnTableElement(KeywordTableElement tableElement, boolean propertyPresent) {
        tableElement.setInitialState(tableElement.getInitialState() == -1 ? (propertyPresent ? 0 : 1) : (propertyPresent && tableElement.getInitialState() == 1 || !propertyPresent && tableElement.getInitialState() == 0 ? 2 : tableElement.getInitialState()));
        tableElement.setCurrentState(tableElement.getInitialState());
    }

    protected void initializeKeywordElements() {
        this.dateElement = new KeywordTableElement(SVNKeywordProperty.DATE_NAMES[0], SVNKeywordProperty.DATE_DESCR(), "$LastChangedDate: 2006-08-07 15:40:37 +0000 (Mon, 08 Aug 2006) $", -1);
        this.revisionElement = new KeywordTableElement(SVNKeywordProperty.REVISION_NAMES[0], SVNKeywordProperty.REVISION_DESCR(), "$LastChangedRevision: 7206 $", -1);
        this.lastChangedByElement = new KeywordTableElement(SVNKeywordProperty.AUTHOR_NAMES[0], SVNKeywordProperty.AUTHOR_DESCR(), "$LastChangedBy: J.M.Wade $", -1);
        this.headUrlElement = new KeywordTableElement(SVNKeywordProperty.HEAD_URL_NAMES[0], SVNKeywordProperty.HEAD_URL_DESCR(), "$HeadURL: http://svn.polarion.org/community/Subversive/src/svn/ui/PropertyKeywordEditPanel.java $", -1);
        this.idElement = new KeywordTableElement(SVNKeywordProperty.ID_NAMES[0], SVNKeywordProperty.ID_DESCR(), "$Id: PropertyKeywordEditPanel.java 7206 2006-08-07 15:40:37 J.M.Wade $", -1);
        List<IResource> alreadyWithPropertiesList = Arrays.asList(this.alreadyWithProperties);
        int i = 0;
        while (i < this.selectedResources.length) {
            PropertyData[] data;
            SVNKeywordProperty keywordPropertyValue = new SVNKeywordProperty(null);
            if (alreadyWithPropertiesList.contains(this.selectedResources[i]) && this.properties != null && (data = this.properties.getProperties(this.selectedResources[i])) != null) {
                keywordPropertyValue = new SVNKeywordProperty(data[0].value);
            }
            this.applyCurrentKeywordValuesOnTableElement(this.dateElement, keywordPropertyValue.isDateEnabled());
            this.applyCurrentKeywordValuesOnTableElement(this.revisionElement, keywordPropertyValue.isRevisionEnabled());
            this.applyCurrentKeywordValuesOnTableElement(this.lastChangedByElement, keywordPropertyValue.isLastChangedByEnabled());
            this.applyCurrentKeywordValuesOnTableElement(this.headUrlElement, keywordPropertyValue.isHeadUrlEnabled());
            this.applyCurrentKeywordValuesOnTableElement(this.idElement, keywordPropertyValue.isIdEnabled());
            ++i;
        }
    }

    protected void refreshCheckboxState(KeywordTableElement element) {
        this.checkboxViewer.setChecked((Object)element, element.getCurrentState() == 2 || element.getCurrentState() == 0);
        this.checkboxViewer.setGrayed((Object)element, element.getCurrentState() == 2);
    }

    protected void changeMixedElementsToChecked() {
        Object[] elements = this.checkboxViewer.getCheckedElements();
        int i = 0;
        while (i < elements.length) {
            ((KeywordTableElement)elements[i]).setCurrentState(0);
            ++i;
        }
    }

    protected void addSelectionButtons(Composite composite) {
        Composite tComposite = new Composite(composite, 131072);
        GridLayout gLayout = new GridLayout();
        gLayout.numColumns = 2;
        gLayout.marginWidth = 0;
        tComposite.setLayout((Layout)gLayout);
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        tComposite.setData((Object)data);
        Button selectButton = new Button(tComposite, 8);
        selectButton.setText(SVNTeamUIPlugin.instance().getResource("Button.SelectAll"));
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(selectButton);
        selectButton.setLayoutData((Object)data);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyKeywordEditPanel.this.refreshKeywordElements(true);
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = new Button(tComposite, 8);
        deselectButton.setText(SVNTeamUIPlugin.instance().getResource("Button.ClearSelection"));
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(deselectButton);
        deselectButton.setLayoutData((Object)data);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyKeywordEditPanel.this.refreshKeywordElements(false);
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
    }

    protected void refreshKeywordElements(boolean selected) {
        int state = selected ? 0 : 1;
        this.dateElement.setCurrentState(state);
        this.revisionElement.setCurrentState(state);
        this.lastChangedByElement.setCurrentState(state);
        this.headUrlElement.setCurrentState(state);
        this.idElement.setCurrentState(state);
        this.checkboxViewer.setAllChecked(selected);
        this.checkboxViewer.setAllGrayed(false);
    }

    protected void cancelChanges() {
    }

    protected void saveChanges() {
        this.useMask = this.useMaskCheckbox == null ? false : this.useMaskCheckbox.getSelection();
        this.mask = this.maskText == null ? "*" : this.maskText.getText().trim();
        boolean bl = this.setRecursively = this.setRecursivelyCheckbox == null ? false : this.setRecursivelyCheckbox.getSelection();
        if (this.useMask) {
            this.maskHistory.addLine(this.maskText.getText());
        }
    }

    public Point getPrefferedSize() {
        return new Point(670, -1);
    }
}

