/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.panel.view.property;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.polarion.team.svn.core.client.PropertyData;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.composite.ApplyPropertyMethodComposite;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.extension.ExtensionsManager;
import org.polarion.team.svn.ui.extension.factory.PredefinedProperty;
import org.polarion.team.svn.ui.panel.AbstractDialogPanel;
import org.polarion.team.svn.ui.verifier.AbstractVerifierProxy;
import org.polarion.team.svn.ui.verifier.CompositeVerifier;
import org.polarion.team.svn.ui.verifier.ExistingResourceVerifier;
import org.polarion.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.polarion.team.svn.ui.verifier.PropertyNameVerifier;

public class PropertyEditPanel
extends AbstractDialogPanel {
    public static int SINGLE_FILE = 0;
    public static int MULTIPLE_FILES = 1;
    public static int MIXED_RESOURCES = 2;
    protected Combo nameField;
    protected Text valueField;
    protected Text fileField;
    protected Button recursiveButton;
    protected ApplyPropertyMethodComposite applyComposite;
    protected PropertyData source;
    protected int resourcesType;
    protected String propertyName;
    protected String propertyValue;
    protected String propertyFile;
    protected boolean fileSelected;
    protected boolean recursiveSelected;
    protected boolean applyToAll;
    protected boolean applyToFiles;
    protected boolean applyToFolders;
    protected List predefinedProperties;
    protected IResource[] selectedResources;

    public PropertyEditPanel(PropertyData data, IResource[] selectedResources) {
        this.dialogTitle = SVNTeamUIPlugin.instance().getResource(data != null ? "PropertyEditPanel.Title.Edit" : "PropertyEditPanel.Title.Add");
        this.fileSelected = false;
        this.source = data;
        this.selectedResources = selectedResources;
        this.resourcesType = this.computeResourcesType();
        this.predefinedProperties = ExtensionsManager.getInstance().getPredefinedPropertySet().getPredefinedProperties(this.selectedResources);
        this.dialogDescription = SVNTeamUIPlugin.instance().getResource("PropertyEditPanel.Description");
    }

    public boolean isFileSelected() {
        return this.fileSelected;
    }

    public String getPropertyFile() {
        return this.propertyFile;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public boolean isRecursiveSelected() {
        return this.recursiveSelected;
    }

    public int getApplyMethod() {
        return this.applyComposite == null ? 0 : this.applyComposite.getApplyMethod();
    }

    public String getFilterMask() {
        return this.applyComposite == null ? "" : this.applyComposite.getFilterMask();
    }

    public boolean useMask() {
        return this.applyComposite == null ? false : this.applyComposite.useMask();
    }

    public void createControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(SVNTeamUIPlugin.instance().getResource("PropertyEditPanel.Name"));
        this.nameField = new Combo(composite, 0);
        GridData data = new GridData(768);
        this.nameField.setLayoutData((Object)data);
        this.nameField.setItems(this.getPropertyNames(this.predefinedProperties));
        this.nameField.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String selected = PropertyEditPanel.this.nameField.getItem(PropertyEditPanel.this.nameField.getSelectionIndex());
                PredefinedProperty prop = PropertyEditPanel.this.getPredefinedProperty(selected);
                PropertyEditPanel.this.valueField.setText(prop.value);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.nameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PredefinedProperty prop = PropertyEditPanel.this.getPredefinedProperty(PropertyEditPanel.this.nameField.getText());
                if (prop != null) {
                    PropertyEditPanel.this.valueField.setText(prop.value);
                }
            }
        });
        CompositeVerifier verifier = new CompositeVerifier();
        String name = SVNTeamUIPlugin.instance().getResource("PropertyEditPanel.Name.Verifier");
        verifier.add(new NonEmptyFieldVerifier(name));
        verifier.add(new PropertyNameVerifier(name));
        this.attachTo((Control)this.nameField, verifier);
        Button editManual = new Button(composite, 16);
        this.valueField = new Text(composite, 2818);
        data = new GridData();
        editManual.setLayoutData((Object)data);
        editManual.setText(SVNTeamUIPlugin.instance().getResource("PropertyEditPanel.EnterValue"));
        editManual.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Button button = (Button)event.widget;
                PropertyEditPanel.this.valueField.setEnabled(button.getSelection());
                PropertyEditPanel.this.fileSelected = false;
                PropertyEditPanel.this.validateContent();
            }
        });
        editManual.setSelection(true);
        data = new GridData(1808);
        data.heightHint = 100;
        this.valueField.setLayoutData((Object)data);
        this.valueField.selectAll();
        this.valueField.setEnabled(true);
        final Button loadFromFile = new Button(composite, 16);
        Composite subComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        subComposite.setLayout((Layout)layout);
        data = new GridData(768);
        subComposite.setLayoutData((Object)data);
        this.fileField = new Text(subComposite, 2052);
        final Button browse = new Button(subComposite, 8);
        browse.setText(SVNTeamUIPlugin.instance().getResource("Button.Browse"));
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(browse);
        browse.setLayoutData((Object)data);
        browse.setEnabled(false);
        browse.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog fileDialog = new FileDialog(PropertyEditPanel.this.manager.getShell(), 4096);
                String res = fileDialog.open();
                if (res != null) {
                    PropertyEditPanel.this.fileField.setText(res);
                    PropertyEditPanel.this.validateContent();
                }
            }
        });
        data = new GridData();
        loadFromFile.setLayoutData((Object)data);
        loadFromFile.setText(SVNTeamUIPlugin.instance().getResource("PropertyEditPanel.LoadValue"));
        loadFromFile.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Button button = (Button)event.widget;
                PropertyEditPanel.this.fileField.setEnabled(button.getSelection());
                browse.setEnabled(button.getSelection());
                PropertyEditPanel.this.fileSelected = true;
                PropertyEditPanel.this.validateContent();
            }
        });
        data = new GridData(768);
        this.fileField.setLayoutData((Object)data);
        this.fileField.setEnabled(false);
        this.attachTo((Control)this.fileField, new AbstractVerifierProxy(new ExistingResourceVerifier(SVNTeamUIPlugin.instance().getResource("PropertyEditPanel.File.Verifier"), true)){

            protected boolean isVerificationEnabled(Control input) {
                return loadFromFile.getSelection();
            }
        });
        if (this.resourcesType != SINGLE_FILE) {
            if (this.resourcesType == MIXED_RESOURCES) {
                this.recursiveButton = new Button(subComposite, 32);
                this.recursiveButton.setText(SVNTeamUIPlugin.instance().getResource("PropertyEditPanel.Recursively"));
                this.recursiveButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        PropertyEditPanel.this.refreshControlsEnablement();
                        PropertyEditPanel.this.validateContent();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
            this.applyComposite = new ApplyPropertyMethodComposite(composite, 0, this, this.resourcesType);
            this.applyComposite.setLayoutData(new GridData(768));
        }
        if (this.source != null) {
            this.nameField.setText(this.source.name);
            this.valueField.setText(this.source.value);
        }
        this.nameField.setFocus();
        if (this.resourcesType == MIXED_RESOURCES) {
            this.refreshControlsEnablement();
        }
    }

    public String getHelpId() {
        return "org.polarion.team.svn.help.setPropsDialogContext";
    }

    public String getDefaultMessage() {
        if (this.nameField == null) {
            return super.getDefaultMessage();
        }
        PredefinedProperty prop = this.getPredefinedProperty(this.nameField.getText());
        if (prop == null) {
            return SVNTeamUIPlugin.instance().getResource("PropertyEditPanel.UserDefined");
        }
        return prop.description != null && prop.description.trim().length() > 0 ? prop.description : SVNTeamUIPlugin.instance().getResource("PropertyEditPanel.NoDescription");
    }

    protected int computeResourcesType() {
        boolean singleResource = this.selectedResources.length == 1;
        boolean allFiles = true;
        int i = 0;
        while (i < this.selectedResources.length) {
            if (!(this.selectedResources[i] instanceof IFile)) {
                allFiles = false;
                break;
            }
            ++i;
        }
        if (allFiles) {
            return singleResource ? SINGLE_FILE : MULTIPLE_FILES;
        }
        return MIXED_RESOURCES;
    }

    protected void saveChanges() {
        this.propertyName = this.nameField.getText();
        this.propertyValue = this.valueField.getText();
        this.propertyFile = this.fileField.getText();
        if (this.resourcesType != SINGLE_FILE) {
            if (this.resourcesType == MIXED_RESOURCES) {
                this.recursiveSelected = this.recursiveButton.getSelection();
            }
            if (this.recursiveSelected || this.resourcesType == MULTIPLE_FILES) {
                this.applyComposite.saveChanges();
            }
        }
    }

    protected void cancelChanges() {
    }

    protected void refreshControlsEnablement() {
        this.applyComposite.setEnabled(this.recursiveButton.getSelection());
    }

    protected String[] getPropertyNames(List predefinedProperties) {
        ArrayList<String> names = new ArrayList<String>();
        Iterator it = predefinedProperties.iterator();
        while (it.hasNext()) {
            names.add(((PredefinedProperty)it.next()).name);
        }
        String[] propertyNames = names.toArray(new String[names.size()]);
        return propertyNames;
    }

    protected PredefinedProperty getPredefinedProperty(String name) {
        int idx = this.predefinedProperties.indexOf(new PredefinedProperty(name));
        if (idx >= 0) {
            return (PredefinedProperty)this.predefinedProperties.get(idx);
        }
        return null;
    }
}

