/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.panel.remote;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.composite.RevisionComposite;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.panel.AbstractDialogPanel;
import org.polarion.team.svn.ui.verifier.ExistingResourceVerifier;

public class ExportPanel
extends AbstractDialogPanel {
    protected Text locationField;
    protected String location;
    protected RevisionComposite revisionComposite;
    protected IRepositoryResource selectedResource;

    public ExportPanel(IRepositoryResource baseResource) {
        this.dialogTitle = SVNTeamUIPlugin.instance().getResource("ExportPanel.Title");
        this.dialogDescription = SVNTeamUIPlugin.instance().getResource("ExportPanel.Description");
        this.defaultMessage = SVNTeamUIPlugin.instance().getResource("ExportPanel.Message");
        this.selectedResource = baseResource;
    }

    public Revision getSelectedRevision() {
        return this.revisionComposite.getSelectedRevision();
    }

    protected void saveChanges() {
        this.location = this.locationField.getText();
    }

    protected void cancelChanges() {
    }

    public void createControls(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite folderComposite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        folderComposite.setLayout((Layout)layout);
        data = new GridData(768);
        folderComposite.setLayoutData((Object)data);
        Label label = new Label(folderComposite, 0);
        data = new GridData();
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("ExportPanel.Folder"));
        this.locationField = new Text(folderComposite, 2052);
        data = new GridData(768);
        this.locationField.setLayoutData((Object)data);
        this.attachTo((Control)this.locationField, new ExistingResourceVerifier(SVNTeamUIPlugin.instance().getResource("ExportPanel.Folder.Verifier"), false));
        Button browseButton = new Button(folderComposite, 8);
        browseButton.setText(SVNTeamUIPlugin.instance().getResource("Button.Browse"));
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(browseButton);
        browseButton.setLayoutData((Object)data);
        browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DirectoryDialog fileDialog = new DirectoryDialog(ExportPanel.this.manager.getShell());
                fileDialog.setText(SVNTeamUIPlugin.instance().getResource("ExportPanel.ExportFolder"));
                fileDialog.setMessage(SVNTeamUIPlugin.instance().getResource("ExportPanel.ExportFolder.Msg"));
                String path = fileDialog.open();
                if (path != null) {
                    ExportPanel.this.locationField.setText(path);
                }
            }
        });
        this.revisionComposite = new RevisionComposite(parent, this, false, null, Revision.HEAD);
        data = new GridData(768);
        this.revisionComposite.setLayoutData(data);
        this.revisionComposite.setSelectedResource(this.selectedResource);
    }

    public String getHelpId() {
        return "org.polarion.team.svn.help.remote_exportDialogContext";
    }

    public String getLocation() {
        return this.location;
    }
}

