/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.panel.common;

import java.text.MessageFormat;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IRepositoryRoot;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.composite.RepositoryTreeComposite;
import org.polarion.team.svn.ui.panel.AbstractDialogPanel;
import org.polarion.team.svn.ui.repository.model.IParentTreeNode;
import org.polarion.team.svn.ui.repository.model.RepositoryFictiveNode;
import org.polarion.team.svn.ui.repository.model.RepositoryFile;
import org.polarion.team.svn.ui.repository.model.RepositoryFolder;
import org.polarion.team.svn.ui.repository.model.RepositoryLocationFilter;
import org.polarion.team.svn.ui.repository.model.RepositoryResource;
import org.polarion.team.svn.ui.repository.model.RepositoryRevisions;

public class RepositoryTreePanel
extends AbstractDialogPanel {
    protected RepositoryTreeComposite repositoryTree;
    protected IRepositoryResource selectedResource;
    protected IRepositoryResource[] selectedResources;
    protected boolean allowSourcesInTree;
    protected boolean allowFiles;

    public RepositoryTreePanel(String title, IRepositoryResource[] resources, boolean allowSourcesInTree) {
        this(title, SVNTeamUIPlugin.instance().getResource("RepositoryTreePanel.Description"), RepositoryTreePanel.formatMessage(resources), resources, allowSourcesInTree);
    }

    public RepositoryTreePanel(String title, String description, String message, IRepositoryResource[] resources, boolean allowSourcesInTree) {
        this.dialogTitle = title;
        this.dialogDescription = description;
        this.defaultMessage = message;
        this.selectedResources = resources;
        this.allowSourcesInTree = allowSourcesInTree;
        this.allowFiles = false;
    }

    public boolean isAllowFiles() {
        return this.allowFiles;
    }

    public void setAllowFiles(boolean allowFiles) {
        this.allowFiles = allowFiles;
    }

    public IRepositoryResource getSelectedResource() {
        return this.selectedResource;
    }

    public void createControls(Composite parent) {
        this.repositoryTree = this.selectedResources.length > 0 ? new RepositoryTreeComposite(parent, 2048, false, new ProjectRoot(this.selectedResources[0])) : new RepositoryTreeComposite(parent, 2048);
        if (this.repositoryTree.getRepositoryTreeViewer().getInput() instanceof ProjectRoot) {
            ProjectRoot root = (ProjectRoot)this.repositoryTree.getRepositoryTreeViewer().getInput();
            this.repositoryTree.getRepositoryTreeViewer().setExpandedElements(new Object[]{root.getChildren(null)[0]});
        }
        if (this.selectedResources.length > 0) {
            String url = this.selectedResources[0].getRepositoryLocation().getRepositoryRootUrl();
            this.repositoryTree.setFilter(new RepositoryLocationFilter(url){

                public boolean accept(Object obj) {
                    if (obj instanceof RepositoryFile && !RepositoryTreePanel.this.allowFiles || obj instanceof RepositoryRevisions || obj instanceof RepositoryFolder && RepositoryTreePanel.this.isSource(((RepositoryFolder)obj).getRepositoryResource())) {
                        return false;
                    }
                    return super.accept(obj);
                }
            });
        }
        GridData data = new GridData(1808);
        data.heightHint = 185;
        this.repositoryTree.setLayoutData(data);
        this.repositoryTree.getRepositoryTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (RepositoryTreePanel.this.manager != null) {
                    IStructuredSelection selection = (IStructuredSelection)RepositoryTreePanel.this.repositoryTree.getRepositoryTreeViewer().getSelection();
                    RepositoryTreePanel.this.manager.setButtonEnabled(0, !selection.isEmpty() && selection.getFirstElement() instanceof RepositoryResource);
                }
            }
        });
    }

    public String getHelpId() {
        return "org.polarion.team.svn.help.copyMoveToDialogContext";
    }

    protected void saveChanges() {
        IStructuredSelection selection = (IStructuredSelection)this.repositoryTree.getRepositoryTreeViewer().getSelection();
        if (!selection.isEmpty() && selection.getFirstElement() instanceof RepositoryResource) {
            this.selectedResource = ((RepositoryResource)selection.getFirstElement()).getRepositoryResource();
        }
    }

    protected void cancelChanges() {
    }

    protected boolean isSource(IRepositoryResource resource) {
        if (!this.allowSourcesInTree) {
            int i = 0;
            while (i < this.selectedResources.length) {
                if (resource.equals(this.selectedResources[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static String formatMessage(IRepositoryResource[] resources) {
        String message = resources.length == 1 ? SVNTeamUIPlugin.instance().getResource("RepositoryTreePanel.Message.Single") : (resources.length < 5 ? SVNTeamUIPlugin.instance().getResource("RepositoryTreePanel.Message.UpTo4") : SVNTeamUIPlugin.instance().getResource("RepositoryTreePanel.Message.Multi"));
        message = MessageFormat.format(message, FileUtility.getNamesListAsString((Object[])resources));
        return message;
    }

    protected class ProjectRoot
    extends RepositoryFictiveNode
    implements IParentTreeNode {
        protected RepositoryResource[] children;

        public ProjectRoot(IRepositoryResource resource) {
            IRepositoryRoot projectRoot = SVNUtility.getTrunkLocation((IRepositoryResource)resource);
            if (projectRoot.getKind() == 1) {
                projectRoot = projectRoot.getParent();
            }
            this.children = new RepositoryResource[]{RepositoryFolder.wrapChild(null, (IRepositoryResource)projectRoot), RepositoryFolder.wrapChild(null, (IRepositoryResource)resource.getRepositoryLocation().getRepositoryRoot())};
        }

        public boolean hasChildren() {
            return true;
        }

        public Object[] getChildren(Object o) {
            return this.children;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            return null;
        }
    }
}

