/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.panel.common;

import org.eclipse.core.resources.IResource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.ui.composite.RepositoryResourceSelectionComposite;
import org.polarion.team.svn.ui.panel.AbstractDialogPanel;

public abstract class AbstractRepositoryResourceSelectionPanel
extends AbstractDialogPanel {
    protected IRepositoryResource selectedResource;
    protected long currentRevision;
    protected boolean stopOnCopy;
    protected String historyKey;
    protected RepositoryResourceSelectionComposite selectionComposite;
    protected String selectionTitle;
    protected String selectionDescription;
    protected int twoRevisions;

    public AbstractRepositoryResourceSelectionPanel(IRepositoryResource baseResource, long currentRevision, String title, String proposal, String historyKey, boolean stopOnCopy, String selectionTitle, String selectionDescription) {
        this.dialogTitle = title;
        this.dialogDescription = proposal;
        this.stopOnCopy = stopOnCopy;
        this.historyKey = historyKey;
        this.selectedResource = baseResource;
        this.currentRevision = currentRevision;
        this.selectionTitle = selectionTitle;
        this.selectionDescription = selectionDescription;
    }

    public AbstractRepositoryResourceSelectionPanel(IRepositoryResource baseResource, long currentRevision, String title, String proposal, String historyKey, boolean stopOnCopy, String selectionTitle, String selectionDescription, int twoRevisions) {
        this(baseResource, currentRevision, title, proposal, historyKey, stopOnCopy, selectionTitle, selectionDescription);
        this.twoRevisions = twoRevisions;
    }

    public IRepositoryResource[] getSelection(IResource[] to) {
        IRepositoryResource base = this.getSelectedResource();
        if (to.length == 1) {
            return new IRepositoryResource[]{base};
        }
        IRepositoryResource[] retVal = new IRepositoryResource[to.length];
        String baseUrl = base.getUrl();
        int i = 0;
        while (i < retVal.length) {
            String url = String.valueOf(baseUrl) + "/" + to[i].getName();
            retVal[i] = to[i].getType() == 1 ? base.asRepositoryFile(url, false) : base.asRepositoryContainer(url, false);
            ++i;
        }
        return retVal;
    }

    public IRepositoryResource getSelectedResource() {
        return this.selectedResource;
    }

    public void createControls(Composite parent) {
        GridData data = null;
        this.selectionComposite = new RepositoryResourceSelectionComposite(parent, 0, this, this.historyKey, this.selectedResource, this.stopOnCopy, this.selectionTitle, this.selectionDescription, this.twoRevisions);
        data = new GridData(768);
        this.selectionComposite.setLayoutData(data);
        this.selectionComposite.setCurrentRevision(this.currentRevision);
    }

    protected void saveChanges() {
        this.selectedResource = this.selectionComposite.getSelectedResource();
        this.selectionComposite.saveHistory();
    }

    protected void cancelChanges() {
    }
}

