/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.panel.callback;

import org.eclipse.compare.internal.TabFolderLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.polarion.team.svn.core.ICredentialsPrompt;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.ProxySettings;
import org.polarion.team.svn.core.resource.SSHSettings;
import org.polarion.team.svn.core.resource.SSLSettings;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.composite.CredentialsComposite;
import org.polarion.team.svn.ui.composite.ProxyComposite;
import org.polarion.team.svn.ui.composite.SSHComposite;
import org.polarion.team.svn.ui.composite.SSLComposite;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.panel.AbstractDialogPanel;
import org.polarion.team.svn.ui.panel.callback.AskTrustSSLServerPanel;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class PromptCredentialsPanel
extends AbstractDialogPanel {
    public static ICredentialsPrompt DEFAULT_PROMPT = new DefaultPrompt();
    protected String selectedRealm;
    protected CredentialsComposite credentialsComposite;
    protected String username;
    protected String password;
    protected boolean savePassword;
    protected SSHComposite compositeSSH;
    protected SSLComposite compositeSSL;
    protected ProxyComposite proxyComposite;
    protected SSHSettings sshSettings;
    protected SSLSettings sslSettings;
    protected boolean proxyEnabled;
    protected String proxyHost;
    protected int proxyPort;
    protected boolean proxyAuthenticationEnabled;
    protected String proxyUsername;
    protected String proxyPassword;
    protected boolean proxySavePassword;
    protected String rootLocationName;
    protected int connectionType;

    public PromptCredentialsPanel() {
        this("", 0);
    }

    public PromptCredentialsPanel(String forWhat, int connectionType) {
        this.dialogTitle = SVNTeamUIPlugin.instance().getResource("PromptCredentialsPanel.Title");
        this.dialogDescription = SVNTeamUIPlugin.instance().getResource("PromptCredentialsPanel.Description");
        this.rootLocationName = SVNTeamUIPlugin.instance().getResource("PromptCredentialsPanel.LocationRealm");
        this.defaultMessage = forWhat;
        this.connectionType = connectionType;
        this.selectedRealm = this.connectionType != 3 ? forWhat : this.rootLocationName;
        this.sslSettings = new SSLSettings();
        this.sslSettings.setAuthenticationEnabled(true);
        this.sshSettings = new SSHSettings();
        this.sshSettings.setUseKeyFile(true);
        this.savePassword = false;
        this.username = null;
        this.password = null;
    }

    public String getRealmToSave() {
        return this.selectedRealm == this.rootLocationName ? "<Repository Location>" : this.selectedRealm;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setSavePasswordEnabled(boolean savePassword) {
        this.savePassword = savePassword;
    }

    public boolean isSavePasswordEnabled() {
        return this.savePassword;
    }

    public String getSSHPassphrase() {
        return this.sshSettings.getPassPhrase();
    }

    public void setSSHPassphrase(String passphrase) {
        this.sshSettings.setPassPhrase(passphrase);
    }

    public boolean isSSHPassphraseSaved() {
        return this.sshSettings.isPassPhraseSaved();
    }

    public void setSSHPassphraseSaved(boolean passphraseSaved) {
        this.sshSettings.setPassPhraseSaved(passphraseSaved);
    }

    public String getSSHPrivateKeyFile() {
        return this.sshSettings.getPrivateKeyPath();
    }

    public void setSSHPrivateKeyFile(String privateKeyFile) {
        this.sshSettings.setPrivateKeyPath(privateKeyFile);
    }

    public int getSSHPort() {
        return this.sshSettings.getPort();
    }

    public void setSSHPort(int sshPort) {
        this.sshSettings.setPort(sshPort);
    }

    public boolean isSSHPublicKeySelected() {
        return this.sshSettings.isUseKeyFile();
    }

    public void setSSHPublicKeySelected(boolean publicKeySelected) {
        this.sshSettings.setUseKeyFile(publicKeySelected);
    }

    public boolean isSSLAuthenticationEnabled() {
        return this.sslSettings.isAuthenticationEnabled();
    }

    public void setSSLAuthenticationEnabled(boolean sslAuthenticationEnabled) {
        this.sslSettings.setAuthenticationEnabled(sslAuthenticationEnabled);
    }

    public String getSSLCertificatePath() {
        return this.sslSettings.getCertificatePath();
    }

    public void setSSLCertificatePath(String sslCertificatePath) {
        this.sslSettings.setCertificatePath(sslCertificatePath);
    }

    public String getSSLPassphrase() {
        return this.sslSettings.getPassPhrase();
    }

    public void setSSLPassphrase(String sslPassphrase) {
        this.sslSettings.setPassPhrase(sslPassphrase);
    }

    public boolean isSSLPassphraseSaved() {
        return this.sslSettings.isPassPhraseSaved();
    }

    public void setSSLPassphraseSaved(boolean sslPassphraseSaved) {
        this.sslSettings.setPassPhraseSaved(sslPassphraseSaved);
    }

    public boolean isProxyEnabled() {
        return this.proxyEnabled;
    }

    public void setProxyEnabled(boolean proxyEnabled) {
        this.proxyEnabled = proxyEnabled;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public boolean isProxySavePassword() {
        return this.proxySavePassword;
    }

    public void setProxySavePassword(boolean proxySavePassword) {
        this.proxySavePassword = proxySavePassword;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public boolean isProxyAuthenticationEnabled() {
        return this.proxyAuthenticationEnabled;
    }

    public void setProxyAuthenticationEnabled(boolean proxyAuthenticationEnabled) {
        this.proxyAuthenticationEnabled = proxyAuthenticationEnabled;
    }

    public void createControls(Composite parent) {
        TabItem tabItem;
        GridLayout layout = null;
        GridData data = null;
        TabFolder tabFolder = new TabFolder(parent, 0);
        tabFolder.setLayout((Layout)new TabFolderLayout());
        tabFolder.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite((Composite)tabFolder, 0);
        layout = new GridLayout();
        layout.marginHeight = 3;
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        composite.setVisible(this.connectionType != 3 && this.connectionType != 2);
        this.createGeneral(composite);
        if (this.connectionType != 3) {
            if (this.connectionType != 2) {
                tabItem = new TabItem(tabFolder, 0);
                tabItem.setText(SVNTeamUIPlugin.instance().getResource("PromptCredentialsPanel.Tab.General"));
                tabItem.setControl((Control)composite);
                if (this.connectionType == 1) {
                    tabItem = new TabItem(tabFolder, 0);
                    tabItem.setText(SVNTeamUIPlugin.instance().getResource("PromptCredentialsPanel.Tab.SSHSettings"));
                    this.compositeSSH = new SSHComposite((Composite)tabFolder, 0, this, true);
                    this.compositeSSH.setCredentialsInput(this.sshSettings);
                    this.compositeSSH.initialize();
                    tabItem.setControl((Control)this.compositeSSH);
                    if (this.isSSHPublicKeySelected()) {
                        tabFolder.setSelection(new TabItem[]{tabItem});
                    }
                }
            } else {
                tabItem = new TabItem(tabFolder, 0);
                tabItem.setText(SVNTeamUIPlugin.instance().getResource("PromptCredentialsPanel.Tab.SSLSettings"));
                this.compositeSSL = new SSLComposite((Composite)tabFolder, 0, this, true);
                this.compositeSSL.setCredentialsInput(this.sslSettings);
                this.compositeSSL.initialize();
                tabItem.setControl((Control)this.compositeSSL);
            }
        } else {
            tabItem = new TabItem(tabFolder, 0);
            tabItem.setText(SVNTeamUIPlugin.instance().getResource("PromptCredentialsPanel.Tab.ProxySettings"));
            this.proxyComposite = new ProxyComposite((Composite)tabFolder, 0, this, true);
            this.proxyComposite.setProxyEnabled(this.proxyEnabled);
            this.proxyComposite.setHost(this.proxyHost);
            this.proxyComposite.setPort(this.proxyPort);
            this.proxyComposite.setAuthenticationEnabled(this.proxyAuthenticationEnabled);
            this.proxyComposite.setUsername(this.proxyUsername);
            this.proxyComposite.setPassword(this.proxyPassword);
            this.proxyComposite.setSavePassword(this.proxySavePassword);
            this.proxyComposite.initialize();
            tabItem.setControl((Control)this.proxyComposite);
        }
        if (this.connectionType != 3) {
            composite = new Composite(parent, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 1;
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            data = new GridData(768);
            composite.setLayoutData((Object)data);
            Label label = new Label(composite, 0);
            data = new GridData();
            label.setLayoutData((Object)data);
            label.setText(SVNTeamUIPlugin.instance().getResource("PromptCredentialsPanel.ApplyTo"));
            final Combo combo = new Combo(composite, 2056);
            data = new GridData(768);
            combo.setLayoutData((Object)data);
            combo.setItems(new String[]{this.selectedRealm, this.rootLocationName});
            combo.select(0);
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PromptCredentialsPanel.this.selectedRealm = combo.getItem(combo.getSelectionIndex());
                }
            });
        }
    }

    public void postInit() {
        if (this.connectionType == 1) {
            this.compositeSSH.resetChanges();
        }
        if (this.connectionType == 2) {
            this.compositeSSL.resetChanges();
        }
        if (this.connectionType == 3) {
            this.proxyComposite.resetChanges();
        }
        super.postInit();
    }

    protected void createGeneral(Composite parent) {
        this.credentialsComposite = new CredentialsComposite(parent, 0);
        this.credentialsComposite.setUsernameInput(this.username);
        this.credentialsComposite.setPasswordInput(this.password);
        this.credentialsComposite.setPasswordSaved(this.savePassword);
        this.credentialsComposite.initialize();
    }

    protected void saveChanges() {
        if (this.connectionType != 3) {
            this.username = this.credentialsComposite.getUsername().getText().trim();
            this.password = this.credentialsComposite.getPassword().getText().trim();
            this.savePassword = this.credentialsComposite.getSavePassword().getSelection();
            if (this.connectionType == 1) {
                this.compositeSSH.saveChanges();
            }
            if (this.connectionType == 2) {
                this.compositeSSL.saveChanges();
            }
        } else {
            this.proxyComposite.saveChanges();
            this.proxyEnabled = this.proxyComposite.isProxyEnabled();
            if (this.proxyEnabled) {
                this.proxyHost = this.proxyComposite.getHost();
                this.proxyPort = this.proxyComposite.getPort();
                this.proxyAuthenticationEnabled = this.proxyComposite.isAuthenticationEnabled();
                if (this.proxyAuthenticationEnabled) {
                    this.proxyUsername = this.proxyComposite.getUsername();
                    this.proxyPassword = this.proxyComposite.getPassword();
                    this.proxySavePassword = this.proxyComposite.isSavePassword();
                }
            }
        }
    }

    protected void cancelChanges() {
    }

    protected static class DefaultPrompt
    implements ICredentialsPrompt {
        protected String realmToSave;
        protected String username;
        protected String password;
        protected boolean saveCredentials;
        protected boolean sslAuthenticationEnabled;
        protected boolean sslSavePassphrase;
        protected String sslClientCertPassword;
        protected String sslClientCertPath;
        protected boolean sshPublicKeySelected;
        protected String sshPrivateKeyPath;
        protected String sshPrivateKeyPassphrase;
        protected boolean sshPrivateKeyPassphraseSaved;
        protected int sshPort;
        protected boolean proxyEnabled;
        protected String proxyHost;
        protected int proxyPort;
        protected boolean proxyAuthenticationEnabled;
        protected String proxyUsername;
        protected String proxyPassword;
        protected boolean proxySavePassword;

        protected DefaultPrompt() {
        }

        public String getRealmToSave() {
            return this.realmToSave;
        }

        public boolean prompt(IRepositoryLocation location, String realm) {
            return this.showPanel(location, 0, realm);
        }

        public boolean promptSSL(IRepositoryLocation location, String realm) {
            return this.showPanel(location, 2, realm);
        }

        public boolean promptSSH(IRepositoryLocation location, String realm) {
            return this.showPanel(location, 1, realm);
        }

        public boolean promptProxy(IRepositoryLocation location) {
            return this.showPanel(location, 3, location.getUrlAsIs());
        }

        public int askTrustSSLServer(IRepositoryLocation location, String info, boolean allowPermanently) {
            Shell shell = UIMonitorUtility.getShell();
            int[] retVal = new int[1];
            shell.getDisplay().syncExec(new Runnable(this, location, info, allowPermanently, shell, retVal){
                final /* synthetic */ DefaultPrompt this$1;
                private final /* synthetic */ IRepositoryLocation val$location;
                private final /* synthetic */ String val$info;
                private final /* synthetic */ boolean val$allowPermanently;
                private final /* synthetic */ Shell val$shell;
                private final /* synthetic */ int[] val$retVal;
                {
                    this.this$1 = defaultPrompt;
                    this.val$location = iRepositoryLocation;
                    this.val$info = string;
                    this.val$allowPermanently = bl;
                    this.val$shell = shell;
                    this.val$retVal = nArray;
                }

                public void run() {
                    AskTrustSSLServerPanel panel = new AskTrustSSLServerPanel(this.val$location.getUrlAsIs(), this.val$info, this.val$allowPermanently);
                    DefaultDialog dlg = new DefaultDialog(this.val$shell, panel);
                    this.val$retVal[0] = dlg.open();
                }
            });
            return retVal[0] == 0 ? 1 : (retVal[0] == 2 ? 0 : (retVal[0] == 1 ? (allowPermanently ? 2 : 0) : 0));
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean isSaveCredentialsEnabled() {
            return this.saveCredentials;
        }

        public boolean isSSLAuthenticationEnabled() {
            return this.sslAuthenticationEnabled;
        }

        public boolean isSSLSavePassphrase() {
            return this.sslSavePassphrase;
        }

        public String getSSLClientCertPath() {
            return this.sslClientCertPath;
        }

        public String getSSLClientCertPassword() {
            return this.sslClientCertPassword;
        }

        public String getSSHPrivateKeyPath() {
            return this.sshPublicKeySelected ? this.sshPrivateKeyPath : null;
        }

        public String getSSHPrivateKeyPassphrase() {
            return this.sshPublicKeySelected ? this.sshPrivateKeyPassphrase : null;
        }

        public int getSSHPort() {
            return this.sshPort;
        }

        public boolean isSSHPublicKeySelected() {
            return this.sshPublicKeySelected;
        }

        public boolean isSSHPrivateKeyPassphraseSaved() {
            return this.sshPrivateKeyPassphraseSaved;
        }

        public String getProxyHost() {
            return this.proxyHost;
        }

        public int getProxyPort() {
            return this.proxyPort;
        }

        public String getProxyUserName() {
            return this.proxyUsername;
        }

        public String getProxyPassword() {
            return this.proxyPassword;
        }

        public boolean isProxyEnabled() {
            return this.proxyEnabled;
        }

        public boolean isProxyAuthenticationEnabled() {
            return this.proxyAuthenticationEnabled;
        }

        public boolean isSaveProxyPassword() {
            return this.proxySavePassword;
        }

        protected boolean showPanel(IRepositoryLocation inputLocation, int connectionType, String realm) {
            IRepositoryLocation location = inputLocation.getLocationForRealm(realm) != null ? inputLocation.getLocationForRealm(realm) : inputLocation;
            Shell shell = UIMonitorUtility.getShell();
            int[] retVal = new int[1];
            shell.getDisplay().syncExec(new Runnable(this, realm, connectionType, shell, location, retVal){
                final /* synthetic */ DefaultPrompt this$1;
                private final /* synthetic */ String val$realm;
                private final /* synthetic */ int val$connectionType;
                private final /* synthetic */ Shell val$shell;
                private final /* synthetic */ IRepositoryLocation val$location;
                private final /* synthetic */ int[] val$retVal;
                {
                    this.this$1 = defaultPrompt;
                    this.val$realm = string;
                    this.val$connectionType = n;
                    this.val$shell = shell;
                    this.val$location = iRepositoryLocation;
                    this.val$retVal = nArray;
                }

                public void run() {
                    PromptCredentialsPanel panel = new PromptCredentialsPanel(this.val$realm, this.val$connectionType);
                    DefaultDialog dialog = new DefaultDialog(this.val$shell, panel);
                    if (this.val$connectionType != 3) {
                        panel.setUsername(this.val$location.getUsername());
                        panel.setPassword(this.val$location.getPassword());
                        panel.setSavePasswordEnabled(this.val$location.isPasswordSaved());
                        if (this.val$connectionType == 1) {
                            SSHSettings settings = this.val$location.getSSHSettings();
                            panel.setSSHPublicKeySelected(settings.isUseKeyFile());
                            panel.setSSHPrivateKeyFile(settings.getPrivateKeyPath());
                            panel.setSSHPassphrase(settings.getPassPhrase());
                            panel.setSSHPassphraseSaved(settings.isPassPhraseSaved());
                            panel.setSSHPort(settings.getPort());
                        } else if (this.val$connectionType == 2) {
                            SSLSettings settings = this.val$location.getSSLSettings();
                            panel.setSSLAuthenticationEnabled(settings.isAuthenticationEnabled());
                            panel.setSSLCertificatePath(settings.getCertificatePath());
                            panel.setSSLPassphrase(settings.getPassPhrase());
                            panel.setSSLPassphraseSaved(settings.isPassPhraseSaved());
                        }
                    } else {
                        ProxySettings settings = this.val$location.getProxySettings();
                        panel.setProxyEnabled(settings.isEnabled());
                        panel.setProxyHost(settings.getHost());
                        panel.setProxyPort(settings.getPort());
                        panel.setProxyAuthenticationEnabled(settings.isAuthenticationEnabled());
                        panel.setProxyUsername(settings.getUsername());
                        panel.setProxyPassword(settings.getPassword());
                        panel.setProxySavePassword(settings.isPasswordSaved());
                    }
                    this.val$retVal[0] = dialog.open();
                    if (this.val$retVal[0] == 0) {
                        this.this$1.realmToSave = panel.getRealmToSave();
                        if (this.val$connectionType != 3) {
                            this.this$1.username = panel.getUsername();
                            this.this$1.password = panel.getPassword();
                            this.this$1.saveCredentials = panel.isSavePasswordEnabled();
                            if (this.val$connectionType == 1) {
                                this.this$1.sshPublicKeySelected = panel.isSSHPublicKeySelected();
                                this.this$1.sshPrivateKeyPath = panel.getSSHPrivateKeyFile();
                                this.this$1.sshPrivateKeyPassphrase = panel.getSSHPassphrase();
                                this.this$1.sshPort = panel.getSSHPort();
                                this.this$1.sshPrivateKeyPassphraseSaved = panel.isSSHPassphraseSaved();
                            }
                            if (this.val$connectionType == 2) {
                                this.this$1.sslAuthenticationEnabled = panel.isSSLAuthenticationEnabled();
                                this.this$1.sslClientCertPath = panel.getSSLCertificatePath();
                                this.this$1.sslClientCertPassword = panel.getSSLPassphrase();
                                this.this$1.sslSavePassphrase = panel.isSSLPassphraseSaved();
                            }
                        } else {
                            this.this$1.proxyEnabled = panel.isProxyEnabled();
                            this.this$1.proxyHost = panel.getProxyHost();
                            this.this$1.proxyPort = panel.getProxyPort();
                            this.this$1.proxyAuthenticationEnabled = panel.isProxyAuthenticationEnabled();
                            this.this$1.proxyUsername = panel.getProxyUsername();
                            this.this$1.proxyPassword = panel.getProxyPassword();
                            this.this$1.proxySavePassword = panel.isProxySavePassword();
                        }
                    } else {
                        this.this$1.username = null;
                        this.this$1.password = null;
                        this.this$1.saveCredentials = false;
                    }
                }
            });
            return retVal[0] == 0;
        }
    }
}

