/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.panel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.panel.AbstractDialogPanel;

public class ListSelectionPanel
extends AbstractDialogPanel {
    protected Object inputElement;
    protected IBaseLabelProvider labelProvider;
    protected IStructuredContentProvider contentProvider;
    protected List initialSelections = Collections.EMPTY_LIST;
    protected List initialGrayed = Collections.EMPTY_LIST;
    protected Object[] resultSelections;
    protected boolean multipleColumns;
    protected CheckboxTableViewer listViewer;

    public ListSelectionPanel(Object input, IStructuredContentProvider contentProvider, IBaseLabelProvider labelProvider, String description, String defaultMessage) {
        this(input, contentProvider, labelProvider, description, defaultMessage, SVNTeamUIPlugin.instance().getResource("ListSelectionPanel.Title"), false);
    }

    public ListSelectionPanel(Object input, IStructuredContentProvider contentProvider, IBaseLabelProvider labelProvider, String description, String defaultMessage, String title, boolean multipleColumns) {
        this.dialogTitle = title;
        this.inputElement = input;
        this.contentProvider = contentProvider;
        this.labelProvider = labelProvider;
        this.dialogDescription = description;
        this.defaultMessage = defaultMessage;
        this.multipleColumns = multipleColumns;
    }

    public void createControls(Composite parent) {
        this.listViewer = this.createViewer(parent);
        GridData data = new GridData(1808);
        data.heightHint = 120;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.setLabelProvider(this.labelProvider);
        this.listViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ListSelectionPanel.this.validateContent();
            }
        });
        Composite tComposite = new Composite(parent, 131072);
        GridLayout gLayout = new GridLayout();
        gLayout.numColumns = 2;
        gLayout.marginWidth = 0;
        tComposite.setLayout((Layout)gLayout);
        data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        tComposite.setData((Object)data);
        Button selectButton = new Button(tComposite, 8);
        selectButton.setText(SVNTeamUIPlugin.instance().getResource("Button.SelectAll"));
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(selectButton);
        selectButton.setLayoutData((Object)data);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListSelectionPanel.this.listViewer.setAllChecked(true);
                ListSelectionPanel.this.validateContent();
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = new Button(tComposite, 8);
        deselectButton.setText(SVNTeamUIPlugin.instance().getResource("Button.ClearSelection"));
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(deselectButton);
        deselectButton.setLayoutData((Object)data);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListSelectionPanel.this.listViewer.setAllChecked(false);
                ListSelectionPanel.this.validateContent();
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
    }

    public void postInit() {
        this.listViewer.setInput(this.inputElement);
        Iterator it = this.initialSelections.iterator();
        while (it.hasNext()) {
            this.listViewer.setChecked(it.next(), true);
        }
        it = this.initialGrayed.iterator();
        while (it.hasNext()) {
            this.listViewer.setGrayed(it.next(), true);
        }
        super.postInit();
    }

    public Object[] getResultSelections() {
        return this.resultSelections;
    }

    public Object[] getInitialSelections() {
        return this.initialSelections.toArray();
    }

    public void setInitialSelections(Object[] selectedElements) {
        this.initialSelections = Arrays.asList(selectedElements);
    }

    public void setInitialGrayed(Object[] grayedElements) {
        this.initialGrayed = Arrays.asList(grayedElements);
    }

    protected CheckboxTableViewer createViewer(Composite parent) {
        if (!this.multipleColumns) {
            return CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        }
        Table table = new Table(parent, 2080);
        table.setLinesVisible(true);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(SVNTeamUIPlugin.instance().getResource("ListSelectionPanel.Resource"));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(60, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(SVNTeamUIPlugin.instance().getResource("ListSelectionPanel.LocalPresentation"));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
        return new CheckboxTableViewer(table);
    }

    protected void saveChanges() {
        Object[] children = this.contentProvider.getElements(this.inputElement);
        if (children != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            while (i < children.length) {
                if (this.listViewer.getChecked(children[i])) {
                    list.add(children[i]);
                }
                ++i;
            }
            this.resultSelections = list.toArray();
        }
    }

    protected void cancelChanges() {
    }
}

