/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.operation;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.polarion.team.svn.core.client.ClientWrapperAuthenticationException;
import org.polarion.team.svn.core.client.ClientWrapperCancelException;
import org.polarion.team.svn.core.client.ClientWrapperException;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.ActivityCancelledException;
import org.polarion.team.svn.core.operation.HiddenException;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.LoggedOperation;
import org.polarion.team.svn.core.operation.UnreportableException;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.debugmail.Reporter;
import org.polarion.team.svn.ui.dialog.AdvancedDialog;
import org.polarion.team.svn.ui.extension.factory.IMailSettingsProvider;
import org.polarion.team.svn.ui.panel.reporting.ErrorCancelPanel;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class UILoggedOperation
extends LoggedOperation {
    public UILoggedOperation(IActionOperation op) {
        super(op);
    }

    protected void handleError(IStatus errorStatus) {
        super.handleError(errorStatus);
        UILoggedOperation.showError("org.polarion.team.svn.core.svnnature", this.getOperationName(), errorStatus, true);
    }

    public static void showError(final String pluginID, final String operationName, final IStatus errorStatus, final boolean isReportingAllowed) {
        OperationErrorInfo errorInfo = UILoggedOperation.formatMessage(errorStatus, false);
        if (errorInfo == null) {
            return;
        }
        new Thread(){

            public void run() {
                Shell shell = UIMonitorUtility.getShell();
                shell.getDisplay().syncExec(new Runnable(this, shell, pluginID, operationName, errorStatus, isReportingAllowed){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ Shell val$shell;
                    private final /* synthetic */ String val$pluginID;
                    private final /* synthetic */ String val$operationName;
                    private final /* synthetic */ IStatus val$errorStatus;
                    private final /* synthetic */ boolean val$isReportingAllowed;
                    {
                        this.this$1 = var1_1;
                        this.val$shell = shell;
                        this.val$pluginID = string;
                        this.val$operationName = string2;
                        this.val$errorStatus = iStatus;
                        this.val$isReportingAllowed = bl;
                    }

                    public void run() {
                        boolean showCheckBox = SVNTeamPreferences.getMailReporterBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "enabled");
                        boolean doNotShowAgain = UILoggedOperation.showErrorImpl(this.val$shell, this.val$pluginID, this.val$operationName, this.val$errorStatus, this.val$isReportingAllowed, showCheckBox ? SVNTeamUIPlugin.instance().getResource("UILoggedOperation.DontAskSend") : null, null);
                        if (showCheckBox && doNotShowAgain) {
                            SVNTeamPreferences.setMailReporterBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "enabled", false);
                        }
                    }
                });
            }
        }.start();
    }

    public static OperationErrorInfo formatMessage(IStatus status, boolean allowsCancelled) {
        if (!status.isMultiStatus()) {
            Throwable ex = status.getException();
            if (!allowsCancelled && (ex instanceof ClientWrapperCancelException || ex instanceof ActivityCancelledException || ex instanceof OperationCanceledException) || ex instanceof HiddenException) {
                return null;
            }
            String simpleMsg = UILoggedOperation.getSimpleMessage(status);
            if (ex instanceof ClientWrapperCancelException || ex instanceof ActivityCancelledException || ex instanceof OperationCanceledException || ex instanceof ClientWrapperAuthenticationException) {
                return new OperationErrorInfo(simpleMsg, simpleMsg, ex, 1);
            }
            String advancedMsg = UILoggedOperation.getSingleStatusMessage(status);
            return new OperationErrorInfo(simpleMsg, advancedMsg, ex, 1);
        }
        IStatus[] children = status.getChildren();
        String advanceMess = "";
        String simpleMess = "";
        int i = 0;
        while (i < children.length) {
            Throwable exception = children[i].getException();
            if (!(!allowsCancelled && (exception instanceof ClientWrapperCancelException || exception instanceof ActivityCancelledException || exception instanceof OperationCanceledException) || exception instanceof HiddenException)) {
                String simpleMsg = UILoggedOperation.getSimpleMessage(children[i]);
                String advancedMsg = UILoggedOperation.getSingleStatusMessage(children[i]);
                advanceMess = String.valueOf(advanceMess) + (advanceMess.length() == 0 ? advancedMsg : "\n\n" + advancedMsg);
                simpleMess = String.valueOf(simpleMess) + (simpleMess.length() == 0 ? simpleMsg : "\n" + simpleMsg);
                if (exception instanceof ClientWrapperCancelException || exception instanceof ActivityCancelledException || exception instanceof OperationCanceledException || exception instanceof ClientWrapperAuthenticationException) {
                    return new OperationErrorInfo(simpleMess, advanceMess, exception, i + 1);
                }
            }
            ++i;
        }
        return advanceMess.length() == 0 && simpleMess.length() == 0 ? null : new OperationErrorInfo(simpleMess, advanceMess, null, children.length);
    }

    protected static String getSimpleMessage(IStatus status) {
        if (status.getException() instanceof ClientWrapperCancelException || status.getException() instanceof ActivityCancelledException || status.getException() instanceof OperationCanceledException) {
            return SVNTeamUIPlugin.instance().getResource("UILoggedOperation.Cancelled");
        }
        if (status.getException() instanceof ClientWrapperAuthenticationException) {
            return SVNTeamUIPlugin.instance().getResource("UILoggedOperation.Authentication");
        }
        return status.getMessage();
    }

    protected static String getSingleStatusMessage(IStatus status) {
        if (status.getException() == null) {
            if (status.getMessage() != null) {
                return status.getMessage();
            }
            return SVNTeamUIPlugin.instance().getResource("UILoggedOperation.Unknown");
        }
        if (status.getException() instanceof ClientWrapperCancelException || status.getException() instanceof ActivityCancelledException) {
            return SVNTeamUIPlugin.instance().getResource("UILoggedOperation.Cancelled");
        }
        if (status.getException().getMessage() == null) {
            return status.getException().getClass().getName();
        }
        return status.getException().getMessage();
    }

    protected static boolean showErrorImpl(final Shell shell, final String pluginID, final String operationName, final IStatus errorStatus, boolean isReportingAllowed, String optionName, String originalReport) {
        boolean sendReport;
        OperationErrorInfo errorInfo = UILoggedOperation.formatMessage(errorStatus, false);
        final ErrorCancelPanel panel = originalReport == null ? new ErrorCancelPanel(operationName, errorInfo.numberOfErrors, errorInfo.simpleMessage, errorInfo.advancedMessage, sendReport, optionName, errorStatus, pluginID) : new ErrorCancelPanel(operationName, errorInfo.numberOfErrors, errorInfo.simpleMessage, errorInfo.advancedMessage, sendReport, optionName, errorStatus, pluginID, originalReport);
        AdvancedDialog dialog = new AdvancedDialog(shell, panel, (sendReport = isReportingAllowed && SVNTeamPreferences.getMailReporterBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "enabled") && Reporter.checkStatus(errorStatus, new ErrorReasonVisitor())) ? 1 : 0);
        if (dialog.open() == 0 && sendReport) {
            UIMonitorUtility.doTaskNowDefault(shell, (IActionOperation)new AbstractNonLockingOperation("Operation.MailSending"){

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    try {
                        Reporter.sendReport(panel.getMailSettingsProvider(), errorStatus, pluginID, operationName, panel.getComment(), panel.getEmail(), panel.getName(), panel.getReportId());
                    }
                    catch (Exception ex) {
                        UILoggedOperation.showSendingError(ex, shell, panel.getMailSettingsProvider(), panel.getReport());
                    }
                }
            }, false);
        }
        return panel.doNotShowAgain();
    }

    public static void showSendingError(final Throwable ex, final Shell shell, final IMailSettingsProvider provider, final String originalReport) {
        if (SVNTeamPreferences.getMailReporterBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "errorsEnabled")) {
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    String email = provider.getEmailTo();
                    boolean doNotShowAgain = UILoggedOperation.showErrorImpl(shell, "org.polarion.team.svn.core.svnnature", SVNTeamUIPlugin.instance().getResource("UILoggedOperation.SendReport.Error.Title"), (IStatus)new Status(4, "org.polarion.team.svn.core.svnnature", 0, MessageFormat.format(SVNTeamUIPlugin.instance().getResource("UILoggedOperation.SendReport.Error.Message"), email), ex), false, SVNTeamUIPlugin.instance().getResource("UILoggedOperation.SendReport.Error.DontShow"), originalReport);
                    if (doNotShowAgain) {
                        SVNTeamPreferences.setMailReporterBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "errorsEnabled", false);
                    }
                }
            });
        }
    }

    public static class OperationErrorInfo {
        public String simpleMessage;
        public String advancedMessage;
        public Throwable exception;
        public int numberOfErrors;

        public OperationErrorInfo(String simpleMessage, String advancedMessage, Throwable exception, int numberOfErrors) {
            this.simpleMessage = simpleMessage;
            this.advancedMessage = advancedMessage;
            this.exception = exception;
            this.numberOfErrors = numberOfErrors;
        }
    }

    protected static class ErrorReasonVisitor
    implements Reporter.IStatusVisitor {
        protected ErrorReasonVisitor() {
        }

        public boolean visit(IStatus status) {
            Throwable t = status.getException();
            if (t == null || t instanceof OperationCanceledException) {
                return false;
            }
            if (t instanceof ClientWrapperException) {
                if (t instanceof ClientWrapperCancelException || t instanceof ClientWrapperAuthenticationException) {
                    return false;
                }
                return ((ClientWrapperException)t).isRuntime();
            }
            return !(t instanceof UnreportableException);
        }
    }
}

