/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.operation;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.ISVNProgressMonitor;
import org.polarion.team.svn.core.client.Status;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNNullProgressMonitor;
import org.polarion.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.ui.compare.ConflictingFileEditorInput;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class ShowConflictEditorOperation
extends AbstractWorkingCopyOperation {
    public ShowConflictEditorOperation(IResource[] resources) {
        super("Operation.ShowConflictEditor", resources);
    }

    public ShowConflictEditorOperation(IResourceProvider provider) {
        super("Operation.ShowConflictEditor", provider);
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] conflictingResources = this.operableData();
        int i = 0;
        while (i < conflictingResources.length && !monitor.isCanceled()) {
            final IResource current = conflictingResources[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    ShowConflictEditorOperation.this.showEditorFor((IFile)current);
                }
            }, monitor, conflictingResources.length);
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void showEditorFor(IFile resource) throws Exception {
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        IRepositoryLocation location = storage.getRepositoryLocation((IResource)resource);
        ISVNClientWrapper proxy = location.acquireSVNProxy();
        try {
            Status[] status = proxy.status(FileUtility.getWorkingCopyPath((IResource)resource), false, false, false, false, (ISVNProgressMonitor)new SVNNullProgressMonitor());
            if (status.length == 1) {
                IContainer parent = resource.getParent();
                this.openEditor(resource, status[0].conflictWorking == null || status[0].conflictWorking.length() == 0 ? resource : (IFile)parent.findMember(status[0].conflictWorking), (IFile)parent.findMember(status[0].conflictNew), (IFile)parent.findMember(status[0].conflictOld));
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            location.releaseSVNProxy(proxy);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        location.releaseSVNProxy(proxy);
    }

    protected void openEditor(IFile target, IFile left, IFile right, IFile ancestor) throws Exception {
        CompareConfiguration cc = new CompareConfiguration();
        cc.setProperty("org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY", (Object)Boolean.TRUE);
        final ConflictingFileEditorInput compare = new ConflictingFileEditorInput(cc, target, left, right, ancestor);
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            public void run() {
                CompareUI.openCompareEditor((CompareEditorInput)compare);
            }
        });
    }
}

