/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.operation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IRepositoryResourceProvider;
import org.polarion.team.svn.core.resource.IRepositoryRoot;
import org.polarion.team.svn.ui.repository.RepositoriesView;
import org.polarion.team.svn.ui.repository.RepositoryTreeViewer;
import org.polarion.team.svn.ui.repository.model.IDataTreeNode;

public class RefreshRemoteResourcesOperation
extends AbstractRepositoryOperation {
    public RefreshRemoteResourcesOperation(IRepositoryResource[] resources) {
        super("Operation.RefreshRemote", resources);
    }

    public RefreshRemoteResourcesOperation(IRepositoryResourceProvider provider) {
        super("Operation.RefreshRemote", provider);
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource[] resources = this.operableData();
        int i = 0;
        while (i < resources.length) {
            final IRepositoryResource current = resources[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    if (current instanceof IRepositoryRoot && ((IRepositoryRoot)current).getKind() == 0) {
                        RepositoriesView.refresh(current.getRepositoryLocation(), new RefreshVisitor());
                    } else {
                        RepositoriesView.refresh(current, new RefreshVisitor());
                    }
                }
            }, monitor, resources.length);
            ++i;
        }
    }

    protected class RefreshVisitor
    implements RepositoryTreeViewer.IRefreshVisitor {
        protected RefreshVisitor() {
        }

        public void visit(Object element) {
            if (element instanceof IDataTreeNode) {
                ((IDataTreeNode)element).refresh();
            }
        }
    }
}

