/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.operation;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.polarion.team.svn.core.client.ClientWrapperException;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.remote.GetFileContentOperation;
import org.polarion.team.svn.core.resource.IRepositoryFile;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IRepositoryResourceProvider;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;

public class ObtainProjectNameOperation
extends AbstractNonLockingOperation {
    protected IRepositoryResourceProvider resourceProvider;
    protected IRepositoryResource[] resources;
    protected HashMap names2Resources;

    public ObtainProjectNameOperation(IRepositoryResource[] resources) {
        super("Operation.ObtainProjectName");
        this.resources = resources;
        this.names2Resources = new HashMap();
    }

    public ObtainProjectNameOperation(IRepositoryResourceProvider resourceProvider) {
        this((IRepositoryResource[])null);
        this.resourceProvider = resourceProvider;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        final boolean doObtainFromDotProject = SVNTeamPreferences.getCheckoutBoolean(store, "useDotProject");
        final HashSet lowerCaseNames = new HashSet();
        final boolean caseInsensitiveOS = FileUtility.isCaseInsensitiveOS();
        if (this.resourceProvider != null) {
            this.resources = this.resourceProvider.getRepositoryResources();
        }
        int i = 0;
        while (i < this.resources.length && !monitor.isCanceled()) {
            ProgressMonitorUtility.setTaskInfo((IProgressMonitor)monitor, (IActionOperation)this, (String)MessageFormat.format(this.getOperationResource("Scanning"), this.resources[i].getName()));
            final int j = i++;
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    IRepositoryResource resource;
                    IRepositoryLocation location;
                    String name = null;
                    String newName = null;
                    try {
                        name = doObtainFromDotProject ? ObtainProjectNameOperation.this.obtainProjectName(ObtainProjectNameOperation.this.resources[j], monitor) : null;
                    }
                    catch (ClientWrapperException clientWrapperException) {}
                    if (name == null && (location = (resource = ObtainProjectNameOperation.this.resources[j]).getRepositoryLocation()).isStructureEnabled() && location.getTrunkLocation().equals(resource.getName())) {
                        name = resource.getParent() != null ? resource.getParent().getName() : new Path(location.getUrl()).lastSegment();
                        name = FileUtility.formatResourceName((String)name);
                    }
                    String string = name = name == null ? ObtainProjectNameOperation.this.resources[j].getName() : name;
                    if (!(ObtainProjectNameOperation.this.names2Resources.containsKey(name) || caseInsensitiveOS && lowerCaseNames.contains(name.toLowerCase()))) {
                        ObtainProjectNameOperation.this.names2Resources.put(name, ObtainProjectNameOperation.this.resources[j]);
                        if (caseInsensitiveOS) {
                            lowerCaseNames.add(name.toLowerCase());
                        }
                    } else {
                        int k = 1;
                        while (true) {
                            if (!(ObtainProjectNameOperation.this.names2Resources.containsKey(newName = String.valueOf(name) + " (" + k + ")") || caseInsensitiveOS && lowerCaseNames.contains(newName.toLowerCase()))) {
                                ObtainProjectNameOperation.this.names2Resources.put(newName, ObtainProjectNameOperation.this.resources[j]);
                                if (!caseInsensitiveOS) break;
                                lowerCaseNames.add(newName.toLowerCase());
                                break;
                            }
                            ++k;
                        }
                    }
                }
            }, monitor, this.resources.length);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String obtainProjectName(IRepositoryResource resource, IProgressMonitor monitor) throws Exception {
        BufferedReader reader;
        InputStream is;
        block16: {
            String string;
            block14: {
                block15: {
                    String projFileUrl = String.valueOf(resource.getUrl()) + "/.project";
                    IRepositoryFile projFile = resource.getRepositoryLocation().asRepositoryFile(projFileUrl, false);
                    if (!projFile.exists()) return null;
                    GetFileContentOperation op = new GetFileContentOperation((IRepositoryResource)projFile);
                    ProgressMonitorUtility.doTaskExternal((IActionOperation)op, (IProgressMonitor)new NullProgressMonitor());
                    is = op.getContent();
                    reader = null;
                    try {
                        String currentString;
                        reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                        while ((currentString = reader.readLine()) != null) {
                            int last;
                            int first = currentString.indexOf("<name>");
                            if (first < 0 || (last = currentString.indexOf("</name>")) < 0) continue;
                            string = currentString.substring(first + "<name>".length(), last);
                            Object var11_12 = null;
                            if (reader == null) break block14;
                            break block15;
                        }
                        break block16;
                    }
                    catch (Throwable throwable) {
                        Object var11_13 = null;
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Exception exception) {}
                        }
                        try {
                            is.close();
                            throw throwable;
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                }
                try {}
                catch (Exception exception) {}
                reader.close();
            }
            try {}
            catch (Exception exception) {}
            is.close();
            return string;
        }
        Object var11_14 = null;
        if (reader != null) {
            try {}
            catch (Exception exception) {}
            reader.close();
        }
        try {}
        catch (Exception exception) {
            return null;
        }
        is.close();
        return null;
    }

    public HashMap getNames2Resources() {
        return this.names2Resources;
    }
}

