/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.operation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.annotate.AnnotateView;
import org.polarion.team.svn.ui.annotate.BuiltInAnnotate;
import org.polarion.team.svn.ui.annotate.CheckPerspective;
import org.polarion.team.svn.ui.dialog.PromptOptionDialog;
import org.polarion.team.svn.ui.operation.CorrectRevisionOperation;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class LocalShowAnnotationOperation
extends AbstractWorkingCopyOperation {
    protected IWorkbenchPage page;
    protected Revision revision;

    public LocalShowAnnotationOperation(IResource resource, IWorkbenchPage page) {
        this(resource, page, null);
    }

    public LocalShowAnnotationOperation(IResource resource, IWorkbenchPage page, Revision revision) {
        super("Operation.ShowAnnotation", new IResource[]{resource});
        this.page = page;
        this.revision = revision;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource resource = this.operableData()[0];
        ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
        boolean notExists = local == null || IStateFilter.SF_NOTEXISTS.accept(resource, local.getStatus(), local.getChangeMask());
        Revision revision = this.revision;
        if (revision == null) {
            revision = notExists || local.getRevision() == -1L ? Revision.HEAD : Revision.getInstance((long)local.getRevision());
        }
        final int[] viewType = new int[]{SVNTeamPreferences.getAnnotateInt(SVNTeamUIPlugin.instance().getPreferenceStore(), "useQuickDiff")};
        if (notExists) {
            viewType[0] = 0;
        } else if (viewType[0] == 2) {
            new PromptOptionDialog(this.page.getWorkbenchWindow().getShell(), this.getOperationResource("Prompt.Title"), this.getOperationResource("Prompt.Message"), this.getOperationResource("Prompt.Remember"), new PromptOptionDialog.AbstractOptionManager(){

                public void buttonPressed(IPreferenceStore store, int idx, boolean toggle) {
                    int n = viewType[0] = idx == 0 ? 1 : 0;
                    if (toggle) {
                        SVNTeamPreferences.setAnnotateInt(store, "useQuickDiff", viewType[0]);
                    }
                }
            }).open();
        }
        IRepositoryResource remote = SVNRemoteStorage.instance().asRepositoryResource(resource);
        remote.setSelectedRevision(revision);
        CorrectRevisionOperation correctOp = new CorrectRevisionOperation(null, remote, local.getRevision(), resource);
        if (!UIMonitorUtility.doTaskNowDefault((IActionOperation)correctOp, true).isCancelled()) {
            if (viewType[0] == 0) {
                CheckPerspective.run(this.page.getWorkbenchWindow());
                IViewPart viewPart = this.page.showView(AnnotateView.VIEW_ID);
                if (viewPart != null && viewPart instanceof AnnotateView) {
                    ((AnnotateView)viewPart).showEditor(resource, revision, remote.getPegRevision());
                }
            } else {
                new BuiltInAnnotate().open(this.page, remote, (IFile)resource);
            }
        }
    }
}

